/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub;

import java.io.IOException;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublishModeKind;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.ReliabilityKind;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.attributes.TopicAttributes;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;

public interface Domain {
    public void setLogLevel(LogLevel var1);

    public Participant createParticipant(ParticipantAttributes var1, ParticipantListener var2) throws IOException;

    default public Participant createParticipant(ParticipantAttributes att) throws IOException {
        return this.createParticipant(att, null);
    }

    public Publisher createPublisher(Participant var1, PublisherAttributes var2, PublisherListener var3) throws IOException, IllegalArgumentException;

    default public Publisher createPublisher(Participant participant, PublisherAttributes publisherAttributes) throws IOException, IllegalArgumentException {
        return this.createPublisher(participant, publisherAttributes, null);
    }

    public Subscriber createSubscriber(Participant var1, SubscriberAttributes var2, SubscriberListener var3) throws IOException, IllegalArgumentException;

    default public Subscriber createSubscriber(Participant participant, SubscriberAttributes subscriberAttributes) throws IOException, IllegalArgumentException {
        return this.createSubscriber(participant, subscriberAttributes, null);
    }

    public boolean removeParticipant(Participant var1);

    public boolean removePublisher(Publisher var1);

    public boolean removeSubscriber(Subscriber var1);

    public TopicDataType<?> getRegisteredType(Participant var1, String var2);

    public void registerType(Participant var1, TopicDataType<?> var2) throws IllegalArgumentException;

    public void unregisterType(Participant var1, String var2) throws IOException;

    public void stopAll();

    public SubscriberAttributes createSubscriberAttributes();

    public PublisherAttributes createPublisherAttributes();

    public ParticipantAttributes createParticipantAttributes();

    default public ParticipantAttributes createParticipantAttributes(int domainId, String name) {
        ParticipantAttributes participantAttributes = this.createParticipantAttributes();
        participantAttributes.setDomainId(domainId);
        participantAttributes.setLeaseDuration(Time.Infinite);
        participantAttributes.setName(name);
        return participantAttributes;
    }

    default public SubscriberAttributes createSubscriberAttributes(Participant participant, TopicDataType<?> topicDataType, String topicName, ReliabilityKind reliabilityKind, String ... partitions) {
        TopicDataType<?> registeredType = this.getRegisteredType(participant, topicDataType.getName());
        if (registeredType == null) {
            this.registerType(participant, topicDataType);
        }
        SubscriberAttributes subscriberAttributes = this.createSubscriberAttributes();
        subscriberAttributes.getTopic().setTopicKind(topicDataType.isGetKeyDefined() ? TopicAttributes.TopicKind.WITH_KEY : TopicAttributes.TopicKind.NO_KEY);
        subscriberAttributes.getTopic().setTopicDataType(topicDataType.getName());
        subscriberAttributes.getTopic().setTopicName(topicName);
        subscriberAttributes.getQos().setReliabilityKind(reliabilityKind);
        if (partitions != null) {
            for (String partition : partitions) {
                subscriberAttributes.getQos().addPartition(partition);
            }
        }
        return subscriberAttributes;
    }

    default public PublisherAttributes createPublisherAttributes(Participant participant, TopicDataType<?> topicDataType, String topicName, ReliabilityKind reliablity, String ... partitions) {
        TopicDataType<?> registeredType = this.getRegisteredType(participant, topicDataType.getName());
        if (registeredType == null) {
            this.registerType(participant, topicDataType);
        }
        PublisherAttributes publisherAttributes = this.createPublisherAttributes();
        publisherAttributes.getTopic().setTopicKind(topicDataType.isGetKeyDefined() ? TopicAttributes.TopicKind.WITH_KEY : TopicAttributes.TopicKind.NO_KEY);
        publisherAttributes.getTopic().setTopicDataType(topicDataType.getName());
        publisherAttributes.getTopic().setTopicName(topicName);
        publisherAttributes.getQos().setReliabilityKind(reliablity);
        if (partitions != null) {
            for (String partition : partitions) {
                publisherAttributes.getQos().addPartition(partition);
            }
        }
        if (topicDataType.getTypeSize() > 65000) {
            publisherAttributes.getQos().setPublishMode(PublishModeKind.ASYNCHRONOUS_PUBLISH_MODE);
        }
        return publisherAttributes;
    }
}

