/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.idl;

import gnu.trove.list.array.TByteArrayList;
import gnu.trove.list.array.TCharArrayList;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.list.array.TShortArrayList;
import org.apache.commons.lang3.NotImplementedException;
import us.ihmc.commons.lists.PreallocatedEnumList;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.idl.CDR;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;

public interface IDLSequence {
    public void resetQuick();

    public int size();

    public int capacity();

    default public int remaining() {
        return this.capacity() - this.size();
    }

    public void readElement(int var1, CDR var2);

    public void writeElement(int var1, CDR var2);

    public static class Object<T>
    extends RecyclingArrayList<T>
    implements IDLSequence {
        private final TopicDataType<T> topicDataType;

        public Object(int maxSize, Class<T> clazz, TopicDataType<T> topicDataType) {
            this(maxSize, topicDataType);
        }

        public Object(int maxSize, TopicDataType<T> topicDataType) {
            super(maxSize, topicDataType::createData);
            this.topicDataType = topicDataType;
        }

        @Override
        public void resetQuick() {
            this.clear();
        }

        @Override
        public int capacity() {
            return java.lang.Integer.MAX_VALUE;
        }

        @Override
        public void readElement(int i, CDR cdr) {
            java.lang.Object val = this.add();
            this.topicDataType.deserialize(val, cdr);
        }

        @Override
        public void writeElement(int i, CDR cdr) {
            this.topicDataType.serialize(this.get(i), cdr);
        }

        public void set(Object<T> other) {
            this.clear();
            for (int i = 0; i < other.size(); ++i) {
                java.lang.Object val = this.add();
                this.topicDataType.copy(other.get(i), val);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.get(i));
            }
            builder.append("]");
            return builder.toString();
        }

        public TopicDataType<T> getTopicDataType() {
            return this.topicDataType;
        }
    }

    public static class Enum<T extends java.lang.Enum>
    extends PreallocatedEnumList<T>
    implements IDLSequence {
        public Enum(int maxSize, Class<T> clazz, T[] constants) {
            super(clazz, constants, maxSize);
        }

        @Override
        public void readElement(int i, CDR cdr) {
            this.add(this.getEnumConstants()[cdr.read_type_c()]);
        }

        @Override
        public void writeElement(int i, CDR cdr) {
            cdr.write_type_c(this.get(i).ordinal());
        }

        public void set(Enum<T> other) {
            this.clear();
            for (int i = 0; i < other.size(); ++i) {
                this.add(other.get(i));
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.get(i));
            }
            builder.append("]");
            return builder.toString();
        }
    }

    public static class StringBuilderHolder
    extends RecyclingArrayList<StringBuilder>
    implements IDLSequence {
        private final int type;

        public StringBuilderHolder(int maxSize, String typeCode) {
            super(maxSize, StringBuilder::new);
            switch (typeCode) {
                case "type_d": {
                    this.type = 13;
                    break;
                }
                case "type_15": {
                    this.type = 21;
                    break;
                }
                default: {
                    throw new NotImplementedException(typeCode + " is not implemented for Sequence");
                }
            }
        }

        @Override
        public void resetQuick() {
            this.clear();
        }

        @Override
        public int capacity() {
            return java.lang.Integer.MAX_VALUE;
        }

        @Override
        public void readElement(int i, CDR cdr) {
            StringBuilder res = (StringBuilder)this.add();
            switch (this.type) {
                case 13: {
                    cdr.read_type_d(res);
                    break;
                }
                case 21: {
                    cdr.read_type_15(res);
                }
            }
        }

        @Override
        public void writeElement(int i, CDR cdr) {
            switch (this.type) {
                case 13: {
                    cdr.write_type_d((StringBuilder)this.get(i));
                    break;
                }
                case 21: {
                    cdr.write_type_15((StringBuilder)this.get(i));
                }
            }
        }

        public void add(String string) {
            StringBuilder elem = (StringBuilder)this.add();
            elem.setLength(0);
            elem.append(string);
        }

        public String getString(int i) {
            return ((StringBuilder)this.get(i)).toString();
        }

        public void set(StringBuilderHolder other) {
            this.resetQuick();
            for (int i = 0; i < other.size(); ++i) {
                StringBuilder add = (StringBuilder)this.add();
                add.delete(0, add.length());
                add.append((CharSequence)other.get(i));
            }
        }

        public String[] toStringArray() {
            String[] dest = new String[this.size()];
            this.toArray(dest);
            return dest;
        }

        public void toArray(String[] dest) {
            if (dest.length < this.size()) {
                throw new IndexOutOfBoundsException("Cannot copy data in destination array, insufficient space.");
            }
            for (int i = 0; i < this.size(); ++i) {
                dest[i] = this.getString(i);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append((CharSequence)this.get(i));
            }
            builder.append("]");
            return builder.toString();
        }

        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringBuilderHolder other = (StringBuilderHolder)obj;
            if (this.size() != other.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (IDLTools.equals((StringBuilder)this.get(i), (StringBuilder)other.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    public static class Double
    extends TDoubleArrayList
    implements IDLSequence {
        private final int maxSize;

        public Double(int maxSize, String typeCode) {
            super(maxSize);
            if (!typeCode.equals("type_6")) {
                throw new NotImplementedException(typeCode + " is not implemented for Sequence");
            }
            this.maxSize = maxSize;
        }

        @Override
        public void readElement(int i, CDR cdr) {
            this.add(cdr.read_type_6());
        }

        @Override
        public void writeElement(int i, CDR cdr) {
            cdr.write_type_6(this.get(i));
        }

        public void set(Double other) {
            this.resetQuick();
            for (int i = 0; i < other.size(); ++i) {
                this.add(other.get(i));
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.get(i));
            }
            builder.append("]");
            return builder.toString();
        }

        @Override
        public int capacity() {
            return this.maxSize;
        }
    }

    public static class Float
    extends TFloatArrayList
    implements IDLSequence {
        private final int maxSize;

        public Float(int maxSize, String typeCode) {
            super(maxSize);
            if (!typeCode.equals("type_5")) {
                throw new NotImplementedException(typeCode + " is not implemented for Sequence");
            }
            this.maxSize = maxSize;
        }

        @Override
        public void readElement(int i, CDR cdr) {
            this.add(cdr.read_type_5());
        }

        @Override
        public void writeElement(int i, CDR cdr) {
            cdr.write_type_5(this.get(i));
        }

        public void set(Float other) {
            this.resetQuick();
            for (int i = 0; i < other.size(); ++i) {
                this.add(other.get(i));
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.get(i));
            }
            builder.append("]");
            return builder.toString();
        }

        @Override
        public int capacity() {
            return this.maxSize;
        }
    }

    public static class Long
    extends TLongArrayList
    implements IDLSequence {
        private final int type;
        private final int maxSize;

        public Long(int maxSize, String typeCode) {
            super(maxSize);
            switch (typeCode) {
                case "type_11": {
                    this.type = 11;
                    break;
                }
                case "type_12": {
                    this.type = 12;
                    break;
                }
                case "type_4": {
                    this.type = 4;
                    break;
                }
                default: {
                    throw new NotImplementedException(typeCode + " is not implemented for Sequence");
                }
            }
            this.maxSize = maxSize;
        }

        @Override
        public void readElement(int i, CDR cdr) {
            switch (this.type) {
                case 11: {
                    this.add(cdr.read_type_11());
                    break;
                }
                case 12: {
                    this.add(cdr.read_type_12());
                    break;
                }
                case 4: {
                    this.add(cdr.read_type_4());
                }
            }
        }

        @Override
        public void writeElement(int i, CDR cdr) {
            switch (this.type) {
                case 11: {
                    cdr.write_type_11(this.get(i));
                    break;
                }
                case 12: {
                    cdr.write_type_12(this.get(i));
                    break;
                }
                case 4: {
                    cdr.write_type_4(this.get(i));
                }
            }
        }

        public void set(Long other) {
            this.resetQuick();
            for (int i = 0; i < other.size(); ++i) {
                this.add(other.get(i));
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.get(i));
            }
            builder.append("]");
            return builder.toString();
        }

        @Override
        public int capacity() {
            return this.maxSize;
        }
    }

    public static class Integer
    extends TIntArrayList
    implements IDLSequence {
        private final int type;
        private final int maxSize;

        public Integer(int maxSize, String typeCode) {
            super(maxSize);
            switch (typeCode) {
                case "type_2": {
                    this.type = 2;
                    break;
                }
                case "type_3": {
                    this.type = 3;
                    break;
                }
                default: {
                    throw new NotImplementedException(typeCode + " is not implemented for Sequence");
                }
            }
            this.maxSize = maxSize;
        }

        @Override
        public void readElement(int i, CDR cdr) {
            switch (this.type) {
                case 2: {
                    this.add(cdr.read_type_2());
                    break;
                }
                case 3: {
                    this.add(cdr.read_type_3());
                }
            }
        }

        @Override
        public void writeElement(int i, CDR cdr) {
            switch (this.type) {
                case 2: {
                    cdr.write_type_2(this.get(i));
                    break;
                }
                case 3: {
                    cdr.write_type_3(this.get(i));
                }
            }
        }

        public void set(Integer other) {
            this.resetQuick();
            for (int i = 0; i < other.size(); ++i) {
                this.add(other.get(i));
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.get(i));
            }
            builder.append("]");
            return builder.toString();
        }

        @Override
        public int capacity() {
            return this.maxSize;
        }
    }

    public static class Short
    extends TShortArrayList
    implements IDLSequence {
        private final int maxSize;

        public Short(int maxSize, String typeCode) {
            super(maxSize);
            if (!typeCode.equals("type_1")) {
                throw new NotImplementedException(typeCode + " is not implemented for Sequence");
            }
            this.maxSize = maxSize;
        }

        @Override
        public void readElement(int i, CDR cdr) {
            this.add(cdr.read_type_1());
        }

        @Override
        public void writeElement(int i, CDR cdr) {
            cdr.write_type_1(this.get(i));
        }

        public void set(Short other) {
            this.resetQuick();
            for (int i = 0; i < other.size(); ++i) {
                this.add(other.get(i));
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.get(i));
            }
            builder.append("]");
            return builder.toString();
        }

        @Override
        public int capacity() {
            return this.maxSize;
        }
    }

    public static class Char
    extends TCharArrayList
    implements IDLSequence {
        private final int type;
        private final int maxSize;

        public Char(int maxSize, String typeCode) {
            super(maxSize);
            switch (typeCode) {
                case "type_8": {
                    this.type = 8;
                    break;
                }
                case "type_14": {
                    this.type = 14;
                    break;
                }
                default: {
                    throw new NotImplementedException(typeCode + " is not implemented for Sequence");
                }
            }
            this.maxSize = maxSize;
        }

        @Override
        public void readElement(int i, CDR cdr) {
            switch (this.type) {
                case 8: {
                    this.add(cdr.read_type_8());
                    break;
                }
                case 14: {
                    this.add(cdr.read_type_14());
                }
            }
        }

        @Override
        public void writeElement(int i, CDR cdr) {
            switch (this.type) {
                case 8: {
                    cdr.write_type_8(this.get(i));
                    break;
                }
                case 14: {
                    cdr.write_type_14(this.get(i));
                }
            }
        }

        public void set(Char other) {
            this.resetQuick();
            for (int i = 0; i < other.size(); ++i) {
                this.add(other.get(i));
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.get(i));
            }
            builder.append("]");
            return builder.toString();
        }

        @Override
        public int capacity() {
            return this.maxSize;
        }
    }

    public static class Byte
    extends TByteArrayList
    implements IDLSequence {
        private final int maxSize;

        public Byte(int maxSize, String typeCode) {
            super(maxSize);
            if (!typeCode.equals("type_9")) {
                throw new NotImplementedException(typeCode + " is not implemented for Sequence");
            }
            this.maxSize = maxSize;
        }

        @Override
        public void readElement(int i, CDR cdr) {
            this.add(cdr.read_type_9());
        }

        @Override
        public void writeElement(int i, CDR cdr) {
            cdr.write_type_9(this.get(i));
        }

        public void set(Byte other) {
            this.resetQuick();
            for (int i = 0; i < other.size(); ++i) {
                this.add(other.get(i));
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.get(i));
            }
            builder.append("]");
            return builder.toString();
        }

        @Override
        public int capacity() {
            return this.maxSize;
        }
    }

    public static class Boolean
    extends TByteArrayList
    implements IDLSequence {
        public static final byte True = 1;
        public static final byte False = 0;
        private final int maxSize;

        public Boolean(int maxSize, String typeCode) {
            super(maxSize);
            if (!typeCode.equals("type_7")) {
                throw new NotImplementedException(typeCode + " is not implemented for Sequence");
            }
            this.maxSize = maxSize;
        }

        public void add(boolean value) {
            this.add(value ? (byte)1 : 0);
        }

        public boolean getBoolean(int offset) {
            return this.get(offset) == 1;
        }

        public void set(int offset, boolean b) {
            this.set(offset, b ? (byte)1 : 0);
        }

        @Override
        public void readElement(int i, CDR cdr) {
            this.add(cdr.read_type_7());
        }

        @Override
        public void writeElement(int i, CDR cdr) {
            cdr.write_type_7(this.getBoolean(i));
        }

        public void set(Boolean other) {
            this.resetQuick();
            for (int i = 0; i < other.size(); ++i) {
                this.add(other.get(i));
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.getBoolean(i));
            }
            builder.append("]");
            return builder.toString();
        }

        @Override
        public int capacity() {
            return this.maxSize;
        }
    }
}

