/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.server.internal;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class UpgradeHttpServletResponse
implements HttpServletResponse {
    private static final String UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE = "Feature unsupported after Upgraded to WebSocket";
    private HttpServletResponse _response;
    private int _status;
    private Map<String, Collection<String>> _headers;
    private Locale _locale;
    private String _characterEncoding;
    private String _contentType;

    public UpgradeHttpServletResponse(HttpServletResponse response) {
        this._response = response;
    }

    public void upgrade() {
        this._status = this._response.getStatus();
        this._locale = this._response.getLocale();
        this._characterEncoding = this._response.getCharacterEncoding();
        this._contentType = this._response.getContentType();
        this._headers = new HashMap<String, Collection<String>>();
        for (String name : this._response.getHeaderNames()) {
            this._headers.put(name, this._response.getHeaders(name));
        }
        this._response = null;
    }

    public HttpServletResponse getResponse() {
        return this._response;
    }

    public int getStatus() {
        if (this._response == null) {
            return this._status;
        }
        return this._response.getStatus();
    }

    public String getHeader(String s) {
        if (this._response == null) {
            Collection<String> values = this._headers.get(s);
            if (values == null) {
                return null;
            }
            return values.stream().findFirst().orElse(null);
        }
        return this._response.getHeader(s);
    }

    public Collection<String> getHeaders(String s) {
        if (this._response == null) {
            return this._headers.get(s);
        }
        return this._response.getHeaders(s);
    }

    public Collection<String> getHeaderNames() {
        if (this._response == null) {
            return this._headers.keySet();
        }
        return this._response.getHeaderNames();
    }

    public Locale getLocale() {
        if (this._response == null) {
            return this._locale;
        }
        return this._response.getLocale();
    }

    public boolean containsHeader(String s) {
        if (this._response == null) {
            Collection<String> values = this._headers.get(s);
            return values != null && !values.isEmpty();
        }
        return this._response.containsHeader(s);
    }

    public String getCharacterEncoding() {
        if (this._response == null) {
            return this._characterEncoding;
        }
        return this._response.getCharacterEncoding();
    }

    public String getContentType() {
        if (this._response == null) {
            return this._contentType;
        }
        return this._response.getContentType();
    }

    public void addCookie(Cookie cookie) {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.addCookie(cookie);
    }

    public String encodeURL(String s) {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this._response.encodeURL(s);
    }

    public String encodeRedirectURL(String s) {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this._response.encodeRedirectURL(s);
    }

    public String encodeUrl(String s) {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this._response.encodeUrl(s);
    }

    public String encodeRedirectUrl(String s) {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this._response.encodeRedirectUrl(s);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this._response.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this._response.getWriter();
    }

    public void setCharacterEncoding(String s) {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.setCharacterEncoding(s);
    }

    public void setContentLength(int i) {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.setContentLength(i);
    }

    public void setContentLengthLong(long l) {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.setContentLengthLong(l);
    }

    public void setContentType(String s) {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.setContentType(s);
    }

    public void setBufferSize(int i) {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.setBufferSize(i);
    }

    public int getBufferSize() {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this._response.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.flushBuffer();
    }

    public void resetBuffer() {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.resetBuffer();
    }

    public boolean isCommitted() {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this._response.isCommitted();
    }

    public void reset() {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.reset();
    }

    public void setLocale(Locale locale) {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.setLocale(locale);
    }

    public void sendError(int sc, String msg) throws IOException {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.sendError(sc);
    }

    public void setHeader(String name, String value) {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.setHeader(name, value);
    }

    public void sendRedirect(String s) throws IOException {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.sendRedirect(s);
    }

    public void setDateHeader(String s, long l) {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.setDateHeader(s, l);
    }

    public void addDateHeader(String s, long l) {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.addDateHeader(s, l);
    }

    public void addHeader(String name, String value) {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.addHeader(name, value);
    }

    public void setIntHeader(String s, int i) {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.setIntHeader(s, i);
    }

    public void addIntHeader(String s, int i) {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.addIntHeader(s, i);
    }

    public void setStatus(int i) {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.setStatus(i);
    }

    public void setStatus(int i, String s) {
        if (this._response == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this._response.setStatus(i, s);
    }
}

