/*
 * Decompiled with CFR 0.152.
 */
package me.bazhenov.docker;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import me.bazhenov.docker.ContainerDefinition;
import me.bazhenov.docker.ContainerNamespace;
import me.bazhenov.docker.Docker;
import me.bazhenov.docker.DockerAnnotationsInspector;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.TestListenerAdapter;

public class DockerTestNgListener
extends TestListenerAdapter {
    private final Docker docker = new Docker();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void onStart(ITestContext testContext) {
        super.onStart(testContext);
        DockerAnnotationsInspector inspector = new DockerAnnotationsInspector();
        ExecutorService starter = Executors.newCachedThreadPool();
        try {
            void var7_10;
            IdentityHashMap<Object, Boolean> testObjects = new IdentityHashMap<Object, Boolean>();
            ITestNGMethod[] iTestNGMethodArray = testContext.getAllTestMethods();
            int n = iTestNGMethodArray.length;
            boolean bl = false;
            while (var7_10 < n) {
                ITestNGMethod m2 = iTestNGMethodArray[var7_10];
                testObjects.putIfAbsent(m2.getInstance(), true);
                ++var7_10;
            }
            testObjects.keySet().stream().map(Object::getClass).forEach(inspector::createNamespace);
            ArrayList futures = new ArrayList();
            for (ContainerNamespace containerNamespace : inspector.getAllNamespaces()) {
                for (ContainerDefinition definition : containerNamespace.getAllDefinitions()) {
                    futures.add(starter.submit(() -> {
                        try {
                            String containerId = this.docker.start(definition);
                            Map<Integer, Integer> publishedTcpPorts = this.docker.getPublishedTcpPorts(containerId);
                            namespace.registerPublishedTcpPorts(definition, publishedTcpPorts);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }));
                }
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            for (ContainerNamespace containerNamespace : testObjects.keySet()) {
                inspector.resolveNotificationMethod(containerNamespace.getClass()).ifPresent(m -> m.call(test));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            starter.shutdown();
        }
    }

    public void onFinish(ITestContext testContext) {
        super.onFinish(testContext);
        try {
            this.docker.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

