/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.utils;

import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONPatch {
    private static final Logger logger = LoggerFactory.getLogger((String)"JSONPatch");

    private static void apply(JSONObject from, JSONObject patch, JSONObject to, int fromIndex) {
        String path = patch.getString("path");
        int idx = path.indexOf(47, fromIndex);
        if (idx != -1) {
            JSONObject fromInner;
            String key = path.substring(0, idx);
            JSONObject inner = to.optJSONObject(key);
            if (inner == null) {
                inner = new JSONObject();
                to.put(key, (Object)inner);
            }
            if ((fromInner = from.optJSONObject(key)) == null) {
                fromInner = new JSONObject();
            }
            JSONPatch.apply(fromInner, patch, inner, idx + 1);
        } else {
            String op = patch.getString("op");
            String key = path.substring(fromIndex);
            if (op.equalsIgnoreCase("remove")) {
                to.remove(key);
            } else if (op.equalsIgnoreCase("add")) {
                to.put(key, patch.get("value"));
            } else if (op.equalsIgnoreCase("replace")) {
                to.put(key, patch.get("value"));
            }
        }
    }

    public static JSONObject apply(JSONObject from, JSONArray patch) {
        JSONObject to = new JSONObject(from.toMap());
        for (int i = 0; i < patch.length(); ++i) {
            JSONPatch.apply(from, patch.getJSONObject(i), to, 1);
        }
        return to;
    }

    public static JSONArray getPatch(JSONObject from, JSONObject to) {
        return JSONPatch.getPatch(from, to, "");
    }

    private static JSONArray getPatch(JSONObject from, JSONObject to, String path) {
        JSONArray patch = new JSONArray();
        for (String key : to.keySet()) {
            if (from.has(key)) continue;
            Object o = to.get(key);
            if (o instanceof Long || o instanceof Integer || o instanceof String || o instanceof Double || o instanceof Boolean || o instanceof JSONObject) {
                JSONObject op = new JSONObject();
                op.put("op", (Object)"add");
                op.put("path", (Object)(path + "/" + key));
                op.put("value", o);
                patch.put((Object)op);
                continue;
            }
            System.err.println("WHAT TO DO WITH " + o.getClass());
        }
        for (String key : from.keySet()) {
            JSONObject op;
            if (!to.has(key)) {
                JSONObject op2 = new JSONObject();
                op2.put("op", (Object)"remove");
                op2.put("path", (Object)(path + "/" + key));
                patch.put((Object)op2);
                continue;
            }
            Object objF = from.opt(key);
            Object objT = to.opt(key);
            if (objF == null && objT instanceof JSONObject) {
                objF = new JSONObject();
            }
            if (objF instanceof JSONObject && objT instanceof JSONObject) {
                JSONArray patches = JSONPatch.getPatch((JSONObject)objF, (JSONObject)objT, key);
                for (int j = 0; j < patches.length(); ++j) {
                    patch.put((Object)patches.getJSONObject(j));
                }
                continue;
            }
            if (!(objT instanceof Long) && !(objT instanceof Boolean) && !(objT instanceof String) && !(objT instanceof Integer) && !(objT instanceof Double) && !(objT instanceof JSONObject)) continue;
            if (objF == null) {
                op = new JSONObject();
                op.put("op", (Object)"add");
                op.put("path", (Object)(path + "/" + key));
                op.put("value", objT);
                patch.put((Object)op);
                continue;
            }
            if (objF.equals(objT) || JSONObject.wrap((Object)objT).toString().equals(JSONObject.wrap((Object)objF).toString())) continue;
            op = new JSONObject();
            op.put("op", (Object)"replace");
            op.put("path", (Object)(path + "/" + key));
            op.put("value", objT);
            patch.put((Object)op);
        }
        return patch;
    }
}

