/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web.servlets.scope;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.data.Scope;
import de.kosmos_lab.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.platform.web.servlets.KosmoSAuthedServlet;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.media.ArraySchema;
import de.kosmos_lab.web.annotations.media.Content;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.media.SchemaProperty;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.annotations.tags.Tag;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.exceptions.UnauthorizedException;
import de.kosmos_lab.web.server.servlets.BaseServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONObject;

@ApiEndpoint(path="/scope/my", userLevel=1)
@Tag(description="Scope handling", name="scope")
public class ScopeMyServlet
extends KosmoSAuthedServlet {
    private static final String FIELD_USER = "user";
    private static final String FIELD_ADMIN = "admin";

    public ScopeMyServlet(KosmoSWebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"scope"}, summary="my", description="Lists the scopes you have access to", responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), description="A JSONObject stating the scopes you have access to", content={@Content(mediaType="application/json", schemaProperties={@SchemaProperty(name="admin", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(type=SchemaType.STRING, description="The names of the scopes you have admin access to"))), @SchemaProperty(name="user", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(type=SchemaType.STRING, description="The names of the scopes you have user access to")))})})})
    public void get(KosmoSHttpServletRequest request, HttpServletResponse response) throws IOException, UnauthorizedException {
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        for (Scope s : this.controller.getAllScopesWithUser(request.getKosmoSUser())) {
            jsonArray.put((Object)s.getName());
        }
        jsonObject.put(FIELD_USER, (Object)jsonArray);
        jsonArray = new JSONArray();
        for (Scope s : this.controller.getAllScopesWithAdmin(request.getKosmoSUser())) {
            jsonArray.put((Object)s.getName());
        }
        jsonObject.put(FIELD_ADMIN, (Object)jsonArray);
        ScopeMyServlet.sendJSON((BaseServletRequest)request, (HttpServletResponse)response, (JSONObject)jsonObject);
    }
}

