/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web.servlets.scope;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.data.Scope;
import de.kosmos_lab.platform.exceptions.NoAccessToScope;
import de.kosmos_lab.platform.exceptions.ScopeNotFoundException;
import de.kosmos_lab.platform.persistence.Constants;
import de.kosmos_lab.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.platform.web.servlets.KosmoSAuthedServlet;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.Parameter;
import de.kosmos_lab.web.annotations.enums.ParameterIn;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.exceptions.UnauthorizedException;
import de.kosmos_lab.web.persistence.exceptions.NotFoundInPersistenceException;
import jakarta.servlet.http.HttpServletResponse;

@ApiEndpoint(path="/scope/delete", userLevel=1)
public class ScopeDeleteServlet
extends KosmoSAuthedServlet {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_ID = "id";

    public ScopeDeleteServlet(KosmoSWebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"scope"}, summary="delete", description="deletes a scope", parameters={@Parameter(description="The name of the scope to delete. Use either 'name' or 'id'.", in=ParameterIn.QUERY, name="name", schema=@Schema(type=SchemaType.STRING)), @Parameter(description="The ID of the scope to delete. Use either 'name' or 'id'.", in=ParameterIn.QUERY, name="id", schema=@Schema(type=SchemaType.INTEGER))}, responses={@ApiResponse(responseCode=@ResponseCode(statusCode=204), description="The scope was deleted successfully.")})
    public void delete(KosmoSHttpServletRequest request, HttpServletResponse response) throws NoAccessToScope, ScopeNotFoundException, ParameterNotFoundException, UnauthorizedException {
        try {
            String sname = request.getString(FIELD_NAME);
            try {
                Scope scope = this.controller.getScope(sname, Constants.CacheMode.CACHE_AND_PERSISTENCE);
                if (scope.hasAdmin(request.getKosmoSUser()) || request.getKosmoSUser().isAdmin()) {
                    this.controller.deleteScope(scope);
                    response.setStatus(204);
                    return;
                }
                response.setStatus(403);
                return;
            }
            catch (NotFoundInPersistenceException ex) {
                throw new ScopeNotFoundException(sname);
            }
        }
        catch (ParameterNotFoundException sname) {
            try {
                int id = request.getInt(FIELD_ID);
                try {
                    Scope scope = this.controller.getScope(id, Constants.CacheMode.CACHE_AND_PERSISTENCE);
                    if (scope.hasAdmin(request.getKosmoSUser()) || request.getKosmoSUser().isAdmin()) {
                        this.controller.deleteScope(scope);
                        response.setStatus(204);
                        return;
                    }
                    response.setStatus(403);
                    return;
                }
                catch (NotFoundInPersistenceException ex) {
                    throw new ScopeNotFoundException("" + id);
                }
            }
            catch (ParameterNotFoundException ex) {
                ex.printStackTrace();
                response.setStatus(422);
                return;
            }
        }
    }
}

