/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web.servlets.group;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.data.Group;
import de.kosmos_lab.platform.exceptions.GroupNotFoundException;
import de.kosmos_lab.platform.persistence.Constants;
import de.kosmos_lab.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.platform.web.servlets.KosmoSAuthedServlet;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.Parameter;
import de.kosmos_lab.web.annotations.enums.ParameterIn;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.media.ArraySchema;
import de.kosmos_lab.web.annotations.media.Content;
import de.kosmos_lab.web.annotations.media.ExampleObject;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.media.SchemaProperty;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.exceptions.UnauthorizedException;
import de.kosmos_lab.web.server.servlets.BaseServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.json.JSONObject;

@ApiResponse(componentName="groupGet", responseCode=@ResponseCode(statusCode=204), description="Details about the group", content={@Content(mediaType="application/json", examples={@ExampleObject(name="testGroup", value="{\"name\":\"testGroup\",\"id\":18,\"users\":[{\"name\":\"user7\",\"id\":7}],\"admins\":[{\"name\":\"admin\",\"id\":1}]}")}, schemaProperties={@SchemaProperty(name="name", schema=@Schema(type=SchemaType.STRING, description="The name of the group")), @SchemaProperty(name="id", schema=@Schema(type=SchemaType.INTEGER, description="The ID of the group")), @SchemaProperty(name="admins", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(description="List of users with admin level access to the group", ref="#/components/schemas/userNameID"))), @SchemaProperty(name="users", array=@ArraySchema(uniqueItems=true, arraySchema=@Schema(description="List of users with user level access to the group", ref="#/components/schemas/userNameID")))})})
@ApiEndpoint(path="/group/get", userLevel=1)
public class GroupGetServlet
extends KosmoSAuthedServlet {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_ID = "id";

    public GroupGetServlet(KosmoSWebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"group"}, summary="get", description="get information about the group", parameters={@Parameter(description="The name of the group to get detail about. Use either 'name' or 'id'.", in=ParameterIn.QUERY, name="name", schema=@Schema(type=SchemaType.STRING)), @Parameter(description="The ID of the group to get detail about. Use either 'name' or 'id'.", in=ParameterIn.QUERY, name="id", schema=@Schema(type=SchemaType.INTEGER))}, responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), ref="#/components/responses/groupGet")})
    public void get(KosmoSHttpServletRequest request, HttpServletResponse response) throws IOException, UnauthorizedException, ParameterNotFoundException, GroupNotFoundException {
        try {
            String sname = request.getString(FIELD_NAME);
            if (sname != null) {
                Group group = this.controller.getGroup(sname, Constants.CacheMode.CACHE_AND_PERSISTENCE);
                GroupGetServlet.sendJSON((BaseServletRequest)request, (HttpServletResponse)response, (JSONObject)group.toJSON());
                return;
            }
        }
        catch (ParameterNotFoundException sname) {
            // empty catch block
        }
        Group group = this.controller.getGroup(request.getInt(FIELD_ID), Constants.CacheMode.CACHE_AND_PERSISTENCE);
        GroupGetServlet.sendJSON((BaseServletRequest)request, (HttpServletResponse)response, (JSONObject)group.toJSON());
    }
}

