/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web.servlets.group;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.exceptions.GroupAlreadyExistsException;
import de.kosmos_lab.platform.web.KosmoSHttpServletRequest;
import de.kosmos_lab.platform.web.KosmoSWebServer;
import de.kosmos_lab.platform.web.servlets.KosmoSAuthedServlet;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.media.Content;
import de.kosmos_lab.web.annotations.media.ExampleObject;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.media.SchemaProperty;
import de.kosmos_lab.web.annotations.parameters.RequestBody;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.ResponseCode;
import de.kosmos_lab.web.exceptions.ParameterNotFoundException;
import de.kosmos_lab.web.exceptions.UnauthorizedException;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@ApiEndpoint(path="/group/add", userLevel=1)
public class GroupAddServlet
extends KosmoSAuthedServlet {
    public static final String FIELD_NAME = "name";

    public GroupAddServlet(KosmoSWebServer webServer, IController controller, int level) {
        super(webServer, controller, level);
    }

    @Override
    @Operation(tags={"group"}, summary="add", description="Create a new group", requestBody=@RequestBody(required=true, content={@Content(examples={@ExampleObject(name="add group with name 'testGroup'", value="{\"name\":\"testGroup\"}")}, mediaType="application/json", schemaProperties={@SchemaProperty(name="name", schema=@Schema(description="name of the new group.", type=SchemaType.STRING, minLength=3, required=true))})}), responses={@ApiResponse(responseCode=@ResponseCode(statusCode=200), ref="#/components/responses/scopeGet", description="The group was added successfully")})
    public void post(KosmoSHttpServletRequest request, HttpServletResponse response) throws IOException, ParameterNotFoundException, GroupAlreadyExistsException, UnauthorizedException {
        String group_name = request.getString(FIELD_NAME);
        if (group_name.length() < 3) {
            response.sendError(422, "group name is not long enough (minLength is 3)");
            return;
        }
        this.controller.addGroup(group_name, request.getKosmoSUser());
        response.setStatus(204);
    }
}

