/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import de.kosmos_lab.web.annotations.Operation;
import de.kosmos_lab.web.annotations.Parameter;
import de.kosmos_lab.web.annotations.enums.ParameterIn;
import de.kosmos_lab.web.annotations.headers.Header;
import de.kosmos_lab.web.annotations.media.ExampleObject;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.responses.ApiResponse;
import de.kosmos_lab.web.annotations.security.SecurityRequirement;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import java.io.IOException;

@Deprecated
public class OpenApiToYaml {
    public static String asYaml(String jsonString) throws JsonProcessingException, IOException {
        JsonNode jsonNodeTree = new ObjectMapper().readTree(jsonString);
        String jsonAsYaml = new YAMLMapper().writeValueAsString(jsonNodeTree);
        return jsonAsYaml;
    }

    public static String toYaml(ApiEndpoint endpoint, Operation method, String httpMethod) {
        return OpenApiToYaml.toYaml(endpoint, method, 0, httpMethod);
    }

    public static String toYaml(ApiEndpoint endpoint, Operation method, int tabs, String httpMethod) {
        StringBuilder sb = new StringBuilder();
        OpenApiToYaml.append(endpoint, method, tabs, httpMethod, sb);
        return sb.toString();
    }

    public static void append(ApiEndpoint endpoint, Operation method, int tabs, String httpMethod, StringBuilder sb) {
        if (endpoint.path() != "") {
            OpenApiToYaml.appendItem(endpoint.path(), tabs, sb);
            OpenApiToYaml.appendItem(httpMethod, tabs + 2, sb);
            OpenApiToYaml.append("tags", method.tags(), tabs + 4, sb);
            String operationId = method.operationId();
            if (operationId.length() == 0) {
                operationId = endpoint.path().replace("/", "");
            }
            OpenApiToYaml.append("operationId", operationId, tabs + 4, sb);
            OpenApiToYaml.append("description", method.description(), tabs + 4, sb);
            OpenApiToYaml.append("summary", method.summary(), tabs + 4, sb);
            if (method.security().length == 0) {
                if (endpoint.userLevel() >= 100) {
                    OpenApiToYaml.appendItem("security", tabs + 4, sb);
                    OpenApiToYaml.appendListItem("bearerAuth [admin]", tabs + 4, sb);
                } else if (endpoint.userLevel() >= 0) {
                    OpenApiToYaml.appendItem("security", tabs + 4, sb);
                    OpenApiToYaml.appendListItem("bearerAuth [user]", tabs + 4, sb);
                }
            } else {
                OpenApiToYaml.append(method.security(), tabs + 4, sb);
            }
            OpenApiToYaml.append(method.responses(), tabs + 4, sb);
            OpenApiToYaml.append(method.parameters(), tabs + 4, sb);
        }
    }

    public static void appendItem(String tag, int tabs, StringBuilder sb) {
        sb.append(String.format("%s%s:\n", OpenApiToYaml.tabs(tabs), tag));
    }

    public static void append(SecurityRequirement[] securities, int tabs, StringBuilder sb) {
        SecurityRequirement security;
        if (securities.length > 1) {
            OpenApiToYaml.appendItem("security", tabs, sb);
            for (SecurityRequirement s : securities) {
                OpenApiToYaml.append(s, tabs + 2, sb);
            }
        } else if (securities.length == 1 && !(security = securities[0]).name().equals("none")) {
            OpenApiToYaml.appendItem("security", tabs, sb);
            OpenApiToYaml.append(security, tabs + 2, sb);
        }
    }

    public static void append(SecurityRequirement security, int tabs, StringBuilder sb) {
        if (!security.name().equals("none")) {
            sb.append(String.format("%s- %s: [%s]\n", " ".repeat(tabs), security.name(), String.join((CharSequence)",", security.scopes())));
        }
    }

    public static void append(Parameter r, int tabs, StringBuilder sb) {
        sb.append(String.format("%s- name: %s\n", OpenApiToYaml.tabs(tabs), r.name()));
        OpenApiToYaml.append("description", r.description(), tabs + 2, sb);
        if (!r.in().equals((Object)ParameterIn.DEFAULT)) {
            sb.append(String.format("%sin: %s\n", " ".repeat(tabs + 2), r.in()));
        } else {
            sb.append(String.format("%sin: %s\n", " ".repeat(tabs + 2), "query"));
        }
        OpenApiToYaml.append(r.schema(), tabs + 2, sb);
        OpenApiToYaml.append(r.examples(), tabs + 2, sb);
        OpenApiToYaml.append("example", r.example(), tabs + 2, sb);
    }

    private static void append(ExampleObject[] examples, int tabs, StringBuilder sb) {
        if (examples.length > 0) {
            OpenApiToYaml.appendItem("examples", tabs, sb);
            for (ExampleObject e : examples) {
                OpenApiToYaml.append(e, tabs + 2, sb);
            }
        }
    }

    public static void append(Parameter[] rs, int tabs, StringBuilder sb) {
        if (rs.length > 0) {
            OpenApiToYaml.appendItem("parameters", tabs, sb);
            for (Parameter r : rs) {
                OpenApiToYaml.append(r, tabs + 2, sb);
            }
        }
    }

    public static void append(ApiResponse[] rs, int tabs, StringBuilder sb) {
        if (rs.length > 0) {
            OpenApiToYaml.appendItem("responses", tabs, sb);
            for (ApiResponse r : rs) {
                OpenApiToYaml.append(r, tabs + 2, sb);
            }
        }
    }

    public static void append(ApiResponse r, int tabs, StringBuilder sb) {
        OpenApiToYaml.appendItem(String.format("'%s'", r.responseCode()), tabs, sb);
        OpenApiToYaml.append("description", r.description(), tabs + 2, sb);
        OpenApiToYaml.append("$ref", r.ref(), tabs + 2, sb);
        OpenApiToYaml.append(r.headers(), tabs + 2, sb);
    }

    private static void append(Header[] headers, int tabs, StringBuilder sb) {
        if (headers.length > 0) {
            for (Header header : headers) {
                OpenApiToYaml.append(header, tabs + 2, sb);
            }
        }
    }

    private static void append(Header header, int tabs, StringBuilder sb) {
    }

    public static void append(Schema schema, int tabs, StringBuilder sb) {
        OpenApiToYaml.appendItem("schema", tabs, sb);
        OpenApiToYaml.append("$ref", schema.ref(), tabs + 2, sb);
        OpenApiToYaml.append("additionalProperties", schema.additionalProperties(), tabs + 2, sb);
        OpenApiToYaml.append("allOf", schema.allOf(), tabs + 2, sb);
        OpenApiToYaml.append("allowableValues", schema.allowableValues(), tabs + 2, sb);
        OpenApiToYaml.append("anyOf", schema.anyOf(), tabs + 2, sb);
        OpenApiToYaml.append("defaultValue", schema.defaultValue(), tabs + 2, sb);
        OpenApiToYaml.append("deprecated", schema.deprecated(), tabs + 2, sb, false);
        OpenApiToYaml.append("discriminatorProperty", schema.discriminatorProperty(), tabs + 2, sb);
        OpenApiToYaml.append("enumAsRef", schema.enumAsRef(), tabs + 2, sb, false);
        OpenApiToYaml.append("exclusiveMaximum", schema.exclusiveMaximum(), tabs + 2, sb, false);
        OpenApiToYaml.append("exclusiveMinimum", schema.exclusiveMinimum(), tabs + 2, sb, false);
        OpenApiToYaml.append("format", schema.format(), tabs + 2, sb);
        OpenApiToYaml.append("hidden", schema.hidden(), tabs + 2, sb, false);
        OpenApiToYaml.append("maxLength", schema.maxLength(), tabs + 2, sb, Integer.MAX_VALUE);
        OpenApiToYaml.append("maxProperties", (double)schema.maxProperties(), tabs + 2, sb, 0.0);
        OpenApiToYaml.append("maximum", schema.maximum(), tabs + 2, sb);
        OpenApiToYaml.append("minLength", schema.minLength(), tabs + 2, sb, 0);
        OpenApiToYaml.append("minProperties", schema.minProperties(), tabs + 2, sb, 0);
        OpenApiToYaml.append("minimum", schema.minimum(), tabs + 2, sb);
        OpenApiToYaml.append("multipleOf", schema.multipleOf(), tabs + 2, sb, 0.0);
        OpenApiToYaml.append("nullable", schema.nullable(), tabs + 2, sb, false);
        OpenApiToYaml.append("oneOf", schema.oneOf(), tabs + 2, sb);
        OpenApiToYaml.append("pattern", schema.pattern(), tabs + 2, sb);
        OpenApiToYaml.append("required", schema.required(), tabs + 2, sb, false);
        OpenApiToYaml.append("requiredProperties", schema.requiredProperties(), tabs + 2, sb);
        OpenApiToYaml.append("title", schema.title(), tabs + 2, sb);
        OpenApiToYaml.append("type", schema.type().toString(), tabs + 2, sb);
        OpenApiToYaml.append("not", schema.not(), tabs + 2, sb, Void.class);
    }

    private static void append(String tag, Class<?> clz, int tabs, StringBuilder sb, Class<?> ignoreIfThis) {
        if (ignoreIfThis != null && ignoreIfThis == clz) {
            return;
        }
        OpenApiToYaml.appendItem("not", tabs, sb);
        OpenApiToYaml.append("type", clz.getName(), tabs + 2, sb);
    }

    private static void append(String tag, int value, int tabs, StringBuilder sb, Integer ignoreIfThis) {
        if (ignoreIfThis != null && ignoreIfThis == value) {
            return;
        }
        OpenApiToYaml.append(tag, String.valueOf(value), tabs, sb);
    }

    private static void append(String tag, boolean input, int tabs, StringBuilder sb) {
        OpenApiToYaml.append(tag, input, tabs, sb, null);
    }

    private static void append(String tag, Class<?>[] classList, int tabs, StringBuilder sb) {
        if (classList.length > 0) {
            OpenApiToYaml.appendItem(tag, tabs, sb);
            for (Class<?> T : classList) {
                OpenApiToYaml.appendListItem(T.getName(), tabs + 2, sb);
            }
        }
    }

    private static void appendListItem(String name, int tabs, StringBuilder sb) {
        sb.append(String.format("%s- %s\n", OpenApiToYaml.tabs(tabs + 2), name));
    }

    private static void append(String tag, double value, int tabs, StringBuilder sb, Double ignoreIfThis) {
        if (ignoreIfThis != null && ignoreIfThis == value) {
            return;
        }
        OpenApiToYaml.append(tag, String.valueOf(value), tabs, sb);
    }

    public static void append(ExampleObject example, int tabs, StringBuilder sb) {
        if (example.name().length() > 0) {
            OpenApiToYaml.appendItem(example.name(), tabs, sb);
            OpenApiToYaml.append("description", example.description(), tabs += 2, sb);
            OpenApiToYaml.append("summary", example.summary(), tabs, sb);
            OpenApiToYaml.append("$ref", example.ref(), tabs, sb);
            OpenApiToYaml.append("value", example.value(), tabs, sb);
        }
    }

    public static void appendTabbed(String input, int tabs, StringBuilder sb) {
        sb.append(String.format("%s%s\n", OpenApiToYaml.tabs(tabs), input));
    }

    public static void append(String tag, boolean input, int tabs, StringBuilder sb, Boolean ignoreIfThis) {
        if (ignoreIfThis != null && ignoreIfThis == input) {
            return;
        }
        sb.append(String.format("%s%s: %s\n", OpenApiToYaml.tabs(tabs), tag, input));
    }

    public static String tabs(int tabs) {
        return " ".repeat(tabs);
    }

    public static void append(String tag, String input, int tabs, StringBuilder sb) {
        if (input == null || input.length() == 0) {
            return;
        }
        String[] parts = input.split("\n");
        if (parts.length == 1) {
            sb.append(String.format("%s%s: %s\n", OpenApiToYaml.tabs(tabs), tag, input));
        } else {
            sb.append(String.format("%s%s: |\n", OpenApiToYaml.tabs(tabs), tag, input));
            for (String part : parts) {
                sb.append(String.format("%s%s\n", " ".repeat(tabs + 2), part));
            }
        }
    }

    public static void append(String tag, String[] input, int tabs, StringBuilder sb) {
        if (input == null || input.length == 0) {
            return;
        }
        sb.append(String.format("%s%s:\n", OpenApiToYaml.tabs(tabs), tag));
        for (String string : input) {
            OpenApiToYaml.appendListItem(string, tabs + 2, sb);
        }
    }
}

