/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.persistence;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.data.DataSchema;
import de.kosmos_lab.platform.data.Device;
import de.kosmos_lab.platform.data.DeviceText;
import de.kosmos_lab.platform.data.Group;
import de.kosmos_lab.platform.data.KosmoSUser;
import de.kosmos_lab.platform.data.LogEntry;
import de.kosmos_lab.platform.data.Scope;
import de.kosmos_lab.platform.exceptions.DeviceNotFoundException;
import de.kosmos_lab.platform.exceptions.GroupNotFoundException;
import de.kosmos_lab.platform.exceptions.UserNotFoundException;
import de.kosmos_lab.platform.persistence.Constants;
import de.kosmos_lab.platform.smarthome.CommandSourceName;
import de.kosmos_lab.web.data.IUser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"})
public class Models {
    private static final Logger logger = LoggerFactory.getLogger((String)"Models");

    public static class SQL_Scope_Devices {
        public static final String table = "`scope_devices`";
        public static final String fields = "`uuid`,`read`,`write`,`del`";
        public static final String selectAll = "select `uuid`,`read`,`write`,`del` from `scope_devices`";
        public static final String selectByuuid = "select `uuid`,`read`,`write`,`del` from `scope_devices` where `uuid`=?";
        public static final String deleteByuuid = "delete from `scope_devices`  where `uuid`=?";
        public static final String updateuuidByuuid = "update `scope_devices` set `uuid`=? where `uuid`=?";
        public static final String updatereadByuuid = "update `scope_devices` set `read`=? where `uuid`=?";
        public static final String updatewriteByuuid = "update `scope_devices` set `write`=? where `uuid`=?";
        public static final String updatedelByuuid = "update `scope_devices` set `del`=? where `uuid`=?";
        public static final String add = "insert into `scope_devices` (`uuid`,`read`,`write`,`del`) values (?,?,?,?)";
        public static final String create = "CREATE TABLE `scope_devices` (\n\t`uuid` VARCHAR(128) NOT NULL,\n\t`read` INTEGER NOT NULL,\n\t`write` INTEGER NOT NULL,\n\t`del` INTEGER NOT NULL\n)\n;CREATE INDEX idx_scope_device_uuid \nON `scope_devices` (`uuid`);;";

        public static final Object parse(IController controller, ResultSet rs, boolean getData) {
            try {
                Device device = controller.getDevice(Getter.uuid(rs));
                device.setReadScope(controller.getScope(Getter.read(rs), Constants.CacheMode.CACHE_AND_PERSISTENCE));
                device.setWriteScope(controller.getScope(Getter.write(rs), Constants.CacheMode.CACHE_AND_PERSISTENCE));
                device.setDelScope(controller.getScope(Getter.del(rs), Constants.CacheMode.CACHE_AND_PERSISTENCE));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public static class Index {
            public static final int uuid = 1;
            public static final int read = 2;
            public static final int write = 3;
            public static final int del = 4;
        }

        public static class Getter {
            public static String uuid(ResultSet rs) throws SQLException {
                return rs.getString(1);
            }

            public static int read(ResultSet rs) throws SQLException {
                return rs.getInt(2);
            }

            public static int write(ResultSet rs) throws SQLException {
                return rs.getInt(3);
            }

            public static int del(ResultSet rs) throws SQLException {
                return rs.getInt(4);
            }
        }

        public static class Field {
            public static final String uuid = "`uuid`";
            public static final String read = "`read`";
            public static final String write = "`write`";
            public static final String del = "`del`";
        }
    }

    public static class SQL_Group_Admins {
        public static final String table = "`group_admins`";
        public static final String fields = "`user`,`group`";
        public static final String selectAll = "select `user`,`group` from `group_admins`";
        public static final String selectBygroup = "select `user`,`group` from `group_admins` where `group`=?";
        public static final String selectByuserAndgroup = "select `user`,`group` from `group_admins` where `user`=? AND `group`=?";
        public static final String deleteBygroup = "delete from `group_admins`  where `group`=?";
        public static final String deleteByuserAndgroup = "delete from `group_admins`  where `user`=? AND `group`=?";
        public static final String updateuserBygroup = "update `group_admins` set `user`=? where `group`=?";
        public static final String updategroupBygroup = "update `group_admins` set `group`=? where `group`=?";
        public static final String updateuserByuserAndgroup = "update `group_admins` set `user`=? where `user`=? AND `group`=?";
        public static final String updategroupByuserAndgroup = "update `group_admins` set `group`=? where `user`=? AND `group`=?";
        public static final String add = "insert into `group_admins` (`user`,`group`) values (?,?)";
        public static final String addOrUpdate = "insert into `group_admins` (`user`,`group`) values (?,?) ON DUPLICATE KEY UPDATE `user`=VALUES(`user`), `group`=VALUES(`group`) ";
        public static final String update = " UPDATE `group_admins` set `user`=?, `group`=? WHERE `user`=?";
        public static final String create = "CREATE TABLE `group_admins` (\n\t`group` INTEGER NOT NULL,\n\t`user` INTEGER NOT NULL\n);\nCREATE UNIQUE INDEX idx_group_admins \nON `group_admins` (`group`,`user`);";

        public static final Object parse(IController controller, ResultSet rs, boolean getData) {
            block4: {
                try {
                    Group group = controller.getGroup(SQL_Group_Users.Getter.group(rs), Constants.CacheMode.CACHE_AND_PERSISTENCE);
                    if (group == null) break block4;
                    try {
                        group.addAdmin(controller.getUser(SQL_Group_Users.Getter.user(rs)));
                    }
                    catch (UserNotFoundException ex) {
                        return null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public static class Index {
            public static final int user = 1;
            public static final int group = 2;
        }

        public static class Getter {
            public static int user(ResultSet rs) throws SQLException {
                return rs.getInt(1);
            }

            public static int group(ResultSet rs) throws SQLException {
                return rs.getInt(2);
            }
        }

        public static class Field {
            public static final String user = "`user`";
            public static final String group = "`group`";
        }
    }

    public static class SQL_Group_Users {
        public static final String table = "`group_users`";
        public static final String fields = "`user`,`group`";
        public static final String selectAll = "select `user`,`group` from `group_users`";
        public static final String selectBygroup = "select `user`,`group` from `group_users` where `group`=?";
        public static final String selectByuserAndgroup = "select `user`,`group` from `group_users` where `user`=? AND `group`=?";
        public static final String deleteBygroup = "delete from `group_users`  where `group`=?";
        public static final String deleteByuserAndgroup = "delete from `group_users`  where `user`=? AND `group`=?";
        public static final String updateuserBygroup = "update `group_users` set `user`=? where `group`=?";
        public static final String updategroupBygroup = "update `group_users` set `group`=? where `group`=?";
        public static final String updateuserByuserAndgroup = "update `group_users` set `user`=? where `user`=? AND `group`=?";
        public static final String updategroupByuserAndgroup = "update `group_users` set `group`=? where `user`=? AND `group`=?";
        public static final String add = "insert into `group_users` (`user`,`group`) values (?,?)";
        public static final String addOrUpdate = "insert into `group_users` (`user`,`group`) values (?,?) ON DUPLICATE KEY UPDATE `user`=VALUES(`user`), `group`=VALUES(`group`) ";
        public static final String update = " UPDATE `group_users` set `user`=?, `group`=? WHERE `user`=?";
        public static final String create = "CREATE TABLE `group_users` (\n\t`group` INTEGER NOT NULL,\n\t`user` INTEGER NOT NULL\n);\nCREATE UNIQUE INDEX idx_group_users \nON `group_users` (`group`,`user`);";

        public static final Object parse(IController controller, ResultSet rs, boolean getData) {
            block4: {
                try {
                    Group group = controller.getGroup(Getter.group(rs), Constants.CacheMode.CACHE_AND_PERSISTENCE);
                    if (group == null) break block4;
                    try {
                        group.addUser(controller.getUser(Getter.user(rs)));
                    }
                    catch (UserNotFoundException ex) {
                        return null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public static class Index {
            public static final int user = 1;
            public static final int group = 2;
        }

        public static class Getter {
            public static int user(ResultSet rs) throws SQLException {
                return rs.getInt(1);
            }

            public static int group(ResultSet rs) throws SQLException {
                return rs.getInt(2);
            }
        }

        public static class Field {
            public static final String user = "`user`";
            public static final String group = "`group`";
        }
    }

    public static class SQL_Groups {
        public static final String table = "`groups`";
        public static final String fields = "`id`,`name`";
        public static final String selectAll = "select `id`,`name` from `groups`";
        public static final String selectByname = "select `id`,`name` from `groups` where `name`=?";
        public static final String deleteByname = "delete from `groups`  where `name`=?";
        public static final String updatenameByname = "update `groups` set `name`=? where `name`=?";
        public static final String add = "insert into `groups` (`name`) values (?)";
        public static final String addOrUpdate = "insert into `groups` (`name`) values (?) ON DUPLICATE KEY UPDATE `id`=VALUES(`id`) ";
        public static final String update = " UPDATE `groups` set `id`=? WHERE `name`=?";
        public static final String selectByID = "select `id`,`name` from `groups` where `id`=?";
        public static final String create = "CREATE TABLE `groups` (\n\t`id` INTEGER PRIMARY KEY AUTOINCREMENT,\n\t`name` VARCHAR(64) NOT NULL\n);\nCREATE UNIQUE INDEX idx_groups_name \nON `groups` (`name`);";

        public static final Group parse(IController controller, ResultSet rs, boolean getData) {
            try {
                Integer id = Getter.ID(rs);
                logger.info("found group {} in db", (Object)id);
                try {
                    return controller.getGroup(id, Constants.CacheMode.CACHE_ONLY);
                }
                catch (GroupNotFoundException ex) {
                    Group group = new Group(id, Getter.name(rs));
                    controller.cacheGroup(group);
                    controller.getPersistence().fillGroup(group);
                    return group;
                }
            }
            catch (Exception e) {
                logger.error("error while parsing group data ", (Throwable)e);
                return null;
            }
        }

        public static class Index {
            public static final int ID = 1;
            public static final int name = 2;
        }

        public static class Getter {
            public static Integer ID(ResultSet rs) throws SQLException {
                int v = rs.getInt(1);
                if (rs.wasNull()) {
                    return null;
                }
                return v;
            }

            public static String name(ResultSet rs) throws SQLException {
                return rs.getString(2);
            }
        }

        public static class Field {
            public static final String id = "`id`";
            public static final String name = "`name`";
        }
    }

    public static class SQL_Scopes {
        public static final String table = "`scopes`";
        public static final String fields = "`id`,`name`";
        public static final String selectAll = "select `id`,`name` from `scopes`";
        public static final String selectByname = "select `id`,`name` from `scopes` where `name`=?";
        public static final String deleteByname = "delete from `scopes`  where `name`=?";
        public static final String deleteById = "delete from `scopes` where `id`=?";
        public static final String updatenameByname = "update `scopes` set `name`=? where `name`=?";
        public static final String add = "insert into `scopes` (`name`) values (?)";
        public static final String addOrUpdate = "insert into `scopes` (`name`) values (?) ON DUPLICATE KEY UPDATE `id`=VALUES(`id`) ";
        public static final String update = " UPDATE `scopes` set `id`=? WHERE `name`=?";
        public static final String selectByID = "select `id`,`name` from `scopes` where `id`=?";
        public static final String create = "CREATE TABLE `scopes` (\n\t`id` INTEGER PRIMARY KEY AUTOINCREMENT,\n\t`name` VARCHAR(64) NOT NULL\n);\nCREATE UNIQUE INDEX idx_scopes_name \nON `scopes` (`name`);";

        public static final Scope parse(IController controller, ResultSet rs, boolean getData) {
            try {
                Scope scope = controller.getScope(Getter.ID(rs), Constants.CacheMode.CACHE_ONLY);
                if (scope == null) {
                    scope = new Scope(Getter.ID(rs), Getter.name(rs));
                    controller.cacheScope(scope);
                    controller.getPersistence().fillScope(scope);
                }
                return scope;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public static class Index {
            public static final int ID = 1;
            public static final int name = 2;
        }

        public static class Getter {
            public static Integer ID(ResultSet rs) throws SQLException {
                int v = rs.getInt(1);
                if (rs.wasNull()) {
                    return null;
                }
                return v;
            }

            public static String name(ResultSet rs) throws SQLException {
                return rs.getString(2);
            }
        }

        public static class Field {
            public static final String id = "`id`";
            public static final String name = "`name`";
        }
    }

    public static class SQL_Scope_Group_Admins {
        public static final String table = "`scope_group_admin`";
        public static final String fields = "`Group`,`scope`";
        public static final String selectAll = "select `Group`,`scope` from `scope_group_admin`";
        public static final String selectByscope = "select `Group`,`scope` from `scope_group_admin` where `scope`=?";
        public static final String selectByGroupAndscope = "select `Group`,`scope` from `scope_group_admin` where `Group`=? AND `scope`=?";
        public static final String deleteByscope = "delete from `scope_group_admin`  where `scope`=?";
        public static final String deleteByGroupAndscope = "delete from `scope_group_admin`  where `Group`=? AND `scope`=?";
        public static final String updateGroupByscope = "update `scope_group_admin` set `Group`=? where `scope`=?";
        public static final String updatescopeByscope = "update `scope_group_admin` set `scope`=? where `scope`=?";
        public static final String updateGroupByGroupAndscope = "update `scope_group_admin` set `Group`=? where `Group`=? AND `scope`=?";
        public static final String updatescopeByGroupAndscope = "update `scope_group_admin` set `scope`=? where `Group`=? AND `scope`=?";
        public static final String add = "insert into `scope_group_admin` (`Group`,`scope`) values (?,?)";
        public static final String addOrUpdate = "insert into `scope_group_admin` (`Group`,`scope`) values (?,?) ON DUPLICATE KEY UPDATE `Group`=VALUES(`Group`), `scope`=VALUES(`scope`) ";
        public static final String update = " UPDATE `scope_group_admin` set `Group`=?, `scope`=? WHERE `Group`=?";
        public static final String create = "CREATE TABLE `scope_group_admin` (\n\t`scope` INTEGER NOT NULL,\n\t`Group` INTEGER NOT NULL\n);\nCREATE UNIQUE INDEX idx_scope_Groups \nON `scope_group_admin` (`scope`,`Group`);CREATE UNIQUE INDEX idx_scope_Groups_scope \nON `scope_group_admin` (`scope`);";

        public static final Object parse(IController controller, ResultSet rs, boolean getData) {
            try {
                Scope scope = controller.getScope(Getter.scope(rs), Constants.CacheMode.CACHE_AND_PERSISTENCE);
                if (scope != null) {
                    scope.addAdminGroup(controller.getGroup(Getter.Group(rs), Constants.CacheMode.CACHE_AND_PERSISTENCE));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public static class Index {
            public static final int Group = 1;
            public static final int scope = 2;
        }

        public static class Getter {
            public static int Group(ResultSet rs) throws SQLException {
                return rs.getInt(1);
            }

            public static int scope(ResultSet rs) throws SQLException {
                return rs.getInt(2);
            }
        }

        public static class Field {
            public static final String Group = "`Group`";
            public static final String scope = "`scope`";
        }
    }

    public static class SQL_Scope_Group_User {
        public static final String table = "`scope_group_user`";
        public static final String fields = "`Group`,`scope`";
        public static final String selectAll = "select `Group`,`scope` from `scope_group_user`";
        public static final String selectByscope = "select `Group`,`scope` from `scope_group_user` where `scope`=?";
        public static final String selectByGroupAndscope = "select `Group`,`scope` from `scope_group_user` where `Group`=? AND `scope`=?";
        public static final String deleteByscope = "delete from `scope_group_user`  where `scope`=?";
        public static final String deleteByGroupAndscope = "delete from `scope_group_user`  where `Group`=? AND `scope`=?";
        public static final String updateGroupByscope = "update `scope_group_user` set `Group`=? where `scope`=?";
        public static final String updatescopeByscope = "update `scope_group_user` set `scope`=? where `scope`=?";
        public static final String updateGroupByGroupAndscope = "update `scope_group_user` set `Group`=? where `Group`=? AND `scope`=?";
        public static final String updatescopeByGroupAndscope = "update `scope_group_user` set `scope`=? where `Group`=? AND `scope`=?";
        public static final String add = "insert into `scope_group_user` (`Group`,`scope`) values (?,?)";
        public static final String addOrUpdate = "insert into `scope_group_user` (`Group`,`scope`) values (?,?) ON DUPLICATE KEY UPDATE `Group`=VALUES(`Group`), `scope`=VALUES(`scope`) ";
        public static final String update = " UPDATE `scope_group_user` set `Group`=?, `scope`=? WHERE `Group`=?";
        public static final String create = "CREATE TABLE `scope_group_user` (\n\t`scope` INTEGER NOT NULL,\n\t`Group` INTEGER NOT NULL\n);\nCREATE UNIQUE INDEX idx_scope_Groups \nON `scope_group_user` (`scope`,`Group`);CREATE UNIQUE INDEX idx_scope_Groups_scope \nON `scope_group_user` (`scope`);";

        public static final Object parse(IController controller, ResultSet rs, boolean getData) {
            try {
                Scope scope = controller.getScope(Getter.scope(rs), Constants.CacheMode.CACHE_AND_PERSISTENCE);
                if (scope != null) {
                    scope.addUserGroup(controller.getGroup(Getter.Group(rs), Constants.CacheMode.CACHE_AND_PERSISTENCE));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public static class Index {
            public static final int Group = 1;
            public static final int scope = 2;
        }

        public static class Getter {
            public static int Group(ResultSet rs) throws SQLException {
                return rs.getInt(1);
            }

            public static int scope(ResultSet rs) throws SQLException {
                return rs.getInt(2);
            }
        }

        public static class Field {
            public static final String Group = "`Group`";
            public static final String scope = "`scope`";
        }
    }

    public static class SQL_Scope_Admins {
        public static final String table = "`scope_admins`";
        public static final String fields = "`user`,`scope`";
        public static final String selectAll = "select `user`,`scope` from `scope_admins`";
        public static final String selectByscope = "select `user`,`scope` from `scope_admins` where `scope`=?";
        public static final String selectByuserAndscope = "select `user`,`scope` from `scope_admins` where `user`=? AND `scope`=?";
        public static final String deleteByscope = "delete from `scope_admins`  where `scope`=?";
        public static final String deleteByuserAndscope = "delete from `scope_admins`  where `user`=? AND `scope`=?";
        public static final String updateuserByscope = "update `scope_admins` set `user`=? where `scope`=?";
        public static final String updatescopeByscope = "update `scope_admins` set `scope`=? where `scope`=?";
        public static final String updateuserByuserAndscope = "update `scope_admins` set `user`=? where `user`=? AND `scope`=?";
        public static final String updatescopeByuserAndscope = "update `scope_admins` set `scope`=? where `user`=? AND `scope`=?";
        public static final String add = "insert into `scope_admins` (`user`,`scope`) values (?,?)";
        public static final String addOrUpdate = "insert into `scope_admins` (`user`,`scope`) values (?,?) ON DUPLICATE KEY UPDATE `user`=VALUES(`user`), `scope`=VALUES(`scope`) ";
        public static final String update = " UPDATE `scope_admins` set `user`=?, `scope`=? WHERE `user`=?";
        public static final String create = "CREATE TABLE `scope_admins` (\n\t`scope` INTEGER NOT NULL,\n\t`user` INTEGER NOT NULL\n);\nCREATE UNIQUE INDEX idx_scope_admins \nON `scope_admins` (`scope`,`user`);CREATE UNIQUE INDEX idx_scope_admins_scope \nON `scope_admins` (`scope`);";

        public static final Object parse(IController controller, ResultSet rs, boolean getData) {
            block4: {
                try {
                    Scope scope = controller.getScope(SQL_Scope_Users.Getter.scope(rs), Constants.CacheMode.CACHE_AND_PERSISTENCE);
                    if (scope == null) break block4;
                    try {
                        scope.addAdmin(controller.getUser(SQL_Scope_Users.Getter.user(rs)));
                    }
                    catch (UserNotFoundException ex) {
                        return null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public static class Index {
            public static final int user = 1;
            public static final int scope = 2;
        }

        public static class Getter {
            public static int user(ResultSet rs) throws SQLException {
                return rs.getInt(1);
            }

            public static int scope(ResultSet rs) throws SQLException {
                return rs.getInt(2);
            }
        }

        public static class Field {
            public static final String user = "`user`";
            public static final String scope = "`scope`";
        }
    }

    public static class SQL_Scope_Users {
        public static final String table = "`scope_users`";
        public static final String fields = "`user`,`scope`";
        public static final String selectAll = "select `user`,`scope` from `scope_users`";
        public static final String selectByscope = "select `user`,`scope` from `scope_users` where `scope`=?";
        public static final String selectByuserAndscope = "select `user`,`scope` from `scope_users` where `user`=? AND `scope`=?";
        public static final String deleteByscope = "delete from `scope_users`  where `scope`=?";
        public static final String deleteByuserAndscope = "delete from `scope_users`  where `user`=? AND `scope`=?";
        public static final String updateuserByscope = "update `scope_users` set `user`=? where `scope`=?";
        public static final String updatescopeByscope = "update `scope_users` set `scope`=? where `scope`=?";
        public static final String updateuserByuserAndscope = "update `scope_users` set `user`=? where `user`=? AND `scope`=?";
        public static final String updatescopeByuserAndscope = "update `scope_users` set `scope`=? where `user`=? AND `scope`=?";
        public static final String add = "insert into `scope_users` (`user`,`scope`) values (?,?)";
        public static final String addOrUpdate = "insert into `scope_users` (`user`,`scope`) values (?,?) ON DUPLICATE KEY UPDATE `user`=VALUES(`user`), `scope`=VALUES(`scope`) ";
        public static final String update = " UPDATE `scope_users` set `user`=?, `scope`=? WHERE `user`=?";
        public static final String create = "CREATE TABLE `scope_users` (\n\t`scope` INTEGER NOT NULL,\n\t`user` INTEGER NOT NULL\n);\nCREATE UNIQUE INDEX idx_scope_users \nON `scope_users` (`scope`,`user`);CREATE UNIQUE INDEX idx_scope_users_scope \nON `scope_users` (`scope`);";

        public static final Object parse(IController controller, ResultSet rs, boolean getData) {
            block4: {
                try {
                    Scope scope = controller.getScope(Getter.scope(rs), Constants.CacheMode.CACHE_AND_PERSISTENCE);
                    if (scope == null) break block4;
                    try {
                        scope.addUser(controller.getUser(Getter.user(rs)));
                    }
                    catch (UserNotFoundException ex) {
                        return null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public static class Index {
            public static final int user = 1;
            public static final int scope = 2;
        }

        public static class Getter {
            public static int user(ResultSet rs) throws SQLException {
                return rs.getInt(1);
            }

            public static int scope(ResultSet rs) throws SQLException {
                return rs.getInt(2);
            }
        }

        public static class Field {
            public static final String user = "`user`";
            public static final String scope = "`scope`";
        }
    }

    public static class SQL_Users {
        public static final String table = "`users`";
        public static final String fields = "`id`,`name`,`level`,`salt`,`hash`";
        public static final String selectAll = "select `id`,`name`,`level`,`salt`,`hash` from `users`";
        public static final String selectByname = "select `id`,`name`,`level`,`salt`,`hash` from `users` where `name`=?";
        public static final String deleteByname = "delete from `users`  where `name`=?";
        public static final String updateIDByname = "update `users` set `id`=? where `name`=?";
        public static final String updatenameByname = "update `users` set `name`=? where `name`=?";
        public static final String updatelevelByname = "update `users` set `level`=? where `name`=?";
        public static final String updatesaltByname = "update `users` set `salt`=? where `name`=?";
        public static final String updatehashByname = "update `users` set `hash`=? where `name`=?";
        public static final String removeIDByname = "update `users` set `id`=NULL where `name`=?";
        public static final String add = "insert into `users` (`name`,`level`,`salt`,`hash`) values (?,?,?,?)";
        public static final String addOrUpdate = "insert into `users` (`name`,`level`,`salt`,`hash`) values (?,?,?,?) ON DUPLICATE KEY UPDATE `salt`=VALUES(`salt`), `level`=VALUES(`level`), `hash`=VALUES(`hash`), `id`=VALUES(`id`) ";
        public static final String update = " UPDATE `users` set `salt`=?, `level`=?, `hash`=?, `id`=? WHERE `name`=?";
        public static final String create = "CREATE TABLE `users` (\n\t`id` INTEGER PRIMARY KEY AUTOINCREMENT,\n\t`name` VARCHAR(64) NOT NULL,\n\t`level` INTEGER NOT NULL,\n\t`salt` VARCHAR(26) NOT NULL,\n\t`hash` VARCHAR(64) NOT NULL\n)\n;\nCREATE UNIQUE INDEX idx_user_name\nON `users` (`name`);";
        public static final String selectByid = "select `id`,`name`,`level`,`salt`,`hash` from `users` where `id`=?";

        public static final KosmoSUser parse(IController controller, ResultSet rs, boolean getData) {
            try {
                KosmoSUser u = new KosmoSUser(controller, Getter.name(rs), Getter.ID(rs), Getter.level(rs), Getter.hash(rs), Getter.salt(rs));
                controller.cacheUser(u);
                return u;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public static class Index {
            public static final int ID = 1;
            public static final int name = 2;
            public static final int level = 3;
            public static final int salt = 4;
            public static final int hash = 5;
        }

        public static class Getter {
            public static Integer ID(ResultSet rs) throws SQLException {
                int v = rs.getInt(1);
                if (rs.wasNull()) {
                    return null;
                }
                return v;
            }

            public static String name(ResultSet rs) throws SQLException {
                return rs.getString(2);
            }

            public static int level(ResultSet rs) throws SQLException {
                return rs.getInt(3);
            }

            public static String salt(ResultSet rs) throws SQLException {
                return rs.getString(4);
            }

            public static String hash(ResultSet rs) throws SQLException {
                return rs.getString(5);
            }
        }

        public static class Field {
            public static final String id = "`id`";
            public static final String name = "`name`";
            public static final String level = "`level`";
            public static final String salt = "`salt`";
            public static final String hash = "`hash`";
        }
    }

    public static class SQL_Schemas {
        public static final String table = "`schemas`";
        public static final String fields = "`ID`,`schema`";
        public static final String selectAll = "select `ID`,`schema` from `schemas`";
        public static final String selectByID = "select `ID`,`schema` from `schemas` where `ID`=?";
        public static final String deleteByID = "delete from `schemas`  where `ID`=?";
        public static final String updateIDByID = "update `schemas` set `ID`=? where `ID`=?";
        public static final String updateSchemaByID = "update `schemas` set `schema`=? where `ID`=?";
        public static final String add = "insert into `schemas` (`ID`,`schema`) values (?,?)";
        public static final String addOrUpdate = "insert into `schemas` (`ID`,`schema`) values (?,?) ON DUPLICATE KEY UPDATE `schema`=VALUES(`schema`) ";
        public static final String update = " UPDATE `schemas` set `schema`=? WHERE `ID`=?";
        public static final String create = "CREATE TABLE `schemas` (\n\t`ID` VARCHAR(256) NOT NULL,\n\t`schema` TEXT NOT NULL,\n\tPRIMARY KEY (`ID`));\n";

        public static final DataSchema parse(IController controller, ResultSet rs, boolean getData) {
            try {
                DataSchema ds = new DataSchema(new JSONObject(Getter.Schema(rs)));
                controller.cacheSchema(ds);
                return ds;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public static class Index {
            public static final int ID = 1;
            public static final int Schema = 2;
        }

        public static class Getter {
            public static String ID(ResultSet rs) throws SQLException {
                return rs.getString(1);
            }

            public static String Schema(ResultSet rs) throws SQLException {
                return rs.getString(2);
            }
        }

        public static class Field {
            public static final String ID = "`ID`";
            public static final String schema = "`schema`";
        }
    }

    public static class SQL_Model_Schemas {
        public static final String table = "`model_schemas`";
        public static final String fields = "`model`,`manufacturer`,`schema`";
        public static final String selectAll = "select `model`,`manufacturer`,`schema` from `model_schemas`";
        public static final String add = "insert into `model_schemas` (`model`,`manufacturer`,`schema`) values (?,?,?)";
        public static final String create = "CREATE TABLE `model_schemas` (\n\t`model` TEXT NOT NULL,\n\t`manufacturer` TEXT NOT NULL,\n\t`schema` TEXT NOT NULL\n);CREATE UNIQUE INDEX idx_model_schemas \nON `model_schemas` (`model`,`manufacturer`);";

        public static final Object parse(IController controller, ResultSet rs, boolean getData) {
            return null;
        }

        public static class Index {
            public static final int model = 1;
            public static final int manufacturer = 2;
            public static final int schema = 3;
        }

        public static class Getter {
            public static String model(ResultSet rs) throws SQLException {
                return rs.getString(1);
            }

            public static String manufacturer(ResultSet rs) throws SQLException {
                return rs.getString(2);
            }

            public static String schema(ResultSet rs) throws SQLException {
                return rs.getString(3);
            }
        }

        public static class Field {
            public static final String model = "`model`";
            public static final String manufacturer = "`manufacturer`";
            public static final String schema = "`schema`";
        }
    }

    public static class SQL_Devices {
        public static final String table = "`devices`";
        public static final String fields = "`uuid`,`name`,`schema`,`source`,`lastUpdate`,`owner`";
        public static final String selectAll = "select `uuid`,`name`,`schema`,`source`,`lastUpdate`,`owner` from `devices`";
        public static final String selectByuuid = "select `uuid`,`name`,`schema`,`source`,`lastUpdate`,`owner` from `devices` where `uuid`=?";
        public static final String deleteByuuid = "delete from `devices`  where `uuid`=?";
        public static final String updateuuidByuuid = "update `devices` set `uuid`=? where `uuid`=?";
        public static final String updatenameByuuid = "update `devices` set `name`=? where `uuid`=?";
        public static final String updateschemaByuuid = "update `devices` set `schema`=? where `uuid`=?";
        public static final String updatesourceByuuid = "update `devices` set `source`=? where `uuid`=?";
        public static final String updatelastupdateByuuid = "update `devices` set `lastUpdate`=? where `uuid`=?";
        public static final String removesourceByuuid = "update `devices` set `source`=NULL where `uuid`=?";
        public static final String removelastupdateByuuid = "update `devices` set `lastUpdate`=NULL where `uuid`=?";
        public static final String add = "insert into `devices` (`uuid`,`name`,`schema`,`source`,`lastUpdate`,`owner`) values (?,?,?,?,?,?)";
        public static final String addOrUpdate = "insert into `devices` (`uuid`,`name`,`schema`,`source`,`lastUpdate`,`owner`) values (?,?,?,?,?.?,?) ON DUPLICATE KEY UPDATE `name`=VALUES(`name`), `schema`=VALUES(`schema`), `source`=VALUES(`source`), `lastUpdate`=VALUES(`lastUpdate`, `owner`=VALUES(`owner`) ";
        public static final String update = " UPDATE `devices` set `name`=?, `schema`=?, `source`=?, `lastUpdate`=? WHERE `uuid`=?";
        public static final String getNumberOfDevicesWithSchema = "select count(`uuid`) from `devices` where `schema`=?";
        public static final String create = "CREATE TABLE `devices` (\n\t`uuid` VARCHAR(128) NOT NULL,\n\t`name` VARCHAR(128) NOT NULL,\n\t`schema` VARCHAR(256) NOT NULL,\n\t`source` VARCHAR(256) NULL,\n\t`lastUpdate` BIGINT NULL,\n\t`owner` INTEGER NULL,\n\tPRIMARY KEY (`uuid`)\n)\n;\n";

        public static Device parse(IController controller, ResultSet rs, boolean getData) {
            try {
                DataSchema ds = controller.getSchema(Getter.schema(rs));
                String uuid = Getter.uuid(rs);
                JSONObject state = controller.getPersistence().getLastState(uuid);
                CommandSourceName source = controller.getSource(Getter.source(rs));
                IUser owner = controller.getUser(Getter.owner(rs));
                Device d = new Device(controller, source, ds, state, Getter.name(rs), uuid, owner, true);
                controller.cacheDevice(d);
                controller.publishUpdate(null, d, null, source);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public static class Index {
            public static final int uuid = 1;
            public static final int name = 2;
            public static final int schema = 3;
            public static final int source = 4;
            public static final int lastupdate = 5;
            public static final int owner = 6;
        }

        public static class Getter {
            public static String uuid(ResultSet rs) throws SQLException {
                return rs.getString(1);
            }

            public static String name(ResultSet rs) throws SQLException {
                return rs.getString(2);
            }

            public static String schema(ResultSet rs) throws SQLException {
                return rs.getString(3);
            }

            public static String source(ResultSet rs) throws SQLException {
                return rs.getString(4);
            }

            public static Integer owner(ResultSet rs) throws SQLException {
                return rs.getInt(6);
            }

            public static Integer lastupdate(ResultSet rs) throws SQLException {
                int v = rs.getInt(5);
                if (rs.wasNull()) {
                    return null;
                }
                return v;
            }
        }

        public static class Field {
            public static final String uuid = "`uuid`";
            public static final String name = "`name`";
            public static final String schema = "`schema`";
            public static final String source = "`source`";
            public static final String lastUpdate = "`lastUpdate`";
            public static final String owner = "`owner`";
        }
    }

    public static class SQL_Device_Text {
        public static final String table = "`device_text`";
        public static final String fields = "`uuid`,`key`,`value`";
        public static final String selectAll = "select `uuid`,`key`,`value` from `device_text`";
        public static final String add = "insert into `device_text` (`uuid`,`key`,`value`) values (?,?,?)";
        public static final String updateValue = "update `device_text` SET `value`=? where `uuid`=? AND `key`=?";
        public static final String deleteAllByUUID = "delete from `device_text` where `uuid`=?";
        public static final String selectByUUID = "select `uuid`,`key`,`value` from `device_text` where `uuid`= ? ";
        public static final String selectAllByUUIDS = "select `uuid`,`key`,`value` from `device_text` where `uuid` IN ? ";
        public static final String create = "CREATE TABLE `device_text` (\n\t`uuid` VARCHAR(128) NOT NULL,\n\t`key` TEXT NOT NULL,\n\t`value` TEXT NULL\n)\n;CREATE INDEX idx_text_uuid  ON `device_text` (`uuid`);\nCREATE UNIQUE INDEX idx_text_uuid_key ON `device_text` (`uuid`,`key`)";

        public static final DeviceText parse(IController controller, ResultSet rs, boolean getData) {
            try {
                try {
                    Device d = controller.getDevice(Getter.Uuid(rs));
                    DeviceText deviceText = new DeviceText(d, Getter.Key(rs), Getter.Value(rs));
                }
                catch (DeviceNotFoundException d) {}
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public static class Index {
            public static final int Uuid = 1;
            public static final int Key = 2;
            public static final int Value = 3;
        }

        public static class Getter {
            public static String Uuid(ResultSet rs) throws SQLException {
                return rs.getString(1);
            }

            public static String Value(ResultSet rs) throws SQLException {
                return rs.getString(3);
            }

            public static String Key(ResultSet rs) throws SQLException {
                return rs.getString(2);
            }
        }

        public static class Field {
            public static final String uuid = "`uuid`";
            public static final String value = "`value`";
            public static final String key = "`key`";
        }
    }

    public static class SQL_States {
        public static final String table = "`states`";
        public static final String fields = "`uuid`,`state`,`date`,`source`";
        public static final String selectAll = "select `uuid`,`state`,`date`,`source` from `states`";
        public static final String add = "insert into `states` (`uuid`,`state`,`date`,`source`) values (?,?,?,?)";
        public static final String deleteAllByUUID = "delete from `states` where `uuid`=?";
        public static final String selectLastByUUID = "select `uuid`,`state`,`date`,`source` from `states` where `uuid`=? ORDER BY `date` DESC LIMIT 0,1";
        public static final String selectAllByUUIDS = "select `uuid`,`state`,`date`,`source` from `states` where `uuid` IN ? AND `date`>=? AND `date`<=? ORDER BY `date`";
        public static final String selectAllBetween = "select `uuid`,`state`,`date`,`source` from `states` where `date`>=? AND `date`<=? ORDER BY `date`";
        public static final String create = "CREATE TABLE `states` (\n\t`uuid` VARCHAR(128) NOT NULL,\n\t`state` TEXT NOT NULL,\n\t`date` BIGINT NOT NULL,\n\t`source` TEXT NULL\n)\n;CREATE INDEX idx_states_uuid  ON `states` (`uuid`);\nCREATE INDEX idx_states_date  ON `states` (`date`);\n";

        public static final LogEntry parse(IController controller, ResultSet rs, boolean getData) {
            try {
                return new LogEntry(Getter.Uuid(rs), Getter.Date(rs), Getter.Source(rs), new JSONObject(Getter.State(rs)));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public static class Index {
            public static final int Uuid = 1;
            public static final int State = 2;
            public static final int Date = 3;
            public static final int Source = 4;
        }

        public static class Getter {
            public static String Uuid(ResultSet rs) throws SQLException {
                return rs.getString(1);
            }

            public static String State(ResultSet rs) throws SQLException {
                return rs.getString(2);
            }

            public static long Date(ResultSet rs) throws SQLException {
                return rs.getLong(3);
            }

            public static String Source(ResultSet rs) throws SQLException {
                return rs.getString(4);
            }
        }

        public static class Field {
            public static final String uuid = "`uuid`";
            public static final String state = "`state`";
            public static final String date = "`date`";
            public static final String source = "`source`";
        }
    }

    public static class SQL_Device_Location {
        public static final String table = "`device_location`";
        public static final String fields = "`uuid`,`x`,`y`,`z`,`w`,`d`,`h`,`roll`,`pitch`,`yaw`,`area`";
        public static final String selectAll = "select `uuid`,`x`,`y`,`z`,`w`,`d`,`h`,`roll`,`pitch`,`yaw`,`area` from `device_location`";
        public static final String add = "REPLACE into `device_location` (`uuid`,`x`,`y`,`z`,`w`,`d`,`h`,`roll`,`pitch`,`yaw`,`area`) values (?,?,?,?,?,?,?,?,?,?,?)";
        public static final String create = "CREATE TABLE `device_location` (\n\t`uuid` VARCHAR(128) NOT NULL,\n\t`x` INTEGER NULL,\n\t`y` INTEGER NULL,\n\t`z` INTEGER NULL,\n\t`w` INTEGER NULL,\n\t`d` INTEGER NULL,\n\t`h` INTEGER NULL,\n\t`roll` INTEGER NULL,\n\t`pitch` INTEGER NULL,\n\t`yaw` INTEGER NULL,\n\t`area` VARCHAR(128) NULL,\n\tPRIMARY KEY (`uuid`)\n)\n;CREATE UNIQUE INDEX idx_device_location_uuid \nON `device_location` (`uuid`);\n";

        public static final Device.Location parse(IController controller, ResultSet rs, boolean getData) {
            try {
                Device.Location loc = new Device.Location(Getter.x(rs), Getter.y(rs), Getter.z(rs), Getter.w(rs), Getter.d(rs), Getter.h(rs), Getter.roll(rs), Getter.pitch(rs), Getter.yaw(rs), Getter.area(rs));
                controller.setDeviceLocation(Getter.uuid(rs), loc);
                return loc;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public static class Index {
            public static final int uuid = 1;
            public static final int x = 2;
            public static final int y = 3;
            public static final int z = 4;
            public static final int w = 5;
            public static final int d = 6;
            public static final int h = 7;
            public static final int roll = 8;
            public static final int pitch = 9;
            public static final int yaw = 10;
            public static final int area = 11;
        }

        public static class Getter {
            public static String uuid(ResultSet rs) throws SQLException {
                return rs.getString(1);
            }

            public static Integer x(ResultSet rs) throws SQLException {
                return rs.getInt(2);
            }

            public static Integer y(ResultSet rs) throws SQLException {
                return rs.getInt(3);
            }

            public static Integer z(ResultSet rs) throws SQLException {
                return rs.getInt(4);
            }

            public static Integer w(ResultSet rs) throws SQLException {
                return rs.getInt(5);
            }

            public static Integer d(ResultSet rs) throws SQLException {
                return rs.getInt(6);
            }

            public static Integer h(ResultSet rs) throws SQLException {
                return rs.getInt(7);
            }

            public static Integer roll(ResultSet rs) throws SQLException {
                return rs.getInt(8);
            }

            public static Integer pitch(ResultSet rs) throws SQLException {
                return rs.getInt(9);
            }

            public static Integer yaw(ResultSet rs) throws SQLException {
                return rs.getInt(10);
            }

            public static String area(ResultSet rs) throws SQLException {
                return rs.getString(11);
            }
        }

        public static class Field {
            public static final String uuid = "`uuid`";
            public static final String x = "`x`";
            public static final String y = "`y`";
            public static final String z = "`z`";
            public static final String w = "`w`";
            public static final String d = "`d`";
            public static final String h = "`h`";
            public static final String roll = "`roll`";
            public static final String pitch = "`pitch`";
            public static final String yaw = "`yaw`";
            public static final String area = "`area`";
        }
    }
}

