/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.data;

import de.kosmos_lab.web.data.IUser;
import java.util.HashSet;
import javax.annotation.Nonnull;
import org.json.JSONArray;
import org.json.JSONObject;

public class Group {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_ID = "id";
    public static final String FIELD_USERS = "users";
    public static final String FIELD_ADMINS = "admins";
    private final String name;
    private final int id;
    HashSet<IUser> admins = new HashSet();
    HashSet<IUser> users = new HashSet();

    public void addAdmin(@Nonnull IUser user) {
        this.admins.add(user);
    }

    public void addUser(@Nonnull IUser user) {
        this.users.add(user);
    }

    public void delUser(@Nonnull IUser user) {
        this.users.remove(user);
    }

    public void delAdmin(@Nonnull IUser user) {
        this.admins.remove(user);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public int getID() {
        return this.id;
    }

    public boolean hasUser(@Nonnull IUser user) {
        return this.users.contains(user);
    }

    public boolean hasAdmin(@Nonnull IUser user) {
        return this.admins.contains(user);
    }

    public Group(@Nonnull Integer id, @Nonnull String name) {
        this.id = id;
        this.name = name;
    }

    boolean hasAccess(@Nonnull IUser user) {
        if (this.admins.contains(user)) {
            return true;
        }
        return this.users.contains(user);
    }

    @Nonnull
    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        o.put(FIELD_NAME, (Object)this.name);
        o.put(FIELD_ID, this.id);
        JSONArray arr = new JSONArray();
        for (IUser u : this.admins) {
            arr.put((Object)new JSONObject().put(FIELD_ID, (Object)u.getUUID()).put(FIELD_NAME, (Object)u.getName()));
        }
        o.put(FIELD_ADMINS, (Object)arr);
        arr = new JSONArray();
        for (IUser u : this.users) {
            arr.put((Object)new JSONObject().put(FIELD_ID, (Object)u.getUUID()).put(FIELD_NAME, (Object)u.getName()));
        }
        o.put(FIELD_USERS, (Object)arr);
        return o;
    }

    @Nonnull
    public String toString() {
        return this.name;
    }
}

