/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.client;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPClient
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger((String)"HTTPClient");

    public HTTPClient() throws Exception {
        this.start();
    }

    @Nonnull
    public Request createRequest(@Nonnull String url, @Nonnull HttpMethod method) {
        logger.info("creating {} request to {}", (Object)method.name(), (Object)url);
        Request request = this.newRequest(url);
        request.method(method);
        request.agent("KosmoS HTTP Client");
        return request;
    }

    @Nonnull
    public Request createRequest(@Nonnull String url, @Nonnull HttpMethod method, @CheckForNull String body) {
        Request request = this.createRequest(url, method);
        if (body != null) {
            request.content((ContentProvider)new StringContentProvider(body), "application/text");
        }
        return request;
    }

    @Nonnull
    public Request createRequest(@Nonnull String url, @Nonnull HttpMethod method, @CheckForNull Object body) {
        Request request = this.createRequest(url, method);
        if (body != null) {
            if (body instanceof JSONObject || body instanceof JSONArray) {
                request.content((ContentProvider)new StringContentProvider(body.toString()), "application/json");
            }
            if (body instanceof String) {
                request.content((ContentProvider)new StringContentProvider((String)body), "application/text");
            } else {
                request.content((ContentProvider)new StringContentProvider(body.toString()), "application/text");
            }
        }
        return request;
    }

    @Nonnull
    public Request createRequest(@Nonnull String url, @Nonnull HttpMethod method, @CheckForNull JSONArray body) {
        Request request = this.createRequest(url, method);
        if (body != null) {
            request.content((ContentProvider)new StringContentProvider(body.toString()), "application/json");
        }
        return request;
    }

    @CheckForNull
    public JSONArray fetchJSONArray(@Nonnull String url, @Nonnull HttpMethod method) {
        ContentResponse r = this.getResponse(this.createRequest(url, method));
        if (r != null) {
            try {
                return new JSONArray(r.getContentAsString());
            }
            catch (JSONException ex) {
                logger.error("could not parse response to JSON!", (Throwable)ex);
            }
        }
        return null;
    }

    @CheckForNull
    public JSONObject fetchJSONObject(@Nonnull String url, @Nonnull HttpMethod method) {
        ContentResponse r = this.getResponse(this.createRequest(url, method));
        if (r != null) {
            try {
                return new JSONObject(r.getContentAsString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    @CheckForNull
    public ContentResponse getResponse(@Nonnull String url, @Nonnull HttpMethod method, @CheckForNull String body) {
        return this.getResponse(this.createRequest(url, method, body));
    }

    @CheckForNull
    public ContentResponse getResponse(@Nonnull String url, @Nonnull HttpMethod method, @CheckForNull JSONObject body) {
        return this.getResponse(this.createRequest(url, method, body));
    }

    @CheckForNull
    public ContentResponse getResponse(@Nonnull String url, @Nonnull HttpMethod method, @Nonnull JSONArray body) {
        return this.getResponse(this.createRequest(url, method, body));
    }

    @CheckForNull
    public ContentResponse getResponse(@Nonnull String url, @Nonnull HttpMethod method) {
        return this.getResponse(this.createRequest(url, method));
    }

    @CheckForNull
    public JSONObject postJSONObject(@Nonnull String url, @CheckForNull JSONObject body) {
        ContentResponse r;
        Request request = this.createRequest(url, HttpMethod.POST);
        if (body != null) {
            request.content((ContentProvider)new StringContentProvider(body.toString()), "application/json");
        }
        if ((r = this.getResponse(request)) != null) {
            return new JSONObject(r.getContentAsString());
        }
        return null;
    }

    @CheckForNull
    public ContentResponse postJSONObject2(@Nonnull String url, @CheckForNull JSONObject body) {
        Request request = this.createRequest(url, HttpMethod.POST);
        if (body != null) {
            request.content((ContentProvider)new StringContentProvider(body.toString()), "application/json");
        }
        return this.getResponse(request);
    }

    @CheckForNull
    public ContentResponse getResponse(@Nonnull Request request) {
        ContentResponse response = null;
        try {
            response = request.send();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            logger.error("could not get Response for Request {}", (Object)e.getMessage(), (Object)e);
        }
        return response;
    }
}

