/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform;

import de.kosmos_lab.platform.KosmoSController;
import de.kosmos_lab.platform.persistence.Constants;
import de.kosmos_lab.utils.KosmosFileUtils;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

class StartController {
    StartController() {
    }

    public static void main(String[] args) {
        KosmosFileUtils.writeToFile((File)new File("kosmos.pid"), (String)String.valueOf(ProcessHandle.current().pid()));
        Options options = new Options();
        options.addOption("help", "print this message");
        options.addOption(Option.builder((String)"c").longOpt("config").argName("file").hasArg().desc("use given configfile").build());
        options.addOption("t", "testing", false, "start in testing mode");
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("help")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("java -jar kosmos.jar", options);
                System.exit(0);
            }
            File config = new File("config/config.json");
            if (line.hasOption("config")) {
                config = new File(line.getOptionValue("config"));
            }
            Constants.RunMode mode = Constants.RunMode.NORMAL;
            if (line.hasOption("testing")) {
                mode = Constants.RunMode.TEST;
            }
            new KosmoSController(config, mode);
        }
        catch (ParseException exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
        }
    }
}

