/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import java.util.Objects;
import us.ihmc.ros2.ROS2TopicNameTools;

public class ROS2Topic<T> {
    public static final String INPUT = "input";
    public static final String OUTPUT = "output";
    private final String prefix;
    private final String robotName;
    private final String moduleName;
    private final String ioQualifier;
    private final String typeName;
    private final String suffix;
    private final Class<T> messageType;

    public ROS2Topic() {
        this.prefix = "";
        this.robotName = "";
        this.moduleName = "";
        this.ioQualifier = "";
        this.typeName = "";
        this.suffix = "";
        this.messageType = null;
    }

    private ROS2Topic(String prefix, String robotName, String moduleName, String ioQualifier, String typeName, String suffix, Class<T> messageType) {
        this.prefix = prefix;
        this.robotName = robotName;
        this.moduleName = moduleName;
        this.ioQualifier = ioQualifier;
        this.typeName = typeName;
        this.suffix = suffix;
        this.messageType = messageType;
    }

    private ROS2Topic<T> copyIfNotEqual(String prefix, String robotName, String moduleName, String ioQualifier, String typeName, String suffix, Class<T> messageType) {
        if (this.equals(prefix, robotName, moduleName, ioQualifier, typeName, suffix, messageType)) {
            return this;
        }
        return new ROS2Topic<T>(prefix, robotName, moduleName, ioQualifier, typeName, suffix, messageType);
    }

    public ROS2Topic<T> withPrefix(String prefix) {
        return this.copyIfNotEqual(ROS2TopicNameTools.processTopicNamePart(prefix), this.robotName, this.moduleName, this.ioQualifier, this.typeName, this.suffix, this.messageType);
    }

    public ROS2Topic<T> withRobot(String robotName) {
        return this.copyIfNotEqual(this.prefix, ROS2TopicNameTools.processTopicNamePart(robotName), this.moduleName, this.ioQualifier, this.typeName, this.suffix, this.messageType);
    }

    public ROS2Topic<T> withModule(String moduleName) {
        return this.copyIfNotEqual(this.prefix, this.robotName, ROS2TopicNameTools.processTopicNamePart(moduleName), this.ioQualifier, this.typeName, this.suffix, this.messageType);
    }

    public ROS2Topic<T> withInput() {
        return this.withIOQualifier(INPUT);
    }

    public ROS2Topic<T> withOutput() {
        return this.withIOQualifier(OUTPUT);
    }

    public ROS2Topic<T> withIOQualifier(String ioQualifier) {
        return this.copyIfNotEqual(this.prefix, this.robotName, this.moduleName, ROS2TopicNameTools.processTopicNamePart(ioQualifier), this.typeName, this.suffix, this.messageType);
    }

    public ROS2Topic<T> withTypeName() {
        if (this.messageType == null) {
            throw new RuntimeException("This topic does not have a type yet. Cannot add type name");
        }
        return this.copyIfNotEqual(this.prefix, this.robotName, this.moduleName, this.ioQualifier, ROS2TopicNameTools.processTopicNamePart(ROS2TopicNameTools.messageTypeToTopicNamePart(this.messageType)), this.suffix, this.messageType);
    }

    public ROS2Topic<T> clearTypeName() {
        return this.copyIfNotEqual(this.prefix, this.robotName, this.moduleName, this.ioQualifier, "", this.suffix, this.messageType);
    }

    public ROS2Topic<T> withSuffix(String suffix) {
        return this.copyIfNotEqual(this.prefix, this.robotName, this.moduleName, this.ioQualifier, this.typeName, ROS2TopicNameTools.processTopicNamePart(suffix), this.messageType);
    }

    public <K> ROS2Topic<K> withType(Class<K> messageType) {
        if (messageType == null) {
            throw new RuntimeException("Cannot change the type of a topic to null");
        }
        if (this.messageType == null) {
            return new ROS2Topic<K>(this.prefix, this.robotName, this.moduleName, this.ioQualifier, this.typeName, this.suffix, messageType);
        }
        if (Objects.equals(messageType, this.messageType)) {
            return this;
        }
        throw new RuntimeException("Cannot change the type of a topic after it's already been set");
    }

    public <K> ROS2Topic<K> withTypeName(Class<K> messageType) {
        return this.withType(messageType).withTypeName();
    }

    public ROS2Topic<T> withTopic(ROS2Topic<?> topic) {
        String newPrefix = this.takeSecondIfFirstEmpty(this.prefix, topic.prefix);
        String newRobotName = this.takeSecondIfFirstEmpty(this.robotName, topic.robotName);
        String newModuleName = this.takeSecondIfFirstEmpty(this.moduleName, topic.moduleName);
        String newIOQualifier = this.takeSecondIfFirstEmpty(this.ioQualifier, topic.ioQualifier);
        String newTypeName = this.takeSecondIfFirstEmpty(this.typeName, topic.typeName);
        String newSuffix = this.takeSecondIfFirstEmpty(this.suffix, topic.suffix);
        if (topic.messageType != null && !topic.messageType.equals(this.messageType)) {
            throw new RuntimeException("Cannot change the type of a topic with the withTopic method");
        }
        return new ROS2Topic<T>(newPrefix, newRobotName, newModuleName, newIOQualifier, newTypeName, newSuffix, this.messageType);
    }

    private String takeSecondIfFirstEmpty(String first, String second) {
        if (first.isEmpty()) {
            return second;
        }
        return first;
    }

    public Class<T> getType() {
        return this.messageType;
    }

    public String getName() {
        return this.toString();
    }

    public String toString() {
        String topicName = "";
        topicName = topicName + this.prefix;
        topicName = topicName + this.robotName;
        topicName = topicName + this.moduleName;
        topicName = topicName + this.ioQualifier;
        topicName = topicName + this.typeName;
        topicName = topicName + this.suffix;
        return topicName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ROS2Topic otherTopic = (ROS2Topic)other;
        return this.equals(otherTopic.prefix, otherTopic.robotName, otherTopic.moduleName, otherTopic.ioQualifier, otherTopic.typeName, otherTopic.suffix, otherTopic.messageType);
    }

    private boolean equals(String prefix, String robotName, String moduleName, String ioQualifier, String typeName, String suffix, Class<?> messageType) {
        return Objects.equals(this.prefix, prefix) && Objects.equals(this.robotName, robotName) && Objects.equals(this.moduleName, moduleName) && Objects.equals(this.ioQualifier, ioQualifier) && Objects.equals(this.typeName, typeName) && Objects.equals(this.suffix, suffix) && Objects.equals(this.messageType, messageType);
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.robotName, this.moduleName, this.ioQualifier, this.typeName, this.suffix, this.messageType);
    }
}

