/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ros2;

import java.io.IOException;
import java.net.InetAddress;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.DurabilityKind;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublishModeKind;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.attributes.TopicAttributes;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;
import us.ihmc.ros2.NewMessageListener;
import us.ihmc.ros2.QueuedROS2Subscription;
import us.ihmc.ros2.ROS2Distro;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.ros2.ROS2Subscription;
import us.ihmc.ros2.ROS2TopicNameTools;
import us.ihmc.ros2.RealtimeROS2SubscriptionListener;
import us.ihmc.ros2.SubscriptionMatchedListener;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSPublisherAttributes;
import us.ihmc.rtps.impl.fastRTPS.Time_t;

class ROS2NodeBasics
implements ROS2NodeInterface {
    public static final int ROS_DEFAULT_DOMAIN_ID = ROS2NodeBasics.domainFromEnvironment();
    private final ROS2Distro ros2Distro;
    private Domain domain;
    private Participant participant;
    private final String nodeName;
    private final String namespace;

    ROS2NodeBasics(DomainFactory.PubSubImplementation pubSubImplementation, ROS2Distro ros2Distro, String name, String namespace, int domainId, InetAddress addressRestriction) throws IOException {
        this.domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)pubSubImplementation);
        this.ros2Distro = ros2Distro;
        ROS2TopicNameTools.checkNodename(name);
        ROS2TopicNameTools.checkNamespace(namespace);
        this.nodeName = name;
        this.namespace = namespace;
        ParticipantAttributes attr = this.domain.createParticipantAttributes(domainId, name);
        if (addressRestriction != null) {
            attr.bindToAddress(new InetAddress[]{addressRestriction});
        }
        this.participant = this.domain.createParticipant(attr);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LogTools.info((String)("Shutting down ROS2 node " + name));
            this.destroy();
            ThreadTools.sleep((long)10L);
        }, "IHMCROS2-ROS2NodeBasics-destroy"));
    }

    public <T> ROS2Publisher<T> createPublisher(TopicDataType<T> topicDataType, String topicName) throws IOException {
        return this.createPublisher((TopicDataType)topicDataType, topicName, ROS2QosProfile.DEFAULT());
    }

    public <T> ROS2Publisher<T> createPublisher(TopicDataType<T> topicDataType, String topicName, ROS2QosProfile qosProfile) throws IOException {
        TopicDataType registeredType = this.domain.getRegisteredType(this.participant, topicDataType.getName());
        if (registeredType == null) {
            this.domain.registerType(this.participant, topicDataType);
        }
        PublisherAttributes publisherAttributes = this.domain.createPublisherAttributes();
        publisherAttributes.getTopic().setTopicKind(topicDataType.isGetKeyDefined() ? TopicAttributes.TopicKind.WITH_KEY : TopicAttributes.TopicKind.NO_KEY);
        publisherAttributes.getTopic().setTopicDataType(topicDataType.getName());
        publisherAttributes.getQos().setReliabilityKind(qosProfile.getReliability());
        if (publisherAttributes instanceof FastRTPSPublisherAttributes) {
            FastRTPSPublisherAttributes fastRTPSPublisherAttributes = (FastRTPSPublisherAttributes)publisherAttributes;
            Time_t heartbeatPeriod = new Time_t();
            heartbeatPeriod.setSeconds(0);
            long fraction = 4294967L;
            LogTools.debug((String)"Fraction: {}", (Object)fraction);
            heartbeatPeriod.setFraction(fraction);
            fastRTPSPublisherAttributes.getTimes().setHeartbeatPeriod(heartbeatPeriod);
        }
        switch (qosProfile.getDurability()) {
            case TRANSIENT_LOCAL: {
                publisherAttributes.getQos().setDurabilityKind(DurabilityKind.TRANSIENT_LOCAL_DURABILITY_QOS);
                break;
            }
            case VOLATILE: {
                publisherAttributes.getQos().setDurabilityKind(DurabilityKind.VOLATILE_DURABILITY_QOS);
            }
        }
        publisherAttributes.getTopic().getHistoryQos().setDepth(qosProfile.getSize());
        publisherAttributes.getTopic().getHistoryQos().setKind(qosProfile.getHistory());
        ROS2TopicNameTools.assignNameAndPartitionsToAttributes(this.ros2Distro, publisherAttributes, this.namespace, this.nodeName, topicName, qosProfile.isAvoidRosNamespaceConventions());
        if (topicDataType.getTypeSize() > 65000) {
            publisherAttributes.getQos().setPublishMode(PublishModeKind.ASYNCHRONOUS_PUBLISH_MODE);
        }
        return new ROS2Publisher(this.domain, this.domain.createPublisher(this.participant, publisherAttributes));
    }

    @Override
    public <T> QueuedROS2Subscription<T> createQueuedSubscription(TopicDataType<T> topicDataType, String topicName, ROS2QosProfile qosProfile, int queueSize) throws IOException {
        RealtimeROS2SubscriptionListener<T> listener = new RealtimeROS2SubscriptionListener<T>(topicDataType, queueSize);
        ROS2Subscription<T> subscriber = this.createSubscription(topicDataType, listener, topicName, qosProfile);
        return new QueuedROS2Subscription<T>(subscriber, listener);
    }

    @Override
    public <T> ROS2Subscription<T> createSubscription(TopicDataType<T> topicDataType, NewMessageListener<T> newMessageListener, String topicName) throws IOException {
        return this.createSubscription(topicDataType, newMessageListener, topicName, ROS2QosProfile.DEFAULT());
    }

    @Override
    public <T> ROS2Subscription<T> createSubscription(TopicDataType<T> topicDataType, NewMessageListener<T> newMessageListener, String topicName, ROS2QosProfile qosProfile) throws IOException {
        return this.createSubscription(topicDataType, (SubscriberListener<T>)newMessageListener, topicName, qosProfile);
    }

    @Override
    public <T> ROS2Subscription<T> createSubscription(TopicDataType<T> topicDataType, final NewMessageListener<T> newMessageListener, final SubscriptionMatchedListener<T> subscriptionMatchedListener, String topicName, ROS2QosProfile qosProfile) throws IOException {
        return this.createSubscription(topicDataType, new SubscriberListener<T>(){

            public void onNewDataMessage(Subscriber<T> subscriber) {
                newMessageListener.onNewDataMessage(subscriber);
            }

            public void onSubscriptionMatched(Subscriber<T> subscriber, MatchingInfo info) {
                subscriptionMatchedListener.onSubscriptionMatched(subscriber, info);
            }
        }, topicName, qosProfile);
    }

    private <T> ROS2Subscription<T> createSubscription(TopicDataType<T> topicDataType, SubscriberListener<T> subscriberListener, String topicName, ROS2QosProfile qosProfile) throws IOException {
        TopicDataType registeredType = this.domain.getRegisteredType(this.participant, topicDataType.getName());
        if (registeredType == null) {
            this.domain.registerType(this.participant, topicDataType);
        }
        SubscriberAttributes subscriberAttributes = this.domain.createSubscriberAttributes();
        subscriberAttributes.getTopic().setTopicKind(topicDataType.isGetKeyDefined() ? TopicAttributes.TopicKind.WITH_KEY : TopicAttributes.TopicKind.NO_KEY);
        subscriberAttributes.getTopic().setTopicDataType(topicDataType.getName());
        subscriberAttributes.getTopic().setTopicName(topicName);
        subscriberAttributes.getQos().setReliabilityKind(qosProfile.getReliability());
        switch (qosProfile.getDurability()) {
            case TRANSIENT_LOCAL: {
                subscriberAttributes.getQos().setDurabilityKind(DurabilityKind.TRANSIENT_LOCAL_DURABILITY_QOS);
                break;
            }
            case VOLATILE: {
                subscriberAttributes.getQos().setDurabilityKind(DurabilityKind.VOLATILE_DURABILITY_QOS);
            }
        }
        subscriberAttributes.getTopic().getHistoryQos().setDepth(qosProfile.getSize());
        subscriberAttributes.getTopic().getHistoryQos().setKind(qosProfile.getHistory());
        ROS2TopicNameTools.assignNameAndPartitionsToAttributes(this.ros2Distro, subscriberAttributes, this.namespace, this.nodeName, topicName, qosProfile.isAvoidRosNamespaceConventions());
        return new ROS2Subscription(this.domain, this.domain.createSubscriber(this.participant, subscriberAttributes, subscriberListener));
    }

    @Override
    public String getName() {
        return this.nodeName;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void destroy() {
        if (this.domain != null) {
            block3: {
                try {
                    this.domain.removeParticipant(this.participant);
                }
                catch (IllegalArgumentException e) {
                    if (e.getMessage().contains("This participant is not registered with this domain")) break block3;
                    throw e;
                }
            }
            this.domain = null;
        }
        this.participant = null;
    }

    public static int domainFromEnvironment() {
        String rosDomainId = System.getenv("ROS_DOMAIN_ID");
        int rosDomainIdAsInteger = 0;
        if (rosDomainId != null) {
            rosDomainId = rosDomainId.trim();
            try {
                rosDomainIdAsInteger = Integer.valueOf(rosDomainId);
            }
            catch (NumberFormatException e) {
                LogTools.warn((String)"Environment variable ROS_DOMAIN_ID cannot be parsed as an integer: {}", (Object)rosDomainId);
            }
        }
        LogTools.info((String)"ROS_DOMAIN_ID from environment is {} (fallback only; ignore if set manually)", (Object)rosDomainIdAsInteger);
        return rosDomainIdAsInteger;
    }
}

