/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.platform.web;

import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.KosmoSController;
import de.kosmos_lab.platform.data.Device;
import de.kosmos_lab.platform.data.Event;
import de.kosmos_lab.platform.rules.RulesService;
import de.kosmos_lab.platform.smarthome.CommandInterface;
import de.kosmos_lab.platform.smarthome.CommandSourceName;
import de.kosmos_lab.platform.smarthome.EventInterface;
import de.kosmos_lab.platform.web.KeyCloakAdapter;
import de.kosmos_lab.platform.web.KosmoSWebSocketService;
import de.kosmos_lab.platform.web.servlets.KosmoSServlet;
import de.kosmos_lab.web.annotations.enums.SchemaType;
import de.kosmos_lab.web.annotations.enums.SecurityIn;
import de.kosmos_lab.web.annotations.enums.SecurityType;
import de.kosmos_lab.web.annotations.info.AsyncInfo;
import de.kosmos_lab.web.annotations.info.Contact;
import de.kosmos_lab.web.annotations.info.Info;
import de.kosmos_lab.web.annotations.info.License;
import de.kosmos_lab.web.annotations.media.ObjectSchema;
import de.kosmos_lab.web.annotations.media.ObjectSchemas;
import de.kosmos_lab.web.annotations.media.Schema;
import de.kosmos_lab.web.annotations.media.SchemaProperty;
import de.kosmos_lab.web.annotations.media.Schemas;
import de.kosmos_lab.web.annotations.security.SecuritySchema;
import de.kosmos_lab.web.annotations.security.SecuritySchemas;
import de.kosmos_lab.web.annotations.servers.Server;
import de.kosmos_lab.web.annotations.servers.Servers;
import de.kosmos_lab.web.data.IUser;
import de.kosmos_lab.web.doc.openapi.ApiEndpoint;
import de.kosmos_lab.web.doc.openapi.WebSocketEndpoint;
import de.kosmos_lab.web.server.WebServer;
import de.kosmos_lab.web.server.WebSocketCreator;
import de.kosmos_lab.web.server.WebSocketService;
import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServlet;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.websocket.server.JettyWebSocketServlet;
import org.eclipse.jetty.websocket.server.JettyWebSocketServletFactory;
import org.json.JSONObject;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.common.VerificationException;
import org.reflections.ReflectionsException;

@Info(description="# Kosmos Platform openApi HTTP API \nThis is the OpenAPI 3.0 specifaction for KosmoS, please always use the latest documentation found in your installation on [/doc/openapi.html](/doc/openapi.html) in your installation.\nPlease make sure you are logged in if you want to try to execute any request to the server.\nYou can simply login with the form injected to the top of the page.\n(Almost) all POST requests with simple a datatype for parameters can be used either with parameters in query or a JSONObject in the request body. Exceptions are more complex datatypes like JSONObjects themselves (for example for /schema/add).\n## YAML specification\nYou can find the newest openapi specification on [/doc/openapi.yaml](/doc/openapi.yaml) or [/doc/openapi.json](/doc/openapi.json).\nThe human readable description of the openapi can be found [/doc/openapi.html](/doc/openapi.html).\nYou can find the newest asyncapi specification on [/doc/asyncapi.yaml](/doc/asyncapi.yaml) or [/doc/asyncapi.json](/doc/asyncapi.json).\nThe human readable description of the asyncapi can be found [/doc/asyncapi.html](/doc/asyncapi.html).\n**NOTE**: These files are automatically generated and also contain your plugins etc.", title="KosmoS openApi", version="filled-by-code", license=@License(name="Apache 2.0", url="http://www.apache.org/licenses/LICENSE-2.0.html"), contact=@Contact(name="Jan Janssen", email="Jan.Janssen@dfki.de"))
@AsyncInfo(description="# KosmoS ASynchron API\n## KosmoS async webservice\nAll operations tagged with \"KosmoS\" are part of the default websocket and mqtt service.\n## YAML specification\nYou can find the newest openapi specification on [/doc/openapi.yaml](/doc/openapi.yaml) or [/doc/openapi.json](/doc/openapi.json).\nThe human readable description of the openapi can be found [/doc/openapi.html](/doc/openapi.html).\nYou can find the newest asyncapi specification on [/doc/asyncapi.yaml](/doc/asyncapi.yaml) or [/doc/asyncapi.json](/doc/asyncapi.json).\nThe human readable description of the asyncapi can be found [/doc/asyncapi.html](/doc/asyncapi.html).\n**NOTE**: These files are automatically generated and also contain your plugins etc.", title="KosmoS asyncApi", version="filled-by-code", license=@License(name="Apache 2.0", url="http://www.apache.org/licenses/LICENSE-2.0.html"), contact=@Contact(name="Jan Janssen", email="Jan.Janssen@dfki.de"))
@ObjectSchemas(value={@ObjectSchema(componentName="groupNameID", properties={@SchemaProperty(name="name", schema=@Schema(description="The name of the group", type=SchemaType.STRING, required=true)), @SchemaProperty(name="id", schema=@Schema(description="The ID of the group", type=SchemaType.INTEGER, required=true))}), @ObjectSchema(componentName="event", properties={@SchemaProperty(name="type", schema=@Schema(description="The type of the event", type=SchemaType.STRING, required=true)), @SchemaProperty(name="value", schema=@Schema(description="The actual payload of the event,can be a anything the sender needs to send with an event", required=true))}), @ObjectSchema(componentName="deviceEvent", properties={@SchemaProperty(name="type", schema=@Schema(description="The type of the event", type=SchemaType.STRING, required=true)), @SchemaProperty(name="value", schema=@Schema(description="The actual payload of the event,can be a anything the sender needs to send with an event", required=false)), @SchemaProperty(name="uuid", schema=@Schema(description="The UUID of the device this event belongs to, events will only be visible for users with read access to the device", type=SchemaType.STRING, required=true))}), @ObjectSchema(componentName="scopeNameID", properties={@SchemaProperty(name="name", schema=@Schema(description="The name of the scope", type=SchemaType.STRING, required=true)), @SchemaProperty(name="id", schema=@Schema(description="The ID of the scope", type=SchemaType.INTEGER, required=true))}), @ObjectSchema(componentName="userNameID", properties={@SchemaProperty(name="name", schema=@Schema(description="The name of the user", type=SchemaType.STRING, required=true)), @SchemaProperty(name="id", schema=@Schema(description="The ID of the user", type=SchemaType.INTEGER, required=true))}), @ObjectSchema(componentName="objectID", properties={@SchemaProperty(name="id", schema=@Schema(description="The ID", type=SchemaType.INTEGER, required=true))}), @ObjectSchema(componentName="nameID", properties={@SchemaProperty(name="name", schema=@Schema(description="The name", type=SchemaType.STRING, required=true)), @SchemaProperty(name="id", schema=@Schema(description="The ID", type=SchemaType.INTEGER, required=true))})})
@Schemas(value={@Schema(name="username", type=SchemaType.STRING, description="The name of a user"), @Schema(name="userID", type=SchemaType.INTEGER, description="The ID of a user"), @Schema(name="userName", type=SchemaType.STRING, description="The name of a user"), @Schema(name="scopeID", type=SchemaType.INTEGER, description="The ID of a scope"), @Schema(name="scopeName", type=SchemaType.STRING, description="The name of a scope"), @Schema(name="groupID", type=SchemaType.INTEGER, description="The ID of a group"), @Schema(name="groupName", type=SchemaType.STRING, description="The name of a group")})
@Servers(value={@Server(description="Current Host", url="http://${host}"), @Server(description="Local Test", url="http://localhost:18080"), @Server(description="Production", url="https://example.cloud:18081")})
@SecuritySchemas(value={@SecuritySchema(componentName="bearerAuth", description="contains a JSON Web Tokens (JWT) obtainable from #post-/user/login", type=SecurityType.HTTP, bearerFormat="JWT", scheme="bearer"), @SecuritySchema(componentName="basicAuth", description="basic auth is also allowed for all requests", type=SecurityType.HTTP, scheme="basic"), @SecuritySchema(componentName="secret", name="token", description="Contains a secret known to both parties", type=SecurityType.APIKEY, in=SecurityIn.QUERY)})
public class KosmoSWebServer
extends WebServer
implements CommandInterface,
EventInterface {
    private final IController controller;
    protected KosmoSWebSocketService webSocketService = null;
    ConcurrentHashMap<UUID, KeyCloakAdapter> kcs = new ConcurrentHashMap();
    ConcurrentHashMap<UUID, String> redirectTo = new ConcurrentHashMap();

    public KosmoSWebServer(IController controller) throws Exception {
        this.controller = controller;
        this.prepare();
        this.start();
        controller.addCommandInterface(this);
    }

    public void prepare() {
        super.prepare();
        this.findServlets(new String[]{"de.kosmos_lab.platform.web"}, KosmoSServlet.class, WebSocketService.class);
        try {
            JettyWebSocketServlet websocketServlet;
            this.webSocketService = new KosmoSWebSocketService(this, this.controller);
            WebSocketEndpoint wse = this.webSocketService.getClass().getAnnotation(WebSocketEndpoint.class);
            if (wse != null) {
                websocketServlet = new JettyWebSocketServlet(){

                    protected void configure(JettyWebSocketServletFactory factory) {
                        factory.setIdleTimeout(Duration.ofSeconds(60L));
                        factory.setCreator((JettyWebSocketCreator)new WebSocketCreator((WebSocketService)KosmoSWebServer.this.webSocketService, null));
                    }
                };
                this.wsPaths.add(wse.path());
                this.context.addServlet(new ServletHolder((Servlet)websocketServlet), this.webSocketService.getClass().getAnnotation(WebSocketEndpoint.class).path());
            }
            if (this.getRulesService() != null && (wse = ((Object)((Object)this.getRulesService())).getClass().getAnnotation(WebSocketEndpoint.class)) != null) {
                websocketServlet = new JettyWebSocketServlet(){

                    protected void configure(JettyWebSocketServletFactory factory) {
                        factory.setIdleTimeout(Duration.ofSeconds(60L));
                        factory.setCreator((JettyWebSocketCreator)new WebSocketCreator((WebSocketService)KosmoSWebServer.this.getRulesService(), null));
                    }
                };
                this.context.addServlet(new ServletHolder((Servlet)websocketServlet), wse.path());
                this.wsPaths.add(wse.path());
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    public HttpServlet create(Class<? extends HttpServlet> servlet, ApiEndpoint api) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (api.userLevel() >= 0) {
            return servlet.getConstructor(KosmoSWebServer.class, IController.class, Integer.TYPE).newInstance(this, this.controller, api.userLevel());
        }
        try {
            return servlet.getConstructor(KosmoSWebServer.class, IController.class).newInstance(this, this.controller);
        }
        catch (NoSuchMethodException ex) {
            try {
                return servlet.getConstructor(KosmoSWebServer.class).newInstance(this);
            }
            catch (NoSuchMethodException exx) {
                return servlet.getConstructor(WebServer.class).newInstance(this);
            }
        }
    }

    public WebSocketService create(Class<? extends WebSocketService> servlet, WebSocketEndpoint api) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            return servlet.getConstructor(KosmoSWebServer.class, IController.class).newInstance(this, this.controller);
        }
        catch (NoSuchMethodException ex) {
            try {
                return servlet.getConstructor(KosmoSWebServer.class).newInstance(this);
            }
            catch (NoSuchMethodException exx) {
                return servlet.getConstructor(WebServer.class).newInstance(this);
            }
        }
    }

    public JSONObject getConfig() {
        return this.controller.getConfig().getJSONObject("webserver");
    }

    public void findServlets(String[] namespaces, Class<? extends HttpServlet> baseServletClass, Class<? extends WebSocketService> baseSocketClass) {
        super.findServlets(namespaces, baseServletClass, baseSocketClass);
        try {
            for (Class c : this.controller.getPluginManager().getClassesFor(KosmoSServlet.class)) {
                if (this.servlets.contains(c) || this.servclasses.contains(c.getName())) continue;
                this.servclasses.add(c.getName());
                logger.info("PMM found KosmoSServlet: {}", (Object)c.getName());
                this.servlets.add(c);
            }
        }
        catch (ReflectionsException reflectionsException) {
            // empty catch block
        }
        try {
            for (Class c : this.controller.getPluginManager().getClassesFor(WebSocketService.class)) {
                if (this.wsservices.contains(c) || this.wssclasses.contains(c.getName())) continue;
                this.wssclasses.add(c.getName());
                logger.info("PMM found WebSocketService: {}", (Object)c.getName());
                this.wsservices.add(c);
            }
        }
        catch (ReflectionsException reflectionsException) {
            // empty catch block
        }
    }

    public IController getIController() {
        return this.controller;
    }

    public RulesService getRulesService() {
        return this.controller.getRulesService();
    }

    @Override
    public String getSourceName() {
        return "HTTPApi";
    }

    @Override
    public void deviceAdded(@Nullable CommandInterface from, @Nonnull Device device, @Nonnull CommandSourceName source) {
    }

    @Override
    public void deviceRemoved(@Nullable CommandInterface from, @Nonnull Device device, @Nonnull CommandSourceName source) {
    }

    @Override
    public void deviceUpdate(@Nullable CommandInterface from, @Nonnull Device device, @Nullable String key, @Nonnull CommandSourceName source) {
    }

    public String toString() {
        return "WebServer";
    }

    public KosmoSWebSocketService getWebSocketService() {
        return this.webSocketService;
    }

    public String replaceHostName(String text, String host) {
        String[] h = host.split(":");
        String hostname = host;
        String port = "";
        if (h.length == 2) {
            hostname = h[0];
            port = h[1];
        }
        text = text.replace("mqtt://${host}", String.format("mqtt://%s:%d", hostname, ((KosmoSController)this.controller).getMQTT().getPort()));
        text = text.replace("${host}", String.format("%s:%s", hostname, port));
        return text;
    }

    @Override
    public void eventFired(@Nullable EventInterface from, @Nonnull Event event) {
    }

    public IUser processKC(String code, UUID uuid) {
        KeyCloakAdapter kc = this.kcs.get(uuid);
        if (kc != null) {
            try {
                kc.process(code);
                IUser user = this.controller.getUserCreateIfUnavailable(String.format("kc:%s", kc.getToken().getPreferredUsername()));
                return user;
            }
            catch (ServerRequest.HttpFailure e) {
                throw new RuntimeException(e);
            }
            catch (VerificationException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public String getRedirectTo(UUID uuid) {
        return this.redirectTo.get(uuid);
    }

    public String getOpenIDLink(String host, String path, String returnTo) {
        JSONObject kc = this.getConfig().optJSONObject("keycloak");
        if (kc != null) {
            try {
                KeyCloakAdapter keycloak = new KeyCloakAdapter(kc.getString("server"), kc.getString("realm"), kc.getString("clientId"), kc.getString("clientSecret"));
                UUID uuid = UUID.randomUUID();
                while (this.kcs.containsKey(uuid)) {
                    uuid = UUID.randomUUID();
                }
                String redirectUri = null;
                if (returnTo != null && returnTo.startsWith("http://")) {
                    redirectUri = String.format("http://%s%s", host, path);
                }
                if (redirectUri == null) {
                    String.format("https://%s%s", host, path);
                }
                this.kcs.put(uuid, keycloak);
                if (returnTo != null) {
                    this.redirectTo.put(uuid, returnTo);
                }
                String aurl = keycloak.getAuthUrl(redirectUri, uuid.toString());
                return aurl;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            logger.info("WS Config: {}", (Object)this.getConfig());
        }
        return null;
    }
}

