package de.kosmos_lab.platform.persistence;

import de.kosmos_lab.platform.data.DeviceText;
import de.kosmos_lab.platform.exceptions.DeviceNotFoundException;
import de.kosmos_lab.platform.smarthome.CommandSourceName;
import de.kosmos_lab.web.data.IUser;
import de.kosmos_lab.platform.data.DataSchema;
import de.kosmos_lab.platform.data.Device;
import de.kosmos_lab.platform.data.Group;
import de.kosmos_lab.platform.data.KosmoSUser;
import de.kosmos_lab.platform.data.LogEntry;
import de.kosmos_lab.platform.data.Scope;
import de.kosmos_lab.platform.exceptions.GroupNotFoundException;
import de.kosmos_lab.platform.exceptions.UserNotFoundException;
import de.kosmos_lab.platform.IController;
import de.kosmos_lab.platform.persistence.Constants.CacheMode;
import de.kosmos_lab.web.persistence.exceptions.NotFoundInPersistenceException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.json.JSONObject;
import org.slf4j.LoggerFactory;

import java.sql.ResultSet;
import java.sql.SQLException;

@SuppressFBWarnings("NM_METHOD_NAMING_CONVENTION")

public class Models {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger("Models");

    /**
     * this class is automatically generated from the actual SQL database scheme of the table `device_location` and will
     * be manually adapted by new queries and the parse method.
     */
    public static class SQL_Device_Location {
        // {{ begin autogenerated code from SQL
        public static class Field {
            public static final String uuid = "`uuid`";
            public static final String x = "`x`";
            public static final String y = "`y`";
            public static final String z = "`z`";
            public static final String w = "`w`";
            public static final String d = "`d`";
            public static final String h = "`h`";
            public static final String roll = "`roll`";
            public static final String pitch = "`pitch`";
            public static final String yaw = "`yaw`";
            public static final String area = "`area`";
        }

        public static class Getter {
            public static String uuid(ResultSet rs) throws SQLException {
                return rs.getString(Index.uuid);
            }

            public static Integer x(ResultSet rs) throws SQLException {
                return rs.getInt(Index.x);
            }

            public static Integer y(ResultSet rs) throws SQLException {
                return rs.getInt(Index.y);
            }

            public static Integer z(ResultSet rs) throws SQLException {
                return rs.getInt(Index.z);
            }

            public static Integer w(ResultSet rs) throws SQLException {
                return rs.getInt(Index.w);
            }

            public static Integer d(ResultSet rs) throws SQLException {
                return rs.getInt(Index.d);
            }

            public static Integer h(ResultSet rs) throws SQLException {
                return rs.getInt(Index.h);
            }

            public static Integer roll(ResultSet rs) throws SQLException {
                return rs.getInt(Index.roll);
            }

            public static Integer pitch(ResultSet rs) throws SQLException {
                return rs.getInt(Index.pitch);
            }

            public static Integer yaw(ResultSet rs) throws SQLException {
                return rs.getInt(Index.yaw);
            }

            public static String area(ResultSet rs) throws SQLException {
                return rs.getString(Index.area);
            }
        }

        public static class Index {
            public static final int uuid = 1;
            public static final int x = 2;
            public static final int y = 3;
            public static final int z = 4;
            public static final int w = 5;
            public static final int d = 6;
            public static final int h = 7;
            public static final int roll = 8;
            public static final int pitch = 9;
            public static final int yaw = 10;
            public static final int area = 11;
        }

        public final static String table = "`device_location`";
        public final static String fields = Field.uuid + "," + Field.x + "," + Field.y + "," + Field.z + "," + Field.w + "," + Field.d + "," + Field.h + "," + Field.roll + "," + Field.pitch + "," + Field.yaw + "," + Field.area;
        public final static String selectAll = "select " + fields + " from " + table;
        public final static String add = "REPLACE into " + table + " (" + Field.uuid + "," + Field.x + "," + Field.y + "," + Field.z + "," + Field.w + "," + Field.d + "," + Field.h + "," + Field.roll + "," + Field.pitch + "," + Field.yaw + "," + Field.area + ") values (?,?,?,?,?,?,?,?,?,?,?)";


        // }} end autogenerated code
        public final static Device.Location parse(IController controller, ResultSet rs, boolean getData) {
            try {
                Device.Location loc = new Device.Location(Getter.x(rs), Getter.y(rs), Getter.z(rs), Getter.w(rs), Getter.d(rs), Getter.h(rs), Getter.roll(rs), Getter.pitch(rs), Getter.yaw(rs), Getter.area(rs));
                controller.setDeviceLocation(Getter.uuid(rs), loc);
                return loc;

            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        // {{ custom queries not generated:
        public final static String create = "CREATE TABLE " + table + " (\n" +
                "\t" + Field.uuid + " VARCHAR(128) NOT NULL,\n" +
                "\t" + Field.x + " INTEGER NULL,\n" +
                "\t" + Field.y + " INTEGER NULL,\n" +
                "\t" + Field.z + " INTEGER NULL,\n" +
                "\t" + Field.w + " INTEGER NULL,\n" +
                "\t" + Field.d + " INTEGER NULL,\n" +
                "\t" + Field.h + " INTEGER NULL,\n" +
                "\t" + Field.roll + " INTEGER NULL,\n" +
                "\t" + Field.pitch + " INTEGER NULL,\n" +
                "\t" + Field.yaw + " INTEGER NULL,\n" +
                "\t" + Field.area + " VARCHAR(128) NULL,\n" +

                "\tPRIMARY KEY (" + SQL_Devices.Field.uuid + ")\n" +
                ")\n" +
                ";CREATE UNIQUE INDEX idx_device_location_uuid \n" +
                "ON " + table + " (" + Field.uuid + ");\n";
        // }}
    }

    /**
     * this class is automatically generated from the actual SQL database scheme of the table `states` and will be
     * manually adapted by new queries and the parse method.
     */
    public static class SQL_States {
        // {{ begin autogenerated code from SQL
        public static class Field {
            public static final String uuid = "`uuid`";
            public static final String state = "`state`";
            public static final String date = "`date`";
            public static final String source = "`source`";
        }

        public static class Getter {
            public static String Uuid(ResultSet rs) throws SQLException {
                return rs.getString(Index.Uuid);
            }

            public static String State(ResultSet rs) throws SQLException {
                return rs.getString(Index.State);
            }

            public static long Date(ResultSet rs) throws SQLException {
                return rs.getLong(Index.Date);
            }

            public static String Source(ResultSet rs) throws SQLException {
                return rs.getString(Index.Source);
            }
        }

        public static class Index {
            public static final int Uuid = 1;
            public static final int State = 2;
            public static final int Date = 3;
            public static final int Source = 4;
        }

        public final static String table = "`states`";
        public final static String fields = Field.uuid + "," + Field.state + "," + Field.date + "," + Field.source;
        public final static String selectAll = "select " + fields + " from " + table;
        public final static String add = "insert into " + table + " (" + Field.uuid + "," + Field.state + "," + Field.date + "," + Field.source + ") values (?,?,?,?)";
        public final static String deleteAllByUUID = "delete from " + table + " where " + Field.uuid + "=?";

        // }} end autogenerated code
        public final static LogEntry parse(IController controller, ResultSet rs, boolean getData) {
            try {
                return new LogEntry(Getter.Uuid(rs), Getter.Date(rs), Getter.Source(rs), new JSONObject(Getter.State(rs)));

            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        // {{ custom queries not generated:
        public final static String selectLastByUUID = "select " + fields + " from " + table + " where " + Field.uuid + "=? ORDER BY " + Field.date + " DESC LIMIT 0,1";
        public final static String selectAllByUUIDS = "select " + fields + " from " + table + " where " + Field.uuid + " IN ? AND " + Field.date + ">=? AND " + Field.date + "<=? ORDER BY " + Field.date;
        public final static String selectAllBetween = "select " + fields + " from " + table + " where " + Field.date + ">=? AND " + Field.date + "<=? ORDER BY " + Field.date;

        public final static String create = "CREATE TABLE " + table + " (\n" +
                "\t" + Field.uuid + " VARCHAR(128) NOT NULL,\n" +
                "\t" + Field.state + " TEXT NOT NULL,\n" +
                "\t" + Field.date + " BIGINT NOT NULL,\n" +
                "\t" + Field.source + " TEXT NULL\n" +
                ")\n" +
                ";" +
                "CREATE INDEX idx_states_uuid  ON " + table + " (" + Field.uuid + ");\n" +
                "CREATE INDEX idx_states_date  ON " + table + " (" + Field.date + ");\n";
        // }}
    }
    public static class SQL_Device_Text {
        // {{ begin autogenerated code from SQL
        public static class Field {
            public static final String uuid = "`uuid`";
            public static final String value = "`value`";
            public static final String key = "`key`";
        }

        public static class Getter {
            public static String Uuid(ResultSet rs) throws SQLException {
                return rs.getString(Index.Uuid);
            }

            public static String Value(ResultSet rs) throws SQLException {
                return rs.getString(Index.Value);
            }


            public static String Key(ResultSet rs) throws SQLException {
                return rs.getString(Index.Key);
            }
        }

        public static class Index {
            public static final int Uuid = 1;
            public static final int Key = 2;
            public static final int Value = 3;
        }

        public final static String table = "`device_text`";
        public final static String fields = Field.uuid + "," + Field.key + "," + Field.value;
        public final static String selectAll = "select " + fields + " from " + table;
        public final static String add = "insert into " + table + " (" + Field.uuid + "," + Field.key + "," + Field.value + ") values (?,?,?)";
        public final static String updateValue = "update " + table + " SET " + Field.value + "=? where "+Field.uuid+"=? AND "+Field.key+"=?";
        public final static String deleteAllByUUID = "delete from " + table + " where " + Field.uuid + "=?";
        public final static String selectByUUID = "select " + fields + " from " + table + " where " + Field.uuid + "= ? ";

        // }} end autogenerated code
        public final static DeviceText parse(IController controller, ResultSet rs, boolean getData) {
            try {
                try {
                    Device d  = controller.getDevice(Getter.Uuid(rs));
                    DeviceText dt =  new DeviceText(d, Getter.Key(rs), Getter.Value(rs));
                    //d.addText(dt);
                } catch (DeviceNotFoundException ex ) {

                }

            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        // {{ custom queries not generated:

        public final static String selectAllByUUIDS = "select " + fields + " from " + table + " where " + Field.uuid + " IN ? ";


        public final static String create = "CREATE TABLE " + table + " (\n" +
                "\t" + Field.uuid + " VARCHAR(128) NOT NULL,\n" +
                "\t" + Field.key + " TEXT NOT NULL,\n" +
                "\t" + Field.value + " TEXT NULL\n" +
                ")\n" +
                ";" +
                "CREATE INDEX idx_text_uuid  ON " + table + " (" + Field.uuid + ");\n" +
                "CREATE UNIQUE INDEX idx_text_uuid_key ON " + table + " (" + Field.uuid + "," + Field.key + ")";
        // }}
    }
    /**
     * this class is automatically generated from the actual SQL database scheme of the table `devices` and will be
     * manually adapted by new queries and the parse method.
     */
    public static class SQL_Devices {
        // {{ begin autogenerated code from SQL
        public static class Field {
            public static final String uuid = "`uuid`";
            public static final String name = "`name`";
            public static final String schema = "`schema`";
            public static final String source = "`source`";
            public static final String lastUpdate = "`lastUpdate`";
            public static final String owner = "`owner`";
        }

        public static class Getter {
            public static String uuid(ResultSet rs) throws SQLException {
                return rs.getString(Index.uuid);
            }

            public static String name(ResultSet rs) throws SQLException {
                return rs.getString(Index.name);
            }

            public static String schema(ResultSet rs) throws SQLException {
                return rs.getString(Index.schema);
            }

            public static String source(ResultSet rs) throws SQLException {
                return rs.getString(Index.source);
            }

            public static Integer owner(ResultSet rs) throws SQLException {
                return rs.getInt(Index.owner);
            }

            public static Integer lastupdate(ResultSet rs) throws SQLException {
                int v = rs.getInt(Index.lastupdate);
                if (rs.wasNull()) {
                    return null;
                }
                return v;
            }
        }

        public static class Index {
            public static final int uuid = 1;
            public static final int name = 2;
            public static final int schema = 3;
            public static final int source = 4;
            public static final int lastupdate = 5;
            public static final int owner = 6;
        }

        public final static String table = "`devices`";
        public final static String fields = Field.uuid + "," + Field.name + "," + Field.schema + "," + Field.source + "," + Field.lastUpdate + "," + Field.owner;
        public final static String selectAll = "select " + fields + " from " + table;
        public final static String selectByuuid = "select " + fields + " from " + table + " where " + Field.uuid + "=?";
        public final static String deleteByuuid = "delete from " + table + "  where " + Field.uuid + "=?";
        public final static String updateuuidByuuid = "update " + table + " set " + Field.uuid + "=? where " + Field.uuid + "=?";
        public final static String updatenameByuuid = "update " + table + " set " + Field.name + "=? where " + Field.uuid + "=?";
        public final static String updateschemaByuuid = "update " + table + " set " + Field.schema + "=? where " + Field.uuid + "=?";
        public final static String updatesourceByuuid = "update " + table + " set " + Field.source + "=? where " + Field.uuid + "=?";
        public final static String updatelastupdateByuuid = "update " + table + " set " + Field.lastUpdate + "=? where " + Field.uuid + "=?";
        public final static String removesourceByuuid = "update " + table + " set " + Field.source + "=NULL where " + Field.uuid + "=?";
        public final static String removelastupdateByuuid = "update " + table + " set " + Field.lastUpdate + "=NULL where " + Field.uuid + "=?";
        public final static String add = "insert into " + table + " (" + Field.uuid + "," + Field.name + "," + Field.schema + "," + Field.source + "," + Field.lastUpdate + "," + Field.owner + ") values (?,?,?,?,?,?)";
        public final static String addOrUpdate = "insert into " + table + " (" + Field.uuid + "," + Field.name + "," + Field.schema + "," + Field.source + "," + Field.lastUpdate + "," + Field.owner + ") values (?,?,?,?,?.?,?) ON DUPLICATE KEY UPDATE " + Field.name + "=VALUES(" + Field.name + "), " + Field.schema + "=VALUES(" + Field.schema + "), " + Field.source + "=VALUES(" + Field.source + "), " + Field.lastUpdate + "=VALUES(" + Field.lastUpdate + ", " + Field.owner + "=VALUES(" + Field.owner + ") ";
        public final static String update = " UPDATE " + table + " set " + Field.name + "=?, " + Field.schema + "=?, " + Field.source + "=?, " + Field.lastUpdate + "=? WHERE " + Field.uuid + "=?";

        public static Device parse(IController controller, ResultSet rs, boolean getData) {
            try {
                DataSchema ds = controller.getSchema(Getter.schema(rs));
                String uuid = Getter.uuid(rs);
                //logger.info("looking for last state");
                JSONObject state = controller.getPersistence().getLastState(uuid);
                //logger.info("/looking for last state");
                CommandSourceName source = controller.getSource(Getter.source(rs));
                IUser owner = controller.getUser(Getter.owner(rs));
                Device d = new Device(controller, source, ds, state, Getter.name(rs), uuid, owner,true);
                controller.cacheDevice(d);
                controller.publishUpdate(null, d, null, source);

            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        // {{ custom queries not generated:
        public final static String getNumberOfDevicesWithSchema = "select count(" + Field.uuid + ") from " + table + " where " + Field.schema + "=?";
        public final static String create = "CREATE TABLE " + table + " (\n" +
                "\t" + Field.uuid + " VARCHAR(128) NOT NULL,\n" +
                "\t" + Field.name + " VARCHAR(128) NOT NULL,\n" +
                "\t" + Field.schema + " VARCHAR(256) NOT NULL,\n" +
                "\t" + Field.source + " VARCHAR(256) NULL,\n" +
                "\t" + Field.lastUpdate + " BIGINT NULL,\n" +
                "\t" + Field.owner + " INTEGER NULL,\n" +
                "\tPRIMARY KEY (" + Field.uuid + ")\n" +
                ")\n" +
                ";\n";
        // }}
    }

    /**
     * this class is automatically generated from the actual SQL database scheme of the table `model_schemas` and will
     * be manually adapted by new queries and the parse method.
     */
    public static class SQL_Model_Schemas {
        // {{ begin autogenerated code from SQL
        public static class Field {
            public static final String model = "`model`";
            public static final String manufacturer = "`manufacturer`";
            public static final String schema = "`schema`";
        }

        public static class Getter {
            public static String model(ResultSet rs) throws SQLException {
                return rs.getString(Index.model);
            }

            public static String manufacturer(ResultSet rs) throws SQLException {
                return rs.getString(Index.manufacturer);
            }

            public static String schema(ResultSet rs) throws SQLException {
                return rs.getString(Index.schema);
            }
        }

        public static class Index {
            public static final int model = 1;
            public static final int manufacturer = 2;
            public static final int schema = 3;
        }

        public final static String table = "`model_schemas`";
        public final static String fields = Field.model + "," + Field.manufacturer + "," + Field.schema;
        public final static String selectAll = "select " + fields + " from " + table;
        public final static String add = "insert into " + table + " (" + Field.model + "," + Field.manufacturer + "," + Field.schema + ") values (?,?,?)";

        // }} end autogenerated code
        public final static Object parse(IController controller, ResultSet rs, boolean getData) {
            try {


            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        // {{ custom queries not generated:
        public final static String create = "CREATE TABLE " + table + " (\n" +
                "\t" + Field.model + " TEXT NOT NULL,\n" +
                "\t" + Field.manufacturer + " TEXT NOT NULL,\n" +
                "\t" + Field.schema + " TEXT NOT NULL\n" +
                ");CREATE UNIQUE INDEX idx_model_schemas \n" +
                "ON " + table + " (" + Field.model + "," + Field.manufacturer + ");";
        // }}
    }

    /**
     * this class is automatically generated from the actual SQL database scheme of the table `schema` and will be
     * manually adapted by new queries and the parse method.
     */
    public static class SQL_Schemas {
        // {{ begin autogenerated code from SQL
        public static class Field {
            public static final String ID = "`ID`";
            public static final String schema = "`schema`";
        }

        public static class Getter {
            public static String ID(ResultSet rs) throws SQLException {
                return rs.getString(Index.ID);
            }

            public static String Schema(ResultSet rs) throws SQLException {
                return rs.getString(Index.Schema);
            }
        }

        public static class Index {
            public static final int ID = 1;
            public static final int Schema = 2;
        }

        public final static String table = "`schemas`";
        public final static String fields = Field.ID + "," + Field.schema;
        public final static String selectAll = "select " + fields + " from " + table;
        public final static String selectByID = "select " + fields + " from " + table + " where " + Field.ID + "=?";
        public final static String deleteByID = "delete from " + table + "  where " + Field.ID + "=?";
        public final static String updateIDByID = "update " + table + " set " + Field.ID + "=? where " + Field.ID + "=?";
        public final static String updateSchemaByID = "update " + table + " set " + Field.schema + "=? where " + Field.ID + "=?";
        public final static String add = "insert into " + table + " (" + Field.ID + "," + Field.schema + ") values (?,?)";
        public final static String addOrUpdate = "insert into " + table + " (" + Field.ID + "," + Field.schema + ") values (?,?) ON DUPLICATE KEY UPDATE " + Field.schema + "=VALUES(" + Field.schema + ") ";
        public final static String update = " UPDATE " + table + " set " + Field.schema + "=? WHERE " + Field.ID + "=?";

        // }} end autogenerated code
        public final static DataSchema parse(IController controller, ResultSet rs, boolean getData) {
            try {
                DataSchema ds = new DataSchema(new JSONObject(Getter.Schema(rs)));
                controller.cacheSchema(ds);
                return ds;

            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        // {{ custom queries not generated:
        public final static String create = "CREATE TABLE " + table + " (\n" +
                "\t" + Field.ID + " VARCHAR(256) NOT NULL,\n" +
                "\t" + Field.schema + " TEXT NOT NULL,\n" +
                "\tPRIMARY KEY (" + Field.ID + "));\n";
        // }}
    }

    /**
     * this class is automatically generated from the actual SQL database scheme of the table `users` and will be
     * manually adapted by new queries and the parse method.
     */
    public static class SQL_Users {
        // {{ begin autogenerated code from SQL
        public static class Field {
            public static final String id = "`id`";
            public static final String name = "`name`";
            public static final String level = "`level`";
            public static final String salt = "`salt`";
            public static final String hash = "`hash`";
        }

        public static class Getter {
            public static Integer ID(ResultSet rs) throws SQLException {
                int v = rs.getInt(Index.ID);
                if (rs.wasNull()) {
                    return null;
                }
                return v;
            }

            public static String name(ResultSet rs) throws SQLException {
                return rs.getString(Index.name);
            }

            public static int level(ResultSet rs) throws SQLException {
                return rs.getInt(Index.level);
            }

            public static String salt(ResultSet rs) throws SQLException {
                return rs.getString(Index.salt);
            }

            public static String hash(ResultSet rs) throws SQLException {
                return rs.getString(Index.hash);
            }
        }

        public static class Index {
            public static final int ID = 1;
            public static final int name = 2;
            public static final int level = 3;
            public static final int salt = 4;
            public static final int hash = 5;
        }

        public final static String table = "`users`";
        public final static String fields = Field.id + "," + Field.name + "," + Field.level + "," + Field.salt + "," + Field.hash;
        public final static String selectAll = "select " + fields + " from " + table;
        public final static String selectByname = "select " + fields + " from " + table + " where " + Field.name + "=?";
        public final static String deleteByname = "delete from " + table + "  where " + Field.name + "=?";
        public final static String updateIDByname = "update " + table + " set " + Field.id + "=? where " + Field.name + "=?";
        public final static String updatenameByname = "update " + table + " set " + Field.name + "=? where " + Field.name + "=?";
        public final static String updatelevelByname = "update " + table + " set " + Field.level + "=? where " + Field.name + "=?";
        public final static String updatesaltByname = "update " + table + " set " + Field.salt + "=? where " + Field.name + "=?";
        public final static String updatehashByname = "update " + table + " set " + Field.hash + "=? where " + Field.name + "=?";
        public final static String removeIDByname = "update " + table + " set " + Field.id + "=NULL where " + Field.name + "=?";
        public final static String add = "insert into " + table + " (" + Field.name + "," + Field.level + "," + Field.salt + "," + Field.hash + ") values (?,?,?,?)";
        public final static String addOrUpdate = "insert into " + table + " (" + Field.name + "," + Field.level + "," + Field.salt + "," + Field.hash + ") values (?,?,?,?) ON DUPLICATE KEY UPDATE " + Field.salt + "=VALUES(" + Field.salt + "), " + Field.level + "=VALUES(" + Field.level + "), " + Field.hash + "=VALUES(" + Field.hash + "), " + Field.id + "=VALUES(" + Field.id + ") ";
        public final static String update = " UPDATE " + table + " set " + Field.salt + "=?, " + Field.level + "=?, " + Field.hash + "=?, " + Field.id + "=? WHERE " + Field.name + "=?";
        // }} end autogenerated code

        public final static KosmoSUser parse(IController controller, ResultSet rs, boolean getData) {
            try {
                KosmoSUser u = new KosmoSUser(controller, Getter.name(rs), Getter.ID(rs), Getter.level(rs), Getter.hash(rs), Getter.salt(rs));
                controller.cacheUser(u);
                return u;
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        // {{ custom queries not generated:
        public final static String create = "CREATE TABLE " + table + " (\n" +
                "\t" + Field.id + " INTEGER PRIMARY KEY AUTOINCREMENT,\n" +
                "\t" + Field.name + " VARCHAR(64) NOT NULL,\n" +
                "\t" + Field.level + " INTEGER NOT NULL,\n" +
                "\t" + Field.salt + " VARCHAR(26) NOT NULL,\n" +
                "\t" + Field.hash + " VARCHAR(64) NOT NULL\n" +
                ")\n" +
                ";\nCREATE UNIQUE INDEX idx_user_name\n" +
                "ON " + table + " (" + Field.name + ");";
        public final static String selectByid = "select " + fields + " from " + table + " where " + Field.id + "=?";

        // }}
    }

    /**
     * this class is automatically generated from the actual SQL database scheme of the table `scope_users` and will be
     * manually adapted by new queries and the parse method.
     */
    public static class SQL_Scope_Users {
        // {{ begin autogenerated code from SQL
        public static class Field {
            public static final String user = "`user`";
            public static final String scope = "`scope`";
        }

        public static class Getter {
            public static int user(ResultSet rs) throws SQLException {
                return rs.getInt(Index.user);
            }

            public static int scope(ResultSet rs) throws SQLException {
                return rs.getInt(Index.scope);
            }
        }

        public static class Index {
            public static final int user = 1;
            public static final int scope = 2;
        }

        public final static String table = "`scope_users`";
        public final static String fields = Field.user + "," + Field.scope;
        public final static String selectAll = "select " + fields + " from " + table;
        public final static String selectByscope = "select " + fields + " from " + table + " where " + Field.scope + "=?";
        public final static String selectByuserAndscope = "select " + fields + " from " + table + " where " + Field.user + "=? AND " + Field.scope + "=?";
        public final static String deleteByscope = "delete from " + table + "  where " + Field.scope + "=?";
        public final static String deleteByuserAndscope = "delete from " + table + "  where " + Field.user + "=? AND " + Field.scope + "=?";
        public final static String updateuserByscope = "update " + table + " set " + Field.user + "=? where " + Field.scope + "=?";
        public final static String updatescopeByscope = "update " + table + " set " + Field.scope + "=? where " + Field.scope + "=?";
        public final static String updateuserByuserAndscope = "update " + table + " set " + Field.user + "=? where " + Field.user + "=? AND " + Field.scope + "=?";
        public final static String updatescopeByuserAndscope = "update " + table + " set " + Field.scope + "=? where " + Field.user + "=? AND " + Field.scope + "=?";
        public final static String add = "insert into " + table + " (" + Field.user + "," + Field.scope + ") values (?,?)";
        public final static String addOrUpdate = "insert into " + table + " (" + Field.user + "," + Field.scope + ") values (?,?) ON DUPLICATE KEY UPDATE " + Field.user + "=VALUES(" + Field.user + "), " + Field.scope + "=VALUES(" + Field.scope + ") ";
        public final static String update = " UPDATE " + table + " set " + Field.user + "=?, " + Field.scope + "=? WHERE " + Field.user + "=?";
        // }} end autogenerated code

        public final static Object parse(IController controller, ResultSet rs, boolean getData) {
            try {

                Scope scope = controller.getScope(Getter.scope(rs), CacheMode.CACHE_AND_PERSISTENCE);
                if (scope != null) {
                    try {
                        scope.addUser(controller.getUser(Getter.user(rs)));
                    } catch (UserNotFoundException ex) {
                        return null;
                    }
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        // {{ custom queries not generated:
        public final static String create = "CREATE TABLE " + table + " (\n" +
                "\t" + Field.scope + " INTEGER NOT NULL,\n" +
                "\t" + Field.user + " INTEGER NOT NULL\n" +
                ");\nCREATE UNIQUE INDEX idx_scope_users \n" +
                "ON " + table + " (" + Field.scope + "," + Field.user + ");CREATE UNIQUE INDEX idx_scope_users_scope \n" +
                "ON " + table + " (" + Field.scope + ");";
        // }}
    }

    /**
     * this class is automatically generated from the actual SQL database scheme of the table `scope_users` and will be
     * manually adapted by new queries and the parse method.
     */
    public static class SQL_Scope_Admins {
        // {{ begin autogenerated code from SQL
        public static class Field {
            public static final String user = "`user`";
            public static final String scope = "`scope`";
        }

        public static class Getter {
            public static int user(ResultSet rs) throws SQLException {
                return rs.getInt(Index.user);
            }

            public static int scope(ResultSet rs) throws SQLException {
                return rs.getInt(Index.scope);
            }
        }

        public static class Index {
            public static final int user = 1;
            public static final int scope = 2;
        }

        public final static String table = "`scope_admins`";
        public final static String fields = Field.user + "," + Field.scope;
        public final static String selectAll = "select " + fields + " from " + table;
        public final static String selectByscope = "select " + fields + " from " + table + " where " + Field.scope + "=?";
        public final static String selectByuserAndscope = "select " + fields + " from " + table + " where " + Field.user + "=? AND " + Field.scope + "=?";
        public final static String deleteByscope = "delete from " + table + "  where " + Field.scope + "=?";
        public final static String deleteByuserAndscope = "delete from " + table + "  where " + Field.user + "=? AND " + Field.scope + "=?";
        public final static String updateuserByscope = "update " + table + " set " + Field.user + "=? where " + Field.scope + "=?";
        public final static String updatescopeByscope = "update " + table + " set " + Field.scope + "=? where " + Field.scope + "=?";
        public final static String updateuserByuserAndscope = "update " + table + " set " + Field.user + "=? where " + Field.user + "=? AND " + Field.scope + "=?";
        public final static String updatescopeByuserAndscope = "update " + table + " set " + Field.scope + "=? where " + Field.user + "=? AND " + Field.scope + "=?";
        public final static String add = "insert into " + table + " (" + Field.user + "," + Field.scope + ") values (?,?)";
        public final static String addOrUpdate = "insert into " + table + " (" + Field.user + "," + Field.scope + ") values (?,?) ON DUPLICATE KEY UPDATE " + Field.user + "=VALUES(" + Field.user + "), " + Field.scope + "=VALUES(" + Field.scope + ") ";
        public final static String update = " UPDATE " + table + " set " + Field.user + "=?, " + Field.scope + "=? WHERE " + Field.user + "=?";
        // }} end autogenerated code

        public final static Object parse(IController controller, ResultSet rs, boolean getData) {
            try {
                Scope scope = controller.getScope(SQL_Scope_Users.Getter.scope(rs), CacheMode.CACHE_AND_PERSISTENCE);

                if (scope != null) {
                    try {
                        scope.addAdmin(controller.getUser(SQL_Scope_Users.Getter.user(rs)));
                    } catch (UserNotFoundException ex) {
                        return null;
                    }
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        // {{ custom queries not generated:
        public final static String create = "CREATE TABLE " + table + " (\n" +
                "\t" + Field.scope + " INTEGER NOT NULL,\n" +
                "\t" + Field.user + " INTEGER NOT NULL\n" +
                ");\nCREATE UNIQUE INDEX idx_scope_admins \n" +
                "ON " + table + " (" + Field.scope + "," + Field.user + ");" +
                "CREATE UNIQUE INDEX idx_scope_admins_scope \n" +
                "ON " + table + " (" + Field.scope + ");";
        // }}
    }

    /**
     * this class is automatically generated from the actual SQL database scheme of the table `scope_Groups` and will be
     * manually adapted by new queries and the parse method.
     */
    public static class SQL_Scope_Group_User {
        // {{ begin autogenerated code from SQL
        public static class Field {
            public static final String Group = "`Group`";
            public static final String scope = "`scope`";
        }

        public static class Getter {
            public static int Group(ResultSet rs) throws SQLException {
                return rs.getInt(Index.Group);
            }

            public static int scope(ResultSet rs) throws SQLException {
                return rs.getInt(Index.scope);
            }
        }

        public static class Index {
            public static final int Group = 1;
            public static final int scope = 2;
        }

        public final static String table = "`scope_group_user`";
        public final static String fields = Field.Group + "," + Field.scope;
        public final static String selectAll = "select " + fields + " from " + table;
        public final static String selectByscope = "select " + fields + " from " + table + " where " + Field.scope + "=?";
        public final static String selectByGroupAndscope = "select " + fields + " from " + table + " where " + Field.Group + "=? AND " + Field.scope + "=?";
        public final static String deleteByscope = "delete from " + table + "  where " + Field.scope + "=?";
        public final static String deleteByGroupAndscope = "delete from " + table + "  where " + Field.Group + "=? AND " + Field.scope + "=?";
        public final static String updateGroupByscope = "update " + table + " set " + Field.Group + "=? where " + Field.scope + "=?";
        public final static String updatescopeByscope = "update " + table + " set " + Field.scope + "=? where " + Field.scope + "=?";
        public final static String updateGroupByGroupAndscope = "update " + table + " set " + Field.Group + "=? where " + Field.Group + "=? AND " + Field.scope + "=?";
        public final static String updatescopeByGroupAndscope = "update " + table + " set " + Field.scope + "=? where " + Field.Group + "=? AND " + Field.scope + "=?";
        public final static String add = "insert into " + table + " (" + Field.Group + "," + Field.scope + ") values (?,?)";
        public final static String addOrUpdate = "insert into " + table + " (" + Field.Group + "," + Field.scope + ") values (?,?) ON DUPLICATE KEY UPDATE " + Field.Group + "=VALUES(" + Field.Group + "), " + Field.scope + "=VALUES(" + Field.scope + ") ";
        public final static String update = " UPDATE " + table + " set " + Field.Group + "=?, " + Field.scope + "=? WHERE " + Field.Group + "=?";
        // }} end autogenerated code

        public final static Object parse(IController controller, ResultSet rs, boolean getData) {
            try {

                Scope scope = controller.getScope(Getter.scope(rs), CacheMode.CACHE_AND_PERSISTENCE);
                if (scope != null) {
                    scope.addUserGroup(controller.getGroup(Getter.Group(rs), CacheMode.CACHE_AND_PERSISTENCE));
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        // {{ custom queries not generated:
        public final static String create = "CREATE TABLE " + table + " (\n" +
                "\t" + Field.scope + " INTEGER NOT NULL,\n" +
                "\t" + Field.Group + " INTEGER NOT NULL\n" +
                ");\nCREATE UNIQUE INDEX idx_scope_Groups \n" +
                "ON " + table + " (" + Field.scope + "," + Field.Group + ");CREATE UNIQUE INDEX idx_scope_Groups_scope \n" +
                "ON " + table + " (" + Field.scope + ");";
        // }}
    }

    /**
     * this class is automatically generated from the actual SQL database scheme of the table `scope_Groups` and will be
     * manually adapted by new queries and the parse method.
     */
    public static class SQL_Scope_Group_Admins {
        // {{ begin autogenerated code from SQL
        public static class Field {
            public static final String Group = "`Group`";
            public static final String scope = "`scope`";
        }

        public static class Getter {
            public static int Group(ResultSet rs) throws SQLException {
                return rs.getInt(Index.Group);
            }

            public static int scope(ResultSet rs) throws SQLException {
                return rs.getInt(Index.scope);
            }
        }

        public static class Index {
            public static final int Group = 1;
            public static final int scope = 2;
        }

        public final static String table = "`scope_group_admin`";
        public final static String fields = Field.Group + "," + Field.scope;
        public final static String selectAll = "select " + fields + " from " + table;
        public final static String selectByscope = "select " + fields + " from " + table + " where " + Field.scope + "=?";
        public final static String selectByGroupAndscope = "select " + fields + " from " + table + " where " + Field.Group + "=? AND " + Field.scope + "=?";
        public final static String deleteByscope = "delete from " + table + "  where " + Field.scope + "=?";
        public final static String deleteByGroupAndscope = "delete from " + table + "  where " + Field.Group + "=? AND " + Field.scope + "=?";
        public final static String updateGroupByscope = "update " + table + " set " + Field.Group + "=? where " + Field.scope + "=?";
        public final static String updatescopeByscope = "update " + table + " set " + Field.scope + "=? where " + Field.scope + "=?";
        public final static String updateGroupByGroupAndscope = "update " + table + " set " + Field.Group + "=? where " + Field.Group + "=? AND " + Field.scope + "=?";
        public final static String updatescopeByGroupAndscope = "update " + table + " set " + Field.scope + "=? where " + Field.Group + "=? AND " + Field.scope + "=?";
        public final static String add = "insert into " + table + " (" + Field.Group + "," + Field.scope + ") values (?,?)";
        public final static String addOrUpdate = "insert into " + table + " (" + Field.Group + "," + Field.scope + ") values (?,?) ON DUPLICATE KEY UPDATE " + Field.Group + "=VALUES(" + Field.Group + "), " + Field.scope + "=VALUES(" + Field.scope + ") ";
        public final static String update = " UPDATE " + table + " set " + Field.Group + "=?, " + Field.scope + "=? WHERE " + Field.Group + "=?";
        // }} end autogenerated code

        public final static Object parse(IController controller, ResultSet rs, boolean getData) {
            try {

                Scope scope = controller.getScope(Getter.scope(rs), CacheMode.CACHE_AND_PERSISTENCE);
                if (scope != null) {
                    scope.addAdminGroup(controller.getGroup(Getter.Group(rs), CacheMode.CACHE_AND_PERSISTENCE));
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        // {{ custom queries not generated:
        public final static String create = "CREATE TABLE " + table + " (\n" +
                "\t" + Field.scope + " INTEGER NOT NULL,\n" +
                "\t" + Field.Group + " INTEGER NOT NULL\n" +
                ");\nCREATE UNIQUE INDEX idx_scope_Groups \n" +
                "ON " + table + " (" + Field.scope + "," + Field.Group + ");CREATE UNIQUE INDEX idx_scope_Groups_scope \n" +
                "ON " + table + " (" + Field.scope + ");";
        // }}
    }

    /**
     * this class is automatically generated from the actual SQL database scheme of the table `scopes` and will be
     * manually adapted by new queries and the parse method.
     */
    public static class SQL_Scopes {
        // {{ begin autogenerated code from SQL
        public static class Field {
            public static final String id = "`id`";
            public static final String name = "`name`";
        }

        public static class Getter {
            public static Integer ID(ResultSet rs) throws SQLException {
                int v = rs.getInt(Index.ID);
                if (rs.wasNull()) {
                    return null;
                }
                return v;
            }

            public static String name(ResultSet rs) throws SQLException {
                return rs.getString(Index.name);
            }
        }

        public static class Index {
            public static final int ID = 1;
            public static final int name = 2;
        }

        public final static String table = "`scopes`";
        public final static String fields = Field.id + "," + Field.name;
        public final static String selectAll = "select " + fields + " from " + table;
        public final static String selectByname = "select " + fields + " from " + table + " where " + Field.name + "=?";
        public final static String deleteByname = "delete from " + table + "  where " + Field.name + "=?";
        public final static String deleteById = "delete from " + table + " where " + Field.id + "=?";

        public final static String updatenameByname = "update " + table + " set " + Field.name + "=? where " + Field.name + "=?";

        public final static String add = "insert into " + table + " (" + Field.name + ") values (?)";
        public final static String addOrUpdate = "insert into " + table + " (" + Field.name + ") values (?) ON DUPLICATE KEY UPDATE " + Field.id + "=VALUES(" + Field.id + ") ";
        public final static String update = " UPDATE " + table + " set " + Field.id + "=? WHERE " + Field.name + "=?";
        // }} end autogenerated code
        public final static String selectByID = "select " + fields + " from " + table + " where " + Field.id + "=?";

        public final static Scope parse(IController controller, ResultSet rs, boolean getData) {
            try {
                Scope scope = controller.getScope(Getter.ID(rs), CacheMode.CACHE_ONLY);
                if (scope == null) {
                    scope = new Scope(Getter.ID(rs), Getter.name(rs));
                    controller.cacheScope(scope);
                    controller.getPersistence().fillScope(scope);
                }


                return scope;
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        // {{ custom queries not generated:
        public final static String create = "CREATE TABLE " + table + " (\n" +
                "\t" + Field.id + " INTEGER PRIMARY KEY AUTOINCREMENT,\n" +
                "\t" + Field.name + " VARCHAR(64) NOT NULL\n" +
                ");\nCREATE UNIQUE INDEX idx_scopes_name \n" +
                "ON " + table + " (" + Field.name + ");";
        // }}
    }

    /**
     * this class is automatically generated from the actual SQL database scheme of the table `groups` and will be
     * manually adapted by new queries and the parse method.
     */
    public static class SQL_Groups {
        // {{ begin autogenerated code from SQL
        public static class Field {
            public static final String id = "`id`";
            public static final String name = "`name`";
        }

        public static class Getter {
            public static Integer ID(ResultSet rs) throws SQLException {
                int v = rs.getInt(Index.ID);
                if (rs.wasNull()) {
                    return null;
                }
                return v;
            }

            public static String name(ResultSet rs) throws SQLException {
                return rs.getString(Index.name);
            }
        }

        public static class Index {
            public static final int ID = 1;
            public static final int name = 2;
        }

        public final static String table = "`groups`";
        public final static String fields = Field.id + "," + Field.name;
        public final static String selectAll = "select " + fields + " from " + table;
        public final static String selectByname = "select " + fields + " from " + table + " where " + Field.name + "=?";
        public final static String deleteByname = "delete from " + table + "  where " + Field.name + "=?";

        public final static String updatenameByname = "update " + table + " set " + Field.name + "=? where " + Field.name + "=?";

        public final static String add = "insert into " + table + " (" + Field.name + ") values (?)";
        public final static String addOrUpdate = "insert into " + table + " (" + Field.name + ") values (?) ON DUPLICATE KEY UPDATE " + Field.id + "=VALUES(" + Field.id + ") ";
        public final static String update = " UPDATE " + table + " set " + Field.id + "=? WHERE " + Field.name + "=?";
        // }} end autogenerated code
        public final static String selectByID = "select " + fields + " from " + table + " where " + Field.id + "=?";

        public final static Group parse(IController controller, ResultSet rs, boolean getData) {
            try {
                Integer id = Getter.ID(rs);
                logger.info("found group {} in db",id);
                try {
                    return controller.getGroup(id, CacheMode.CACHE_ONLY);
                } catch (GroupNotFoundException ex) {
                    Group group = new Group(id, Getter.name(rs));
                    controller.cacheGroup(group);
                    controller.getPersistence().fillGroup(group);
                    return group;
                }
            } catch (Exception e) {
                logger.error("error while parsing group data ", e);
            }
            return null;
        }

        // {{ custom queries not generated:
        public final static String create = "CREATE TABLE " + table + " (\n" +
                "\t" + Field.id + " INTEGER PRIMARY KEY AUTOINCREMENT,\n" +
                "\t" + Field.name + " VARCHAR(64) NOT NULL\n" +
                ");\nCREATE UNIQUE INDEX idx_groups_name \n" +
                "ON " + table + " (" + Field.name + ");";
        // }}

    }

    /**
     * this class is automatically generated from the actual SQL database scheme of the table `group_users` and will be
     * manually adapted by new queries and the parse method.
     */
    public static class SQL_Group_Users {
        // {{ begin autogenerated code from SQL
        public static class Field {
            public static final String user = "`user`";
            public static final String group = "`group`";
        }

        public static class Getter {
            public static int user(ResultSet rs) throws SQLException {
                return rs.getInt(Index.user);
            }

            public static int group(ResultSet rs) throws SQLException {
                return rs.getInt(Index.group);
            }
        }

        public static class Index {
            public static final int user = 1;
            public static final int group = 2;
        }

        public final static String table = "`group_users`";
        public final static String fields = Field.user + "," + Field.group;
        public final static String selectAll = "select " + fields + " from " + table;
        public final static String selectBygroup = "select " + fields + " from " + table + " where " + Field.group + "=?";
        public final static String selectByuserAndgroup = "select " + fields + " from " + table + " where " + Field.user + "=? AND " + Field.group + "=?";
        public final static String deleteBygroup = "delete from " + table + "  where " + Field.group + "=?";
        public final static String deleteByuserAndgroup = "delete from " + table + "  where " + Field.user + "=? AND " + Field.group + "=?";
        public final static String updateuserBygroup = "update " + table + " set " + Field.user + "=? where " + Field.group + "=?";
        public final static String updategroupBygroup = "update " + table + " set " + Field.group + "=? where " + Field.group + "=?";
        public final static String updateuserByuserAndgroup = "update " + table + " set " + Field.user + "=? where " + Field.user + "=? AND " + Field.group + "=?";
        public final static String updategroupByuserAndgroup = "update " + table + " set " + Field.group + "=? where " + Field.user + "=? AND " + Field.group + "=?";
        public final static String add = "insert into " + table + " (" + Field.user + "," + Field.group + ") values (?,?)";
        public final static String addOrUpdate = "insert into " + table + " (" + Field.user + "," + Field.group + ") values (?,?) ON DUPLICATE KEY UPDATE " + Field.user + "=VALUES(" + Field.user + "), " + Field.group + "=VALUES(" + Field.group + ") ";
        public final static String update = " UPDATE " + table + " set " + Field.user + "=?, " + Field.group + "=? WHERE " + Field.user + "=?";
        // }} end autogenerated code

        public final static Object parse(IController controller, ResultSet rs, boolean getData) {
            try {

                Group group = controller.getGroup(Getter.group(rs), CacheMode.CACHE_AND_PERSISTENCE);
                if (group != null) {
                    try {
                        group.addUser(controller.getUser(Getter.user(rs)));
                    } catch (UserNotFoundException ex) {
                        return null;
                    }
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        // {{ custom queries not generated:
        public final static String create = "CREATE TABLE " + table + " (\n" +
                "\t" + Field.group + " INTEGER NOT NULL,\n" +
                "\t" + Field.user + " INTEGER NOT NULL\n" +
                ");\nCREATE UNIQUE INDEX idx_group_users \n" +
                "ON " + table + " (" + Field.group + "," + Field.user + ");";

        // }}
    }

    /**
     * this class is automatically generated from the actual SQL database scheme of the table `group_users` and will be
     * manually adapted by new queries and the parse method.
     */
    public static class SQL_Group_Admins {
        // {{ begin autogenerated code from SQL
        public static class Field {
            public static final String user = "`user`";
            public static final String group = "`group`";
        }

        public static class Getter {
            public static int user(ResultSet rs) throws SQLException {
                return rs.getInt(Index.user);
            }

            public static int group(ResultSet rs) throws SQLException {
                return rs.getInt(Index.group);
            }
        }

        public static class Index {
            public static final int user = 1;
            public static final int group = 2;
        }

        public final static String table = "`group_admins`";
        public final static String fields = Field.user + "," + Field.group;
        public final static String selectAll = "select " + fields + " from " + table;
        public final static String selectBygroup = "select " + fields + " from " + table + " where " + Field.group + "=?";
        public final static String selectByuserAndgroup = "select " + fields + " from " + table + " where " + Field.user + "=? AND " + Field.group + "=?";
        public final static String deleteBygroup = "delete from " + table + "  where " + Field.group + "=?";
        public final static String deleteByuserAndgroup = "delete from " + table + "  where " + Field.user + "=? AND " + Field.group + "=?";
        public final static String updateuserBygroup = "update " + table + " set " + Field.user + "=? where " + Field.group + "=?";
        public final static String updategroupBygroup = "update " + table + " set " + Field.group + "=? where " + Field.group + "=?";
        public final static String updateuserByuserAndgroup = "update " + table + " set " + Field.user + "=? where " + Field.user + "=? AND " + Field.group + "=?";
        public final static String updategroupByuserAndgroup = "update " + table + " set " + Field.group + "=? where " + Field.user + "=? AND " + Field.group + "=?";
        public final static String add = "insert into " + table + " (" + Field.user + "," + Field.group + ") values (?,?)";
        public final static String addOrUpdate = "insert into " + table + " (" + Field.user + "," + Field.group + ") values (?,?) ON DUPLICATE KEY UPDATE " + Field.user + "=VALUES(" + Field.user + "), " + Field.group + "=VALUES(" + Field.group + ") ";
        public final static String update = " UPDATE " + table + " set " + Field.user + "=?, " + Field.group + "=? WHERE " + Field.user + "=?";
        // }} end autogenerated code

        public final static Object parse(IController controller, ResultSet rs, boolean getData) {
            try {
                Group group = controller.getGroup(SQL_Group_Users.Getter.group(rs), CacheMode.CACHE_AND_PERSISTENCE);

                if (group != null) {
                    try {
                        group.addAdmin(controller.getUser(SQL_Group_Users.Getter.user(rs)));
                    } catch (UserNotFoundException ex) {
                        return null;
                    }
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        // {{ custom queries not generated:
        public final static String create = "CREATE TABLE " + table + " (\n" +
                "\t" + Field.group + " INTEGER NOT NULL,\n" +
                "\t" + Field.user + " INTEGER NOT NULL\n" +
                ");\nCREATE UNIQUE INDEX idx_group_admins \n" +
                "ON " + table + " (" + Field.group + "," + Field.user + ");";
        // }}
    }

    /**
     * this class is automatically generated from the actual SQL database scheme of the table `scope_devices` and will
     * be manually adapted by new queries and the parse method.
     */
    public static class SQL_Scope_Devices {
        // {{ begin autogenerated code from SQL
        public static class Field {
            public static final String uuid = "`uuid`";
            public static final String read = "`read`";
            public static final String write = "`write`";
            public static final String del = "`del`";
        }

        public static class Getter {
            public static String uuid(ResultSet rs) throws SQLException {
                return rs.getString(Index.uuid);
            }

            public static int read(ResultSet rs) throws SQLException {
                return rs.getInt(Index.read);
            }

            public static int write(ResultSet rs) throws SQLException {
                return rs.getInt(Index.write);
            }

            public static int del(ResultSet rs) throws SQLException {
                return rs.getInt(Index.del);
            }
        }

        public static class Index {
            public static final int uuid = 1;
            public static final int read = 2;
            public static final int write = 3;
            public static final int del = 4;
        }

        public final static String table = "`scope_devices`";
        public final static String fields = Field.uuid + "," + Field.read + "," + Field.write + "," + Field.del;
        public final static String selectAll = "select " + fields + " from " + table;
        public final static String selectByuuid = "select " + fields + " from " + table + " where " + Field.uuid + "=?";
        public final static String deleteByuuid = "delete from " + table + "  where " + Field.uuid + "=?";
        public final static String updateuuidByuuid = "update " + table + " set " + Field.uuid + "=? where " + Field.uuid + "=?";
        public final static String updatereadByuuid = "update " + table + " set " + Field.read + "=? where " + Field.uuid + "=?";
        public final static String updatewriteByuuid = "update " + table + " set " + Field.write + "=? where " + Field.uuid + "=?";
        public final static String updatedelByuuid = "update " + table + " set " + Field.del + "=? where " + Field.uuid + "=?";
        public final static String add = "insert into " + table + " (" + Field.uuid + "," + Field.read + "," + Field.write + "," + Field.del + ") values (?,?,?,?)";
        // }} end autogenerated code

        public final static Object parse(IController controller, ResultSet rs, boolean getData) {
            try {
                Device device = controller.getDevice(Getter.uuid(rs));
                device.setReadScope(controller.getScope(Getter.read(rs), CacheMode.CACHE_AND_PERSISTENCE));
                device.setWriteScope(controller.getScope(Getter.write(rs), CacheMode.CACHE_AND_PERSISTENCE));
                device.setDelScope(controller.getScope(Getter.del(rs), CacheMode.CACHE_AND_PERSISTENCE));

            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        // {{ custom queries not generated:
        public final static String create = "CREATE TABLE " + table + " (\n" +
                "\t" + Field.uuid + " VARCHAR(128) NOT NULL,\n" +
                "\t" + Field.read + " INTEGER NOT NULL,\n" +
                "\t" + Field.write + " INTEGER NOT NULL,\n" +
                "\t" + Field.del + " INTEGER NOT NULL\n" +
                ")\n;CREATE INDEX idx_scope_device_uuid \n" +
                "ON " + table + " (" + Field.uuid + ");" +
                ";";
        // }}
    }
}
