/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)"FileUtils");

    public static boolean deleteDirectory(@Nonnull File directory) throws IllegalArgumentException {
        File[] allContents = directory.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                FileUtils.deleteDirectory(file);
            }
        }
        int tries = 0;
        while (directory.exists()) {
            if (tries > 5) {
                return false;
            }
            ++tries;
            if (directory.delete()) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Nonnull
    private static Charset getCharset(@Nonnull String charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Parameter '%1$s' was null", "charset"));
        }
        return Charset.forName(charset);
    }

    @Nonnull
    private static File getFile(@Nonnull String filename) {
        if (filename == null) {
            throw new IllegalArgumentException(String.format("Parameter '%1$s' was null", "filename"));
        }
        return new File(filename);
    }

    public static boolean makeDirsForFile(@Nonnull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Parameter '%1$s' was null", "file"));
        }
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            return file.getParentFile().mkdirs();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static byte[] readBinary(@Nonnull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Parameter '%1$s' was null", "file"));
        }
        if (!file.exists()) {
            throw new FileNotFoundException(String.format("could not find file %s", file.getPath()));
        }
        byte[] result = new byte[(int)file.length()];
        try (BufferedInputStream input = null;){
            int totalBytesRead = 0;
            input = new BufferedInputStream(new FileInputStream(file));
            while (totalBytesRead < result.length) {
                int bytesRemaining = result.length - totalBytesRead;
                int bytesRead = input.read(result, totalBytesRead, bytesRemaining);
                if (bytesRead <= 0) continue;
                totalBytesRead += bytesRead;
            }
        }
        return result;
    }

    public static byte[] readBinary(@Nonnull String filename) throws IOException {
        return FileUtils.readBinary(FileUtils.getFile(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(@Nonnull File file, @Nonnull Charset charset) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Parameter '%1$s' was null", "file"));
        }
        if (!file.exists()) {
            throw new FileNotFoundException(String.format("could not find file %s", file.getPath()));
        }
        StringBuilder contents = new StringBuilder();
        BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
        try {
            String line = null;
            line = input.readLine();
            while (line != null) {
                contents.append(line);
                line = input.readLine();
                if (line == null) continue;
                contents.append(System.getProperty("line.separator"));
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return contents.toString();
    }

    public static String readFile(@Nonnull String filename) throws IOException {
        return FileUtils.readFile(FileUtils.getFile(filename));
    }

    public static String readFile(@Nonnull File file) throws IOException {
        return FileUtils.readFile(file, StandardCharsets.UTF_8);
    }

    public static String readFile(@Nonnull String filename, @Nonnull String charset) throws IOException {
        return FileUtils.readFile(FileUtils.getFile(filename), FileUtils.getCharset(charset));
    }

    public static String readFile(@Nonnull String filename, @Nonnull Charset charset) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException(String.format("Parameter '%1$s' was null", "filename"));
        }
        return FileUtils.readFile(FileUtils.getFile(filename), charset);
    }

    public static String replaceEnding(File file, String s) throws IOException {
        return FileUtils.replaceEnding(file.getCanonicalPath(), s);
    }

    public static String replaceEnding(String path, String s) {
        int index = path.lastIndexOf(46);
        if (index > -1) {
            return String.format("%s.%s", path.substring(0, index), s);
        }
        return path;
    }

    public static void writeToFile(@Nonnull File file, @Nonnull byte[] bytes) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Parameter '%1$s' was null", "file"));
        }
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Parameter '%1$s' was null", "bytes"));
        }
        Files.write(file.toPath(), bytes, new OpenOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(@Nonnull File file, @Nonnull String text, @Nonnull Charset charset) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Parameter '%1$s' was null", "file"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Parameter '%1$s' was null", "text"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Parameter '%1$s' was null", "charset"));
        }
        FileUtils.makeDirsForFile(file);
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
            out.append(text);
            out.flush();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                logger.error("IOException!", (Throwable)e);
            }
        }
    }

    public static void writeToFile(@Nonnull File filename, @Nonnull String content, @Nonnull String charset) throws IOException {
        FileUtils.writeToFile(filename, content, FileUtils.getCharset(charset));
    }

    public static void writeToFile(@Nonnull File filename, @Nonnull String text) throws IOException {
        FileUtils.writeToFile(filename, text, StandardCharsets.UTF_8);
    }

    public static void writeToFile(@Nonnull String filename, @Nonnull byte[] bytes) throws IOException {
        FileUtils.writeToFile(FileUtils.getFile(filename), bytes);
    }

    public static void writeToFile(@Nonnull String filename, @Nonnull String text) throws IOException {
        FileUtils.writeToFile(FileUtils.getFile(filename), text);
    }

    public static void writeToFile(@Nonnull String filename, @Nonnull String text, @Nonnull Charset charset) throws IOException {
        FileUtils.writeToFile(FileUtils.getFile(filename), text, charset);
    }

    public static void writeToFile(@Nonnull String filename, @Nonnull String text, @Nonnull String charset) throws IOException {
        FileUtils.writeToFile(FileUtils.getFile(filename), text, charset);
    }
}

