/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.utils;

import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StringFunctions {
    private static final SecureRandom random = new SecureRandom();

    public static String format(String format, Map<String, Object> values) {
        StringBuilder formatter = new StringBuilder(format);
        ArrayList<Object> valueList = new ArrayList<Object>();
        Matcher matcher = Pattern.compile("\\{(\\w+)}").matcher(format);
        while (matcher.find()) {
            String key = matcher.group(1);
            String formatKey = String.format("{%s}", key);
            int index = formatter.indexOf(formatKey);
            if (index == -1) continue;
            formatter.replace(index, index + formatKey.length(), "%s");
            Object v = values.get(key);
            if (v != null) {
                valueList.add(v);
                continue;
            }
            throw new IllegalArgumentException("value with the key " + key + " is not filled!");
        }
        return String.format(formatter.toString(), valueList.toArray());
    }

    public static String format(String format, Object[][] values) {
        HashMap<String, Object> vals = new HashMap<String, Object>();
        for (int i = 0; i < values.length; ++i) {
            Object v = values[i][0];
            if (v instanceof String) {
                vals.put((String)values[i][0], values[i][1]);
                continue;
            }
            vals.put(String.valueOf(values[i][0]), values[i][1]);
        }
        return StringFunctions.format(format, vals);
    }

    @Nullable
    public static String decompose(@CheckForNull String s) {
        if (s == null) {
            return null;
        }
        return Normalizer.normalize(s, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    @Nullable
    public static String filterFilename(@CheckForNull String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("[^A-Za-z0-9 \\.\\-_]", "");
    }

    @Nonnull
    public static String filterName(@Nonnull String input) {
        return StringFunctions.trimDoubleSpaces(input.replaceAll("[^a-zA-Z0-9 ]", ""));
    }

    @Nonnull
    public static String generateRandomKey() {
        return StringFunctions.generateRandomKey(26);
    }

    @Nonnull
    public static String generateRandomKey(int len) {
        String s = "";
        while (s.length() != len) {
            s = new BigInteger(len * 5, random).toString(32);
        }
        return s;
    }

    @Nonnull
    public static HashSet<String> getListOfString(@Nonnull LinkedList<HashSet<String>> wordList) {
        if (wordList.size() > 0) {
            HashSet<Object> words = wordList.get(0);
            for (int i = 1; i < wordList.size(); ++i) {
                HashSet<String> w = wordList.get(i);
                HashSet<CallSite> twords = new HashSet<CallSite>();
                for (String s : words) {
                    for (String wo : w) {
                        twords.add((CallSite)((Object)(s + " " + wo)));
                    }
                }
                words = twords;
            }
            return words;
        }
        return new HashSet<String>();
    }

    @Nonnull
    public static String replaceEverythingButNumbers(@Nonnull String text) {
        return text.replaceAll("[^\\d.\\.]", "");
    }

    @Nullable
    public static String toCamelCase(@CheckForNull String input) {
        if (input == null) {
            return null;
        }
        if (input.equalsIgnoreCase("ID")) {
            return "ID";
        }
        input = StringFunctions.trim(input);
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        for (String tok : input.split(" ")) {
            if (tok.isEmpty()) continue;
            if (!first) {
                ret.append(tok.substring(0, 1).toUpperCase(Locale.ENGLISH));
                ret.append(tok.substring(1).toLowerCase(Locale.ENGLISH));
                continue;
            }
            first = false;
            ret.append(tok.toLowerCase(Locale.ENGLISH));
        }
        return ret.toString();
    }

    @Nullable
    public static String trim(@CheckForNull String input) {
        return StringFunctions.trim(input, new char[]{',', ' ', '\u00a0', ' '});
    }

    @Nullable
    public static String trim(@CheckForNull String input, char[] chrs) {
        if (input == null) {
            return null;
        }
        boolean changed = false;
        if (input.length() > 0) {
            for (char c : chrs) {
                if (input.charAt(0) == c) {
                    input = input.substring(1);
                    changed = true;
                    break;
                }
                int end = input.length() - 1;
                if (input.charAt(end) != c) continue;
                input = input.substring(0, end);
                changed = true;
                break;
            }
            if (changed) {
                return StringFunctions.trim(input, chrs);
            }
        }
        return StringFunctions.trimDoubleSpaces(input);
    }

    @Nonnull
    public static String trimDoubleSpaces(@Nonnull String input) {
        String n = input.replace("  ", " ");
        while (!n.equals(input)) {
            input = n;
            n = input.replace("  ", " ");
        }
        return n;
    }
}

