/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.utils;

import java.util.HashSet;
import javax.annotation.CheckForNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONFunctions {
    public static boolean hasEntries(JSONArray jsonArray, String[] keys) {
        HashSet<String> set = new HashSet<String>();
        try {
            for (int i = 0; i < jsonArray.length(); ++i) {
                set.add(jsonArray.getString(i));
            }
        }
        catch (Exception ex) {
            return false;
        }
        for (String k : keys) {
            if (set.contains(k)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasEntries(JSONObject json, String[] keys) {
        for (String k : keys) {
            if (json.has(k)) continue;
            return false;
        }
        return true;
    }

    public static Object get(@CheckForNull JSONObject json, @CheckForNull String path) {
        if (path == null || json == null) {
            return false;
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        int idx = path.indexOf("/");
        if (idx == -1) {
            try {
                return json.get(path);
            }
            catch (JSONException jSONException) {
                return null;
            }
        }
        String p = path.substring(0, idx);
        if (json.has(p)) {
            return JSONFunctions.get(json.getJSONObject(p), path.substring(idx + 1));
        }
        return null;
    }

    public static boolean has(@CheckForNull JSONObject json, @CheckForNull String path) {
        if (path == null || json == null) {
            return false;
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        int idx = path.indexOf("/");
        if (idx == -1) {
            return json.has(path);
        }
        String p = path.substring(0, idx);
        if (json.has(p)) {
            return JSONFunctions.has(json.getJSONObject(p), path.substring(idx + 1));
        }
        return false;
    }
}

