/*
 * Decompiled with CFR 0.152.
 */
package de.kosmos_lab.utils;

import de.kosmos_lab.utils.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFMPEGWrapper {
    public static final String timePattern = "HH:mm:ss";
    private static final Logger logger = LoggerFactory.getLogger((String)"FFMPEGWrapper");

    public static void cutVideo(File finalName, File tmpName, long skip, long duration) {
        String starttime = "";
        String endtime = "";
        if (skip > 0L || duration > 0L) {
            SimpleDateFormat timeOnly = new SimpleDateFormat(timePattern);
            if (skip > 0L) {
                starttime = timeOnly.format(new Date(skip));
            }
            if (duration > 0L) {
                endtime = timeOnly.format(new Date(skip + duration));
            }
        }
        try {
            String line;
            String cmd = String.format("ffmpeg -ss %s -to %s -i %s -c copy %s", starttime, endtime, tmpName.getCanonicalPath(), finalName.getCanonicalPath());
            logger.info("executing: {}", (Object)cmd);
            Process pr = Runtime.getRuntime().exec(cmd);
            BufferedReader in = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
            while ((line = in.readLine()) != null) {
                logger.warn("stderr:{}", (Object)line);
            }
            in = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            while ((line = in.readLine()) != null) {
                logger.info("stdout:{}", (Object)line);
            }
            pr.waitFor();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void mergeVideos(Collection<String> files, File finalName, long skip, long duration) throws IOException {
        StringBuilder mergeFileContent = new StringBuilder();
        for (String f : files) {
            mergeFileContent.append(String.format("file '%s'\n", f));
        }
        String mergeFileName = FileUtils.replaceEnding(finalName.getCanonicalPath(), "txt");
        FileUtils.writeToFile(mergeFileName, mergeFileContent.toString());
        File tmpFile = finalName;
        if (skip > 0L || duration > 0L) {
            tmpFile = new File(finalName.getParentFile().getCanonicalPath() + "/tmp_" + finalName.getName());
        }
        try {
            String line;
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            String cmd = String.format("ffmpeg -f concat -safe 0 -i %s -c copy %s", mergeFileName, tmpFile.getCanonicalPath());
            logger.info("executing: {}", (Object)cmd);
            Process pr = Runtime.getRuntime().exec(cmd);
            BufferedReader in = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
            while ((line = in.readLine()) != null) {
                logger.warn("stderr:{}", (Object)line);
            }
            in = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            while ((line = in.readLine()) != null) {
                logger.info("stdout:{}", (Object)line);
            }
            pr.waitFor();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        if (skip > 0L || duration > 0L) {
            FFMPEGWrapper.cutVideo(finalName, tmpFile, skip, duration);
            try {
                tmpFile.delete();
            }
            catch (SecurityException ex) {
                logger.warn("could not delete temp file:{}", (Object)ex.getMessage());
            }
        }
        try {
            new File(mergeFileName).delete();
        }
        catch (SecurityException ex) {
            logger.warn("could not delete temp file:{}", (Object)ex.getMessage());
        }
    }
}

