/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.spotbugs.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import de.kontext_e.jqassistant.plugin.spotbugs.jaxb.BugCollectionType;
import de.kontext_e.jqassistant.plugin.spotbugs.jaxb.BugInstanceType;
import de.kontext_e.jqassistant.plugin.spotbugs.jaxb.FieldType;
import de.kontext_e.jqassistant.plugin.spotbugs.jaxb.FileType;
import de.kontext_e.jqassistant.plugin.spotbugs.jaxb.MethodType;
import de.kontext_e.jqassistant.plugin.spotbugs.jaxb.ObjectFactory;
import de.kontext_e.jqassistant.plugin.spotbugs.jaxb.SourceLineType;
import de.kontext_e.jqassistant.plugin.spotbugs.store.descriptor.FindBugsBugInstanceClassDescriptor;
import de.kontext_e.jqassistant.plugin.spotbugs.store.descriptor.FindBugsBugInstanceFieldDescriptor;
import de.kontext_e.jqassistant.plugin.spotbugs.store.descriptor.FindBugsBugInstanceMethodDescriptor;
import de.kontext_e.jqassistant.plugin.spotbugs.store.descriptor.FindBugsSourceLineDescriptor;
import de.kontext_e.jqassistant.plugin.spotbugs.store.descriptor.SpotBugsBugInstanceDescriptor;
import de.kontext_e.jqassistant.plugin.spotbugs.store.descriptor.SpotBugsReportDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class SpotBugsScannerPlugin
extends AbstractScannerPlugin<FileResource, SpotBugsReportDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpotBugsScannerPlugin.class);
    public static final String JQASSISTANT_PLUGIN_SPOTBUGS_FILENAME = "jqassistant.plugin.spotbugs.filename";
    public static final String JQASSISTANT_PLUGIN_SPOTBUGS_DIRNAME = "jqassistant.plugin.spotbugs.dirname";
    private JAXBContext jaxbContext;
    private static String findBugsFileName = "findbugs.xml";
    private static String findBugsDirName = "findbugs";
    private static String spotBugsFileName = "spotbugs.xml";
    private static String spotBugsDirName = "spotbugs";

    public SpotBugsScannerPlugin() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Cannot create JAXB context.", e);
        }
    }

    protected void configure() {
        super.configure();
        if (this.getProperties().containsKey(JQASSISTANT_PLUGIN_SPOTBUGS_FILENAME)) {
            findBugsFileName = (String)this.getProperties().get(JQASSISTANT_PLUGIN_SPOTBUGS_FILENAME);
        }
        if (this.getProperties().containsKey(JQASSISTANT_PLUGIN_SPOTBUGS_DIRNAME)) {
            findBugsDirName = (String)this.getProperties().get(JQASSISTANT_PLUGIN_SPOTBUGS_DIRNAME);
        }
        LOGGER.info(String.format("SpotBugs plugin looks for files named %s or for all XML files in directories named %s", spotBugsFileName, spotBugsDirName));
        LOGGER.info(String.format("SpotBugs plugin also still looks for files named %s or for all XML files in directories named %s", findBugsFileName, findBugsDirName));
    }

    public boolean accepts(FileResource item, String path, Scope scope) {
        try {
            boolean accepted = this.acceptsPath(path);
            if (accepted) {
                LOGGER.info(String.format("SpotBugs plugin accepted file %s", path));
            }
            return accepted;
        }
        catch (Exception e) {
            LOGGER.error("Error while checking path: " + e, (Throwable)e);
            return false;
        }
    }

    boolean acceptsPath(String path) {
        return path.endsWith(findBugsFileName) || path.endsWith(spotBugsFileName) || this.parentDirectoryHasAcceptableName(path, findBugsDirName) || this.parentDirectoryHasAcceptableName(path, spotBugsDirName);
    }

    private boolean parentDirectoryHasAcceptableName(String path, String dirName) {
        if (!path.endsWith(".xml")) {
            return false;
        }
        String[] parts = path.split("/");
        if (parts == null || parts.length < 2) {
            return false;
        }
        if (dirName == null) {
            return false;
        }
        String parentName = parts[parts.length - 2];
        return dirName.equalsIgnoreCase(parentName);
    }

    public SpotBugsReportDescriptor scan(FileResource file, String path, Scope scope, Scanner scanner) throws IOException {
        LOGGER.debug(String.format("SpotBugs scans file %s", path));
        BugCollectionType bugCollectionType = this.unmarshalSpotBugsXml(file.createStream());
        FileDescriptor fileDescriptor = (FileDescriptor)scanner.getContext().getCurrentDescriptor();
        SpotBugsReportDescriptor spotBugsReportDescriptor = (SpotBugsReportDescriptor)scanner.getContext().getStore().addDescriptorType((Descriptor)fileDescriptor, SpotBugsReportDescriptor.class);
        this.addBugInstancesToFindBugsDescriptor(scanner.getContext().getStore(), bugCollectionType, spotBugsReportDescriptor);
        return spotBugsReportDescriptor;
    }

    protected BugCollectionType unmarshalSpotBugsXml(InputStream streamSource) throws IOException {
        BugCollectionType bugCollectionType;
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            bugCollectionType = (BugCollectionType)unmarshaller.unmarshal((Source)new StreamSource(streamSource), BugCollectionType.class).getValue();
        }
        catch (JAXBException e) {
            throw new IOException("Cannot read model descriptor.", e);
        }
        return bugCollectionType;
    }

    protected void addBugInstancesToFindBugsDescriptor(Store store, BugCollectionType bugCollectionType, SpotBugsReportDescriptor spotBugsReportDescriptor) {
        for (BugInstanceType bugInstanceType : bugCollectionType.getBugInstance()) {
            SpotBugsBugInstanceDescriptor spotBugsBugInstanceDescriptor = (SpotBugsBugInstanceDescriptor)store.create(SpotBugsBugInstanceDescriptor.class);
            this.fillBugInstanceDescriptor(store, bugInstanceType, spotBugsBugInstanceDescriptor, null);
            spotBugsReportDescriptor.getContains().add(spotBugsBugInstanceDescriptor);
        }
        for (FileType fileType : bugCollectionType.getFile()) {
            for (BugInstanceType bugInstanceType : fileType.getBugInstance()) {
                SpotBugsBugInstanceDescriptor spotBugsBugInstanceDescriptor = (SpotBugsBugInstanceDescriptor)store.create(SpotBugsBugInstanceDescriptor.class);
                this.fillBugInstanceDescriptor(store, bugInstanceType, spotBugsBugInstanceDescriptor, fileType.getClassname());
                spotBugsReportDescriptor.getContains().add(spotBugsBugInstanceDescriptor);
            }
        }
    }

    private void fillBugInstanceDescriptor(Store store, BugInstanceType bugInstanceType, SpotBugsBugInstanceDescriptor spotBugsBugInstanceDescriptor, String classname) {
        spotBugsBugInstanceDescriptor.setType(bugInstanceType.getType());
        spotBugsBugInstanceDescriptor.setPriority(bugInstanceType.getPriority());
        spotBugsBugInstanceDescriptor.setAbbrev(bugInstanceType.getAbbrev());
        spotBugsBugInstanceDescriptor.setCategory(bugInstanceType.getCategory());
        spotBugsBugInstanceDescriptor.setMessage(bugInstanceType.getMessage());
        spotBugsBugInstanceDescriptor.setLineNumber(bugInstanceType.getLineNumber());
        spotBugsBugInstanceDescriptor.setClassName(classname);
        if (bugInstanceType.getClazz() != null) {
            Iterator<FieldType> findBugsBugInstanceClassDescriptor = (FindBugsBugInstanceClassDescriptor)store.create(FindBugsBugInstanceClassDescriptor.class);
            SourceLineType bugInstanceTypeSourceLine = bugInstanceType.getClazz().getSourceLine();
            FindBugsSourceLineDescriptor sourceLineDescriptor = this.createSourceLineDescriptor(store, bugInstanceTypeSourceLine);
            findBugsBugInstanceClassDescriptor.setSourceLineDescriptor(sourceLineDescriptor);
            spotBugsBugInstanceDescriptor.setBugInstanceClass((FindBugsBugInstanceClassDescriptor)((Object)findBugsBugInstanceClassDescriptor));
        }
        if (bugInstanceType.getMethod() != null) {
            for (MethodType methodType : bugInstanceType.getMethod()) {
                FindBugsBugInstanceMethodDescriptor findBugsBugInstanceMethodDescriptor = (FindBugsBugInstanceMethodDescriptor)store.create(FindBugsBugInstanceMethodDescriptor.class);
                findBugsBugInstanceMethodDescriptor.setFullQualifiedName(methodType.getClassname());
                findBugsBugInstanceMethodDescriptor.setName(methodType.getName());
                findBugsBugInstanceMethodDescriptor.setSignature(methodType.getSignature());
                findBugsBugInstanceMethodDescriptor.setIsStatic(Boolean.valueOf(methodType.getIsStatic()));
                findBugsBugInstanceMethodDescriptor.setSourceLineDescriptor(this.createSourceLineDescriptor(store, methodType.getSourceLine()));
                spotBugsBugInstanceDescriptor.getBugInstanceMethods().add(findBugsBugInstanceMethodDescriptor);
            }
        }
        if (bugInstanceType.getField() != null) {
            for (FieldType fieldType : bugInstanceType.getField()) {
                FindBugsBugInstanceFieldDescriptor findBugsBugInstanceFieldDescriptor = (FindBugsBugInstanceFieldDescriptor)store.create(FindBugsBugInstanceFieldDescriptor.class);
                findBugsBugInstanceFieldDescriptor.setFullQualifiedName(fieldType.getClassname());
                findBugsBugInstanceFieldDescriptor.setName(fieldType.getName());
                findBugsBugInstanceFieldDescriptor.setSignature(fieldType.getSignature());
                findBugsBugInstanceFieldDescriptor.setIsStatic(Boolean.valueOf(fieldType.getIsStatic()));
                findBugsBugInstanceFieldDescriptor.setSourceLineDescriptor(this.createSourceLineDescriptor(store, fieldType.getSourceLine()));
                spotBugsBugInstanceDescriptor.getBugInstanceFields().add(findBugsBugInstanceFieldDescriptor);
            }
        }
        if (bugInstanceType.getSourceLine() != null) {
            SourceLineType bugInstanceTypeSourceLine = bugInstanceType.getSourceLine();
            FindBugsSourceLineDescriptor sourceLineDescriptor = this.createSourceLineDescriptor(store, bugInstanceTypeSourceLine);
            spotBugsBugInstanceDescriptor.setSourceLineDescriptor(sourceLineDescriptor);
        }
    }

    private FindBugsSourceLineDescriptor createSourceLineDescriptor(Store store, SourceLineType bugInstanceTypeSourceLine) {
        FindBugsSourceLineDescriptor sourceLineDescriptor = (FindBugsSourceLineDescriptor)store.create(FindBugsSourceLineDescriptor.class);
        if (bugInstanceTypeSourceLine != null) {
            sourceLineDescriptor.setClassname(bugInstanceTypeSourceLine.getClassname());
            sourceLineDescriptor.setStart(bugInstanceTypeSourceLine.getStart());
            sourceLineDescriptor.setEnd(bugInstanceTypeSourceLine.getEnd());
            sourceLineDescriptor.setSourcefile(bugInstanceTypeSourceLine.getSourcefile());
            sourceLineDescriptor.setSourcepath(bugInstanceTypeSourceLine.getSourcepath());
        }
        return sourceLineDescriptor;
    }

    protected void writeFindBugsDescriptor(String path, BugCollectionType bugCollectionType, SpotBugsReportDescriptor spotBugsReportDescriptor) {
        spotBugsReportDescriptor.setName(path);
        spotBugsReportDescriptor.setFileName(path);
        spotBugsReportDescriptor.setVersion(bugCollectionType.getVersion());
        spotBugsReportDescriptor.setSequence(bugCollectionType.getSequence());
        spotBugsReportDescriptor.setAnalysisTimestamp(bugCollectionType.getAnalysisTimestamp());
    }
}

