/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.pmd.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import de.kontext_e.jqassistant.plugin.pmd.jaxb.FileType;
import de.kontext_e.jqassistant.plugin.pmd.jaxb.ObjectFactory;
import de.kontext_e.jqassistant.plugin.pmd.jaxb.PmdType;
import de.kontext_e.jqassistant.plugin.pmd.jaxb.ViolationType;
import de.kontext_e.jqassistant.plugin.pmd.store.PmdFileDescriptor;
import de.kontext_e.jqassistant.plugin.pmd.store.PmdReportDescriptor;
import de.kontext_e.jqassistant.plugin.pmd.store.PmdViolationDescriptor;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PmdReportScannerPlugin
extends AbstractScannerPlugin<FileResource, PmdReportDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PmdReportScannerPlugin.class);
    public static final String JQASSISTANT_PLUGIN_PMD_FILENAME = "jqassistant.plugin.pmd.filename";
    public static final String JQASSISTANT_PLUGIN_PMD_DIRNAME = "jqassistant.plugin.pmd.dirname";
    private JAXBContext jaxbContext;
    private String pmdFileName = "pmd.xml";
    private String pmdDirName = "pmd";

    public PmdReportScannerPlugin() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Cannot create JAXB context.", e);
        }
    }

    protected void configure() {
        super.configure();
        if (this.getProperties().containsKey(JQASSISTANT_PLUGIN_PMD_FILENAME)) {
            this.pmdFileName = (String)this.getProperties().get(JQASSISTANT_PLUGIN_PMD_FILENAME);
        }
        if (System.getProperty(JQASSISTANT_PLUGIN_PMD_FILENAME) != null) {
            this.pmdFileName = System.getProperty(JQASSISTANT_PLUGIN_PMD_FILENAME);
        }
        if (this.getProperties().containsKey(JQASSISTANT_PLUGIN_PMD_DIRNAME)) {
            this.pmdDirName = (String)this.getProperties().get(JQASSISTANT_PLUGIN_PMD_DIRNAME);
        }
        if (System.getProperty(JQASSISTANT_PLUGIN_PMD_DIRNAME) != null) {
            this.pmdDirName = System.getProperty(JQASSISTANT_PLUGIN_PMD_DIRNAME);
        }
        LOGGER.info(String.format("PMD plugin looks for files named %s or for all XML files in directories named '%s'", this.pmdFileName, this.pmdDirName));
    }

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        boolean accepted;
        boolean bl = accepted = path.endsWith(this.pmdFileName) || this.pmdDirName.equals(item.getFile().toPath().getParent().toFile().getName()) && path.endsWith(".xml");
        if (accepted) {
            LOGGER.debug("Pmd accepted path " + path);
        }
        return accepted;
    }

    public PmdReportDescriptor scan(FileResource file, String path, Scope scope, Scanner scanner) throws IOException {
        LOGGER.debug("Pmd scans path " + path);
        PmdType pmdType = this.unmarshalPmdXml(file.createStream());
        PmdReportDescriptor pmdReportDescriptor = (PmdReportDescriptor)scanner.getContext().getStore().create(PmdReportDescriptor.class);
        pmdReportDescriptor.setFileName(path);
        this.readFiles(scanner.getContext().getStore(), pmdType, pmdReportDescriptor);
        return pmdReportDescriptor;
    }

    private void readFiles(Store store, PmdType pmdType, PmdReportDescriptor pmdReportDescriptor) {
        for (FileType fileType : pmdType.getFile()) {
            PmdFileDescriptor pmdFileDescriptor = (PmdFileDescriptor)store.create(PmdFileDescriptor.class);
            pmdFileDescriptor.setName(this.truncateName(fileType.getName()));
            String classname = fileType.getViolation().get(0).getClazz();
            String packagename = fileType.getViolation().get(0).getPackage();
            String fqn = packagename + "." + classname;
            pmdFileDescriptor.setFullQualifiedName(fqn);
            pmdReportDescriptor.getFiles().add(pmdFileDescriptor);
            this.readViolations(store, fileType, pmdFileDescriptor);
        }
    }

    private void readViolations(Store store, FileType fileType, PmdFileDescriptor pmdFileDescriptor) {
        for (ViolationType vioType : fileType.getViolation()) {
            PmdViolationDescriptor vioDescriptor = (PmdViolationDescriptor)store.create(PmdViolationDescriptor.class);
            vioDescriptor.setRule(vioType.getRule());
            vioDescriptor.setRuleSet(vioType.getRuleset());
            vioDescriptor.setPriority(vioType.getPriority());
            vioDescriptor.setMethod(vioType.getMethod());
            pmdFileDescriptor.getViolations().add(vioDescriptor);
        }
    }

    protected String truncateName(String name) {
        if (name.lastIndexOf(System.getProperty("file.separator")) <= 0) {
            return name;
        }
        return name.substring(name.lastIndexOf(System.getProperty("file.separator")) + 1);
    }

    protected PmdType unmarshalPmdXml(InputStream streamSource) throws IOException {
        PmdType pmdType;
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            pmdType = (PmdType)unmarshaller.unmarshal((Source)new StreamSource(streamSource), PmdType.class).getValue();
        }
        catch (JAXBException e) {
            throw new IOException("Cannot read model descriptor.", e);
        }
        return pmdType;
    }
}

