/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.pmd.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import de.kontext_e.jqassistant.plugin.pmd.jaxb.FileType;
import de.kontext_e.jqassistant.plugin.pmd.jaxb.ObjectFactory;
import de.kontext_e.jqassistant.plugin.pmd.jaxb.PmdType;
import de.kontext_e.jqassistant.plugin.pmd.jaxb.ViolationType;
import de.kontext_e.jqassistant.plugin.pmd.store.FileDescriptor;
import de.kontext_e.jqassistant.plugin.pmd.store.PmdDescriptor;
import de.kontext_e.jqassistant.plugin.pmd.store.ViolationDescriptor;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PmdScannerPlugin
extends AbstractScannerPlugin<FileResource, PmdDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PmdScannerPlugin.class);
    public static final String JQASSISTANT_PLUGIN_PMD_FILENAME = "jqassistant.plugin.pmd.filename";
    private JAXBContext jaxbContext;
    private String pmdFileName = "pmd.xml";
    private String pmdDirName = "pmd";

    public PmdScannerPlugin() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Cannot create JAXB context.", e);
        }
    }

    protected void configure() {
        super.configure();
        String property = (String)this.getProperties().get(JQASSISTANT_PLUGIN_PMD_FILENAME);
        if (property != null) {
            this.pmdFileName = property;
        }
        if (System.getProperty(JQASSISTANT_PLUGIN_PMD_FILENAME) != null) {
            this.pmdFileName = System.getProperty(JQASSISTANT_PLUGIN_PMD_FILENAME);
        }
        LOGGER.info(String.format("PMD plugin looks for files named %s or for all XML files in directories named 'pmd'", this.pmdFileName));
    }

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        boolean accepted;
        boolean bl = accepted = path.endsWith(this.pmdFileName) || this.pmdDirName.equals(item.getFile().toPath().getParent().toFile().getName()) && path.endsWith(".xml");
        if (accepted) {
            LOGGER.debug("Pmd accepted path " + path);
        }
        return accepted;
    }

    public PmdDescriptor scan(FileResource file, String path, Scope scope, Scanner scanner) throws IOException {
        LOGGER.debug("Pmd scans path " + path);
        PmdType pmdType = this.unmarshalPmdXml(file.createStream());
        PmdDescriptor pmdDescriptor = (PmdDescriptor)scanner.getContext().getStore().create(PmdDescriptor.class);
        pmdDescriptor.setFileName(path);
        this.readFiles(scanner.getContext().getStore(), pmdType, pmdDescriptor);
        return pmdDescriptor;
    }

    private void readFiles(Store store, PmdType pmdType, PmdDescriptor pmdDescriptor) {
        for (FileType fileType : pmdType.getFile()) {
            FileDescriptor fileDescriptor = (FileDescriptor)store.create(FileDescriptor.class);
            fileDescriptor.setName(this.truncateName(fileType.getName()));
            String classname = fileType.getViolation().get(0).getClazz();
            String packagename = fileType.getViolation().get(0).getPackage();
            String fqn = packagename + "." + classname;
            fileDescriptor.setFullQualifiedName(fqn);
            pmdDescriptor.getFiles().add(fileDescriptor);
            this.readViolations(store, fileType, fileDescriptor);
        }
    }

    private void readViolations(Store store, FileType fileType, FileDescriptor fileDescriptor) {
        for (ViolationType vioType : fileType.getViolation()) {
            ViolationDescriptor vioDescriptor = (ViolationDescriptor)store.create(ViolationDescriptor.class);
            vioDescriptor.setRule(vioType.getRule());
            vioDescriptor.setRuleSet(vioType.getRuleset());
            vioDescriptor.setPriority(vioType.getPriority());
            vioDescriptor.setMethod(vioType.getMethod());
            fileDescriptor.getViolations().add(vioDescriptor);
        }
    }

    protected String truncateName(String name) {
        if (name.lastIndexOf(System.getProperty("file.separator")) <= 0) {
            return name;
        }
        return name.substring(name.lastIndexOf(System.getProperty("file.separator")) + 1);
    }

    protected PmdType unmarshalPmdXml(InputStream streamSource) throws IOException {
        PmdType pmdType;
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            pmdType = (PmdType)unmarshaller.unmarshal((Source)new StreamSource(streamSource), PmdType.class).getValue();
        }
        catch (JAXBException e) {
            throw new IOException("Cannot read model descriptor.", e);
        }
        return pmdType;
    }
}

