/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.linecount.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import de.kontext_e.jqassistant.plugin.linecount.store.descriptor.LinecountDescriptor;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class LinecountScannerPlugin
extends AbstractScannerPlugin<FileResource, LinecountDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinecountScannerPlugin.class);
    public static final String SUFFIXES = "jqassistant.plugin.linecount.suffixes";
    private final Set<String> acceptedSuffixes = new HashSet<String>();

    public LinecountScannerPlugin() {
        this.acceptedSuffixes.addAll(Arrays.asList("java", "xml", "html", "xhtml", "js", "gradle"));
    }

    public boolean accepts(FileResource item, String path, Scope scope) {
        if (path.lastIndexOf(".") <= 0) {
            return false;
        }
        String suffix = path.substring(path.lastIndexOf(".") + 1);
        return this.acceptedSuffixes.contains(suffix.toLowerCase());
    }

    public LinecountDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        Store store = scanner.getContext().getStore();
        FileDescriptor fileDescriptor = (FileDescriptor)scanner.getContext().getCurrentDescriptor();
        LinecountDescriptor linecountDescriptor = (LinecountDescriptor)store.addDescriptorType((Descriptor)fileDescriptor, LinecountDescriptor.class);
        linecountDescriptor.setName(path);
        int lines = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(item.getFile().getAbsolutePath()));){
            while (reader.readLine() != null) {
                ++lines;
            }
        }
        linecountDescriptor.setLinecount(lines);
        return linecountDescriptor;
    }

    protected void configure() {
        super.configure();
        Map properties = this.getProperties();
        String suffixes = (String)properties.get(SUFFIXES);
        if (suffixes != null) {
            this.acceptSuffixes(suffixes);
        }
        if (System.getProperty(SUFFIXES) != null) {
            this.acceptSuffixes(System.getProperty(SUFFIXES));
        }
        LOGGER.debug("Linecount plugin accepts following suffixes: " + this.getAcceptedSuffixes());
    }

    protected void acceptSuffixes(String suffixes) {
        String normalizedString = suffixes.replaceAll("[,;:]", " ").toLowerCase();
        this.acceptedSuffixes.clear();
        this.acceptedSuffixes.addAll(Arrays.asList(normalizedString.split(" ")));
        this.acceptedSuffixes.remove("");
    }

    public Set<String> getAcceptedSuffixes() {
        return this.acceptedSuffixes;
    }
}

