/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.jacoco.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.java.api.scanner.SignatureHelper;
import de.kontext_e.jqassistant.plugin.jacoco.jaxb.ClassType;
import de.kontext_e.jqassistant.plugin.jacoco.jaxb.CounterType;
import de.kontext_e.jqassistant.plugin.jacoco.jaxb.MethodType;
import de.kontext_e.jqassistant.plugin.jacoco.jaxb.ObjectFactory;
import de.kontext_e.jqassistant.plugin.jacoco.jaxb.PackageType;
import de.kontext_e.jqassistant.plugin.jacoco.jaxb.ReportType;
import de.kontext_e.jqassistant.plugin.jacoco.store.descriptor.JacocoClassDescriptor;
import de.kontext_e.jqassistant.plugin.jacoco.store.descriptor.JacocoCounterDescriptor;
import de.kontext_e.jqassistant.plugin.jacoco.store.descriptor.JacocoMethodDescriptor;
import de.kontext_e.jqassistant.plugin.jacoco.store.descriptor.JacocoPackageDescriptor;
import de.kontext_e.jqassistant.plugin.jacoco.store.descriptor.JacocoReportDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class JacocoScannerPlugin
extends AbstractScannerPlugin<FileResource, JacocoReportDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JacocoScannerPlugin.class);
    public static final String JQASSISTANT_PLUGIN_JACOCO_FILENAME = "jqassistant.plugin.jacoco.filename";
    public static final String JQASSISTANT_PLUGIN_JACOCO_DIRNAME = "jqassistant.plugin.jacoco.dirname";
    private final JAXBContext jaxbContext;
    private String jacocoDirName = "jacoco";
    private String jacocoFileName = "jacocoTestReport.xml";

    public JacocoScannerPlugin() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Cannot create JAXB context.", e);
        }
    }

    protected void configure() {
        super.configure();
        if (this.getProperties().containsKey(JQASSISTANT_PLUGIN_JACOCO_DIRNAME)) {
            this.jacocoDirName = (String)this.getProperties().get(JQASSISTANT_PLUGIN_JACOCO_DIRNAME);
        }
        if (this.getProperties().containsKey(JQASSISTANT_PLUGIN_JACOCO_FILENAME)) {
            this.jacocoFileName = (String)this.getProperties().get(JQASSISTANT_PLUGIN_JACOCO_FILENAME);
        }
        LOGGER.info(String.format("Jacoco plugin looks for files named %s and files in directory %s", this.jacocoFileName, this.jacocoDirName));
    }

    public boolean accepts(FileResource item, String path, Scope scope) {
        try {
            boolean accepted = this.acceptsPath(path);
            if (accepted) {
                LOGGER.info("Jacoco plugin accepted " + path);
            }
            return accepted;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Error while checking path: " + e, (Throwable)e);
            return false;
        }
    }

    boolean acceptsPath(String path) {
        return path.endsWith(this.jacocoFileName) || this.parentDirectoryHasAcceptableName(path);
    }

    private boolean parentDirectoryHasAcceptableName(String path) {
        if (!path.endsWith(".xml")) {
            return false;
        }
        String[] parts = path.split("/");
        if (parts == null || parts.length < 2) {
            return false;
        }
        if (this.jacocoDirName == null) {
            return false;
        }
        String parentName = parts[parts.length - 2];
        return this.jacocoDirName.equalsIgnoreCase(parentName);
    }

    public JacocoReportDescriptor scan(FileResource file, String path, Scope scope, Scanner scanner) throws IOException {
        LOGGER.debug("Jacoco plugin scans " + path);
        FileDescriptor fileDescriptor = (FileDescriptor)scanner.getContext().getCurrentDescriptor();
        JacocoReportDescriptor jacocoReportDescriptor = (JacocoReportDescriptor)scanner.getContext().getStore().addDescriptorType((Descriptor)fileDescriptor, JacocoReportDescriptor.class);
        ReportType reportType = this.unmarshalJacocoXml(file.createStream());
        this.readPackages(scanner.getContext().getStore(), reportType, jacocoReportDescriptor);
        return jacocoReportDescriptor;
    }

    private void readPackages(Store store, ReportType reportType, JacocoReportDescriptor jacocoReportDescriptor) {
        for (PackageType packageType : reportType.getPackage()) {
            JacocoPackageDescriptor jacocoPackageDescriptor = (JacocoPackageDescriptor)store.create(JacocoPackageDescriptor.class);
            jacocoPackageDescriptor.setName(packageType.getName());
            this.readClasses(store, packageType, jacocoPackageDescriptor);
            jacocoReportDescriptor.getJacocoPackages().add(jacocoPackageDescriptor);
        }
    }

    private void readClasses(Store store, PackageType packageType, JacocoPackageDescriptor jacocoPackageDescriptor) {
        for (ClassType classType : packageType.getClazz()) {
            JacocoClassDescriptor jacocoClassDescriptor = (JacocoClassDescriptor)store.create(JacocoClassDescriptor.class);
            jacocoClassDescriptor.setName(classType.getName());
            jacocoClassDescriptor.setFullQualifiedName(jacocoClassDescriptor.getName().replaceAll("/", "."));
            this.readMethods(store, classType, jacocoClassDescriptor);
            jacocoPackageDescriptor.getJacocoClasses().add(jacocoClassDescriptor);
        }
    }

    private void readMethods(Store store, ClassType classType, JacocoClassDescriptor jacocoClassDescriptor) {
        for (MethodType methodType : classType.getMethod()) {
            JacocoMethodDescriptor jacocoMethodDescriptor = (JacocoMethodDescriptor)store.create(JacocoMethodDescriptor.class);
            jacocoMethodDescriptor.setName(methodType.getName());
            jacocoMethodDescriptor.setSignature(SignatureHelper.getMethodSignature((String)methodType.getName(), (String)methodType.getDesc()));
            jacocoMethodDescriptor.setLine(methodType.getLine());
            jacocoClassDescriptor.getJacocoMethods().add(jacocoMethodDescriptor);
            this.readCounters(store, methodType, jacocoMethodDescriptor);
        }
    }

    private void readCounters(Store store, MethodType methodType, JacocoMethodDescriptor jacocoMethodDescriptor) {
        for (CounterType counterType : methodType.getCounter()) {
            JacocoCounterDescriptor jacocoCounterDescriptor = (JacocoCounterDescriptor)store.create(JacocoCounterDescriptor.class);
            jacocoCounterDescriptor.setType(counterType.getType());
            jacocoCounterDescriptor.setMissed(Long.valueOf(counterType.getMissed()));
            jacocoCounterDescriptor.setCovered(Long.valueOf(counterType.getCovered()));
            jacocoMethodDescriptor.getJacocoCounters().add(jacocoCounterDescriptor);
        }
    }

    protected ReportType unmarshalJacocoXml(InputStream streamSource) throws IOException {
        ReportType reportType;
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setValidating(false);
            parserFactory.setFeature("http://xml.org/sax/features/validation", false);
            parserFactory.setFeature("http://apache.org/xml/features/validation/schema", false);
            parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            XMLReader xmlReader = parserFactory.newSAXParser().getXMLReader();
            InputSource inputSource = new InputSource(new InputStreamReader(streamSource));
            SAXSource saxSource = new SAXSource(xmlReader, inputSource);
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            reportType = (ReportType)unmarshaller.unmarshal((Source)saxSource, ReportType.class).getValue();
        }
        catch (JAXBException | ParserConfigurationException | SAXException e) {
            throw new IOException("Cannot read model descriptor.", e);
        }
        return reportType;
    }
}

