/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.jacoco.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import de.kontext_e.jqassistant.plugin.jacoco.jaxb.ClassType;
import de.kontext_e.jqassistant.plugin.jacoco.jaxb.CounterType;
import de.kontext_e.jqassistant.plugin.jacoco.jaxb.MethodType;
import de.kontext_e.jqassistant.plugin.jacoco.jaxb.ObjectFactory;
import de.kontext_e.jqassistant.plugin.jacoco.jaxb.PackageType;
import de.kontext_e.jqassistant.plugin.jacoco.jaxb.ReportType;
import de.kontext_e.jqassistant.plugin.jacoco.store.descriptor.ClassDescriptor;
import de.kontext_e.jqassistant.plugin.jacoco.store.descriptor.CounterDescriptor;
import de.kontext_e.jqassistant.plugin.jacoco.store.descriptor.JacocoDescriptor;
import de.kontext_e.jqassistant.plugin.jacoco.store.descriptor.MethodDescriptor;
import de.kontext_e.jqassistant.plugin.jacoco.store.descriptor.PackageDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JacocoScannerPlugin
extends AbstractScannerPlugin<FileResource, JacocoDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JacocoScannerPlugin.class);
    public static final String JQASSISTANT_PLUGIN_JACOCO_FILENAME = "jqassistant.plugin.jacoco.filename";
    private JAXBContext jaxbContext;
    private String jacocoFileName = "jacocoTestReport.xml";

    public JacocoScannerPlugin() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Cannot create JAXB context.", e);
        }
    }

    protected void initialize() {
        super.initialize();
        String jacocoFileNameProperty = (String)this.getProperties().get(JQASSISTANT_PLUGIN_JACOCO_FILENAME);
        if (jacocoFileNameProperty != null) {
            this.jacocoFileName = jacocoFileNameProperty;
        }
        if (System.getProperty(JQASSISTANT_PLUGIN_JACOCO_FILENAME) != null) {
            this.jacocoFileName = System.getProperty(JQASSISTANT_PLUGIN_JACOCO_FILENAME);
        }
        LOGGER.info("Jacoco plugin looks for files named " + this.jacocoFileName);
    }

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        boolean accepted = path.endsWith(this.jacocoFileName);
        if (accepted) {
            LOGGER.debug("Jacoco plugin accepted " + path);
        }
        return accepted;
    }

    public JacocoDescriptor scan(FileResource file, String path, Scope scope, Scanner scanner) throws IOException {
        LOGGER.debug("Jacoco plugin scans " + path);
        JacocoDescriptor jacocoDescriptor = (JacocoDescriptor)scanner.getContext().getStore().create(JacocoDescriptor.class);
        jacocoDescriptor.setFileName(path);
        ReportType reportType = this.unmarshalJacocoXml(file.createStream());
        this.readPackages(scanner.getContext().getStore(), reportType, jacocoDescriptor);
        return jacocoDescriptor;
    }

    private void readPackages(Store store, ReportType reportType, JacocoDescriptor jacocoDescriptor) {
        for (PackageType packageType : reportType.getPackage()) {
            PackageDescriptor packageDescriptor = (PackageDescriptor)store.create(PackageDescriptor.class);
            packageDescriptor.setName(packageType.getName());
            this.readClasses(store, packageType, packageDescriptor);
            jacocoDescriptor.getJacocoPackages().add(packageDescriptor);
        }
    }

    private void readClasses(Store store, PackageType packageType, PackageDescriptor packageDescriptor) {
        for (ClassType classType : packageType.getClazz()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)store.create(ClassDescriptor.class);
            classDescriptor.setName(classType.getName());
            classDescriptor.setFullQualifiedName(classDescriptor.getName().replaceAll("/", "."));
            this.readMethods(store, classType, classDescriptor);
            packageDescriptor.getJacocoClasses().add(classDescriptor);
        }
    }

    private void readMethods(Store store, ClassType classType, ClassDescriptor classDescriptor) {
        for (MethodType methodType : classType.getMethod()) {
            MethodDescriptor methodDescriptor = (MethodDescriptor)store.create(MethodDescriptor.class);
            methodDescriptor.setName(methodType.getName());
            methodDescriptor.setSignature(this.getMethodSignature(methodType.getName(), methodType.getDesc()));
            methodDescriptor.setLine(methodType.getLine());
            classDescriptor.getJacocoMethods().add(methodDescriptor);
            this.readCounters(store, methodType, methodDescriptor);
        }
    }

    private void readCounters(Store store, MethodType methodType, MethodDescriptor methodDescriptor) {
        for (CounterType counterType : methodType.getCounter()) {
            CounterDescriptor counterDescriptor = (CounterDescriptor)store.create(CounterDescriptor.class);
            counterDescriptor.setType(counterType.getType());
            counterDescriptor.setMissed(Long.valueOf(counterType.getMissed()));
            counterDescriptor.setCovered(Long.valueOf(counterType.getCovered()));
            methodDescriptor.getJacocoCounters().add(counterDescriptor);
        }
    }

    String getMethodSignature(String name, String desc) {
        StringBuilder signature = new StringBuilder();
        String returnType = Type.getReturnType((String)desc).getClassName();
        if (returnType != null) {
            signature.append(returnType);
            signature.append(' ');
        }
        signature.append(name);
        signature.append('(');
        Type[] types = Type.getArgumentTypes((String)desc);
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                signature.append(',');
            }
            signature.append(types[i].getClassName());
        }
        signature.append(')');
        return signature.toString();
    }

    protected ReportType unmarshalJacocoXml(InputStream streamSource) throws IOException {
        ReportType reportType;
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setValidating(false);
            parserFactory.setFeature("http://xml.org/sax/features/validation", false);
            parserFactory.setFeature("http://apache.org/xml/features/validation/schema", false);
            parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            XMLReader xmlReader = parserFactory.newSAXParser().getXMLReader();
            InputSource inputSource = new InputSource(new InputStreamReader(streamSource));
            SAXSource saxSource = new SAXSource(xmlReader, inputSource);
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            reportType = (ReportType)unmarshaller.unmarshal((Source)saxSource, ReportType.class).getValue();
        }
        catch (JAXBException | ParserConfigurationException | SAXException e) {
            throw new IOException("Cannot read model descriptor.", e);
        }
        return reportType;
    }
}

