/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.git.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import de.kontext_e.jqassistant.plugin.git.scanner.GitRepositoryScanner;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitRepositoryDescriptor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class GitScannerPlugin
extends AbstractScannerPlugin<FileResource, GitRepositoryDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitScannerPlugin.class);
    private static final String GIT_RANGE = "jqassistant.plugin.git.range";
    private static int counter = 0;
    private String range = null;

    public boolean accepts(FileResource item, String path, Scope scope) {
        if (counter > 0) {
            return false;
        }
        try {
            if (path.endsWith("/HEAD")) {
                File gitDirectory = item.getFile();
                LOGGER.debug("Checking path {} / dir {}", (Object)path, (Object)gitDirectory);
                boolean isGitDir = ".git".equals(gitDirectory.toPath().toAbsolutePath().getParent().toFile().getName());
                if (!isGitDir) {
                    return false;
                }
                String pathToGitProject = gitDirectory.toPath().getParent().toFile().getAbsolutePath();
                LOGGER.info("Accepted Git project in '{}'", (Object)pathToGitProject);
                return true;
            }
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Error while checking path: " + e, (Throwable)e);
            return false;
        }
    }

    public GitRepositoryDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        ++counter;
        LOGGER.debug("Scanning Git directory '{}' (call with path: '{}')", (Object)item.getFile(), (Object)path);
        Store store = scanner.getContext().getStore();
        FileDescriptor fileDescriptor = (FileDescriptor)scanner.getContext().getCurrentDescriptor();
        GitRepositoryDescriptor gitRepositoryDescriptor = (GitRepositoryDescriptor)store.addDescriptorType((Descriptor)fileDescriptor, GitRepositoryDescriptor.class);
        GitScannerPlugin.initGitDescriptor(gitRepositoryDescriptor, item.getFile());
        new GitRepositoryScanner(store, gitRepositoryDescriptor, this.range).scanGitRepo();
        return gitRepositoryDescriptor;
    }

    static void initGitDescriptor(GitRepositoryDescriptor gitRepositoryDescriptor, File file) throws IOException {
        Path headPath = file.toPath().toAbsolutePath().normalize();
        LOGGER.debug("Full path to Git directory HEAD is '{}'", (Object)headPath);
        Path gitPath = headPath.getParent();
        String pathToGitProject = gitPath.toFile().getAbsolutePath();
        LOGGER.debug("Full path to Git directory is '{}'", (Object)pathToGitProject);
        Path projectPath = gitPath.getParent();
        String projectName = projectPath.toFile().getName();
        LOGGER.debug("Git Project name is '{}'", (Object)projectName);
        gitRepositoryDescriptor.setName(projectName);
        gitRepositoryDescriptor.setFileName(pathToGitProject);
    }

    private void setRange(String range) {
        this.range = range;
        LOGGER.info("Git plugin has configured range '{}'", (Object)range);
    }

    protected void configure() {
        super.configure();
        Map properties = this.getProperties();
        String rangeProperty = (String)properties.get(GIT_RANGE);
        if (rangeProperty != null) {
            this.setRange(rangeProperty);
        } else {
            rangeProperty = System.getProperty(GIT_RANGE);
            if (rangeProperty != null) {
                this.setRange(rangeProperty);
            }
        }
    }
}

