/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.git.scanner;

import com.buschmais.jqassistant.core.store.api.Store;
import de.kontext_e.jqassistant.plugin.git.scanner.GitBranch;
import de.kontext_e.jqassistant.plugin.git.scanner.GitChange;
import de.kontext_e.jqassistant.plugin.git.scanner.GitCommit;
import de.kontext_e.jqassistant.plugin.git.scanner.GitTag;
import de.kontext_e.jqassistant.plugin.git.scanner.JGitScanner;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitAuthorDescriptor;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitBranchDescriptor;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitChangeDescriptor;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitCommitDescriptor;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitFileDescriptor;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitRepositoryDescriptor;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitTagDescriptor;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GitRepositoryScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitRepositoryScanner.class);
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss Z");
    private static final DateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private final Store store;
    private final GitRepositoryDescriptor gitRepositoryDescriptor;
    private String range;
    private final Map<String, GitAuthorDescriptor> authors = new HashMap<String, GitAuthorDescriptor>();
    private final Map<String, GitFileDescriptor> files = new HashMap<String, GitFileDescriptor>();
    private final Map<String, GitCommitDescriptor> commits = new HashMap<String, GitCommitDescriptor>();
    private final List<GitCommit> gitCommits = new ArrayList<GitCommit>();

    GitRepositoryScanner(Store store, GitRepositoryDescriptor gitRepositoryDescriptor, String range) {
        this.store = store;
        this.gitRepositoryDescriptor = gitRepositoryDescriptor;
        this.range = range;
    }

    void scanGitRepo() throws IOException {
        JGitScanner jGitScanner = new JGitScanner(this.gitRepositoryDescriptor.getFileName(), this.range);
        this.gitCommits.addAll(jGitScanner.findCommits());
        this.addCommits();
        this.addBranches(jGitScanner.findBranches());
        this.addTags(jGitScanner.findTags());
        this.authors.values().forEach(gitAuthor -> this.gitRepositoryDescriptor.getAuthors().add((GitAuthorDescriptor)gitAuthor));
        this.files.values().forEach(gitFile -> this.gitRepositoryDescriptor.getFiles().add((GitFileDescriptor)gitFile));
        GitBranch head = jGitScanner.findHead();
        GitCommitDescriptor headDescriptor = this.commits.get(head.getCommitSha());
        this.gitRepositoryDescriptor.setHead(headDescriptor);
    }

    private void addCommits() {
        for (GitCommit gitCommit : this.gitCommits) {
            GitCommitDescriptor gitCommitDescriptor = (GitCommitDescriptor)this.store.create(GitCommitDescriptor.class);
            String sha = gitCommit.getSha();
            LOGGER.debug("Adding new Commit '{}'", (Object)sha);
            this.commits.put(sha, gitCommitDescriptor);
            gitCommitDescriptor.setSha(gitCommit.getSha());
            gitCommitDescriptor.setAuthor(gitCommit.getAuthor());
            gitCommitDescriptor.setCommitter(gitCommit.getCommitter());
            gitCommitDescriptor.setDate(DATE_FORMAT.format(gitCommit.getDate()));
            gitCommitDescriptor.setMessage(gitCommit.getMessage());
            gitCommitDescriptor.setShortMessage(gitCommit.getShortMessage());
            gitCommitDescriptor.setEpoch(gitCommit.getDate().getTime());
            gitCommitDescriptor.setTime(TIME_FORMAT.format(gitCommit.getDate()));
            gitCommitDescriptor.setEncoding(gitCommit.getEncoding());
            this.gitRepositoryDescriptor.getCommits().add(gitCommitDescriptor);
            this.addCommitForAuthor(this.authors, gitCommit.getAuthor(), gitCommitDescriptor);
            this.addCommitFiles(gitCommit, gitCommitDescriptor, this.files);
        }
        for (GitCommit gitCommit : this.gitCommits) {
            String sha = gitCommit.getSha();
            GitCommitDescriptor gitCommitDescriptor = this.commits.get(sha);
            for (GitCommit parent : gitCommit.getParents()) {
                String parentSha = parent.getSha();
                GitCommitDescriptor parentCommit = this.commits.get(parentSha);
                if (null == parentCommit) {
                    LOGGER.warn("Cannot add (parent) commit with SHA '{}' (excluded by range?)", (Object)parentSha);
                    continue;
                }
                gitCommitDescriptor.getParents().add(parentCommit);
            }
        }
    }

    private void addBranches(List<GitBranch> branches) throws IOException {
        for (GitBranch gitBranch : branches) {
            GitBranchDescriptor gitBranchDescriptor = (GitBranchDescriptor)this.store.create(GitBranchDescriptor.class);
            String name = gitBranch.getName();
            name = name.replaceFirst("refs/", "");
            String sha = gitBranch.getCommitSha();
            LOGGER.debug("Adding new Branch '{}' with Head '{}'", (Object)name, (Object)sha);
            gitBranchDescriptor.setName(name);
            GitCommitDescriptor gitCommitDescriptor = this.commits.get(sha);
            if (null == gitCommitDescriptor) {
                LOGGER.warn("Cannot retrieve commit '{}' for branch '{}'", (Object)sha, (Object)name);
            }
            gitBranchDescriptor.setHead(gitCommitDescriptor);
            this.gitRepositoryDescriptor.getBranches().add(gitBranchDescriptor);
        }
    }

    private void addTags(List<GitTag> tags) throws IOException {
        for (GitTag gitTag : tags) {
            GitTagDescriptor gitTagDescriptor = (GitTagDescriptor)this.store.create(GitTagDescriptor.class);
            String label = gitTag.getLabel();
            label = label.replaceFirst("refs/tags/", "");
            String sha = gitTag.getCommitSha();
            LOGGER.debug("Adding new Tag '{}' with Commit '{}'", (Object)label, (Object)sha);
            gitTagDescriptor.setLabel(label);
            GitCommitDescriptor gitCommitDescriptor = this.commits.get(sha);
            if (null == gitCommitDescriptor) {
                LOGGER.warn("Cannot retrieve commit '{}' for tag '{}'", (Object)sha, (Object)label);
            }
            gitTagDescriptor.setCommit(gitCommitDescriptor);
            this.gitRepositoryDescriptor.getTags().add(gitTagDescriptor);
        }
    }

    private void addCommitForAuthor(Map<String, GitAuthorDescriptor> authors, String author, GitCommitDescriptor gitCommit) {
        if (null != author) {
            if (!authors.containsKey(author)) {
                LOGGER.debug("Adding new author '{}'", (Object)author);
                GitAuthorDescriptor gitAuthor = (GitAuthorDescriptor)this.store.find(GitAuthorDescriptor.class, author);
                if (null == gitAuthor) {
                    LOGGER.debug("Author '{}' does not exist, have to create a new entity", (Object)author);
                    gitAuthor = (GitAuthorDescriptor)this.store.create(GitAuthorDescriptor.class);
                    gitAuthor.setIdentString(author);
                }
                gitAuthor.setName(author.substring(0, author.indexOf("<")).trim());
                gitAuthor.setEmail(author.substring(author.indexOf("<") + 1, author.indexOf(">")).trim());
                authors.put(author, gitAuthor);
            }
            authors.get(author).getCommits().add(gitCommit);
        }
    }

    private void addCommitFiles(GitCommit gitCommit, GitCommitDescriptor gitCommitDescriptor, Map<String, GitFileDescriptor> files) {
        for (GitChange gitChange : gitCommit.getGitChanges()) {
            GitChangeDescriptor gitCommitFile = (GitChangeDescriptor)this.store.create(GitChangeDescriptor.class);
            gitCommitFile.setModificationKind(gitChange.getModificationKind());
            gitCommitDescriptor.getFiles().add(gitCommitFile);
            this.addAsGitFile(files, gitChange, gitCommitFile, gitCommit.getDate());
        }
    }

    private void addAsGitFile(Map<String, GitFileDescriptor> files, GitChange gitChange, GitChangeDescriptor gitChangeDescriptor, Date date) {
        GitFileDescriptor gitFileDescriptor = this.getOrCreateGitFileDescriptor(files, gitChange.getRelativePath());
        gitChangeDescriptor.setModifies(gitFileDescriptor);
        if (this.isAddChange(gitChangeDescriptor)) {
            gitFileDescriptor.setCreatedAt(DATE_TIME_FORMAT.format(date));
            gitFileDescriptor.setCreatedAtEpoch(date.getTime());
            gitChangeDescriptor.setCreates(gitFileDescriptor);
        } else if (this.isUpdateChange(gitChangeDescriptor)) {
            gitFileDescriptor.setLastModificationAt(DATE_TIME_FORMAT.format(date));
            gitFileDescriptor.setLastModificationAtEpoch(date.getTime());
            gitChangeDescriptor.setUpdates(gitFileDescriptor);
        } else if (this.isDeleteChange(gitChangeDescriptor)) {
            gitFileDescriptor.setDeletedAt(DATE_TIME_FORMAT.format(date));
            gitFileDescriptor.setDeletedAtEpoch(date.getTime());
            gitChangeDescriptor.setDeletes(gitFileDescriptor);
        } else if (this.isRenameChange(gitChangeDescriptor)) {
            GitFileDescriptor oldFile = this.getOrCreateGitFileDescriptor(files, gitChange.getOldPath());
            GitFileDescriptor newFile = this.getOrCreateGitFileDescriptor(files, gitChange.getNewPath());
            oldFile.setHasNewName(newFile);
            gitChangeDescriptor.setRenames(oldFile);
            gitChangeDescriptor.setDeletes(oldFile);
            gitChangeDescriptor.setCreates(newFile);
        } else if (this.isCopyChange(gitChangeDescriptor)) {
            GitFileDescriptor oldFile = this.getOrCreateGitFileDescriptor(files, gitChange.getOldPath());
            GitFileDescriptor newFile = this.getOrCreateGitFileDescriptor(files, gitChange.getNewPath());
            newFile.setCopyOf(oldFile);
            gitChangeDescriptor.setCopies(oldFile);
            gitChangeDescriptor.setCreates(newFile);
        }
    }

    private boolean isCopyChange(GitChangeDescriptor gitChangeDescriptor) {
        return "C".equals(gitChangeDescriptor.getModificationKind().toUpperCase());
    }

    private boolean isRenameChange(GitChangeDescriptor gitChangeDescriptor) {
        return "R".equals(gitChangeDescriptor.getModificationKind().toUpperCase());
    }

    private boolean isDeleteChange(GitChangeDescriptor gitChangeDescriptor) {
        return "D".equals(gitChangeDescriptor.getModificationKind().toUpperCase());
    }

    private boolean isUpdateChange(GitChangeDescriptor gitChangeDescriptor) {
        return "M".equals(gitChangeDescriptor.getModificationKind().toUpperCase());
    }

    private boolean isAddChange(GitChangeDescriptor gitChangeDescriptor) {
        return "A".equals(gitChangeDescriptor.getModificationKind().toUpperCase());
    }

    private GitFileDescriptor getOrCreateGitFileDescriptor(Map<String, GitFileDescriptor> files, String relativePath) {
        GitFileDescriptor gitFileDescriptor = files.get(relativePath);
        if (gitFileDescriptor == null) {
            gitFileDescriptor = (GitFileDescriptor)this.store.create(GitFileDescriptor.class);
            gitFileDescriptor.setRelativePath(relativePath);
            files.put(relativePath, gitFileDescriptor);
        }
        return gitFileDescriptor;
    }
}

