/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.git.scanner;

import de.kontext_e.jqassistant.plugin.git.scanner.GitBranch;
import de.kontext_e.jqassistant.plugin.git.scanner.GitChange;
import de.kontext_e.jqassistant.plugin.git.scanner.GitCommit;
import de.kontext_e.jqassistant.plugin.git.scanner.GitTag;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JGitScanner {
    private static final Logger logger = LoggerFactory.getLogger(JGitScanner.class);
    private String path = null;
    private String range = null;
    private Map<String, GitCommit> commits = new HashMap<String, GitCommit>();

    JGitScanner(String path, String range) {
        this.path = path;
        this.range = range;
    }

    static LogCommand getLogWithOrWithOutRange(Git git, String range) throws IOException {
        LogCommand result = git.log();
        if (null == range) {
            result = result.all();
        } else {
            int firstDot = range.indexOf(46);
            if (firstDot <= 0) {
                throw new IllegalArgumentException("Git range must start like '<rev specification>..'");
            }
            int lastDot = range.lastIndexOf(".");
            if (lastDot - firstDot != 1) {
                throw new IllegalArgumentException("Git range specials ('three dot notation' etc.) are not supported!");
            }
            String sinceString = range.substring(0, firstDot);
            String untilString = lastDot + 1 < range.length() ? range.substring(lastDot + 1) : "HEAD";
            logger.debug("Using range from '{}' to '{}'", (Object)sinceString, (Object)untilString);
            ObjectId since = git.getRepository().resolve(sinceString);
            if (null == since) {
                throw new IllegalArgumentException("Could not retrieve 'since' Range part '" + sinceString + "'");
            }
            ObjectId until = git.getRepository().resolve(untilString);
            if (null == until) {
                throw new IllegalArgumentException("Could not retrieve 'until' Range part '" + untilString + "'");
            }
            result = result.addRange((AnyObjectId)since, (AnyObjectId)until);
        }
        return result;
    }

    List<GitCommit> findCommits() throws IOException {
        Repository repository = this.getRepository();
        LinkedList<GitCommit> result = new LinkedList<GitCommit>();
        ObjectId head = repository.resolve("HEAD");
        logger.debug("Found head: {}", (Object)head);
        RevWalk rw = new RevWalk(repository);
        try (Git git = new Git(repository);){
            LogCommand logCommand = JGitScanner.getLogWithOrWithOutRange(git, this.range);
            Iterable commits = logCommand.call();
            DiffFormatter df = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);
            df.setRepository(repository);
            df.setDiffComparator(RawTextComparator.DEFAULT);
            df.setDetectRenames(true);
            for (RevCommit commit : commits) {
                logger.debug("Commit-Message: '{}'", (Object)commit.getShortMessage());
                String author = commit.getAuthorIdent().getName() + " <" + commit.getAuthorIdent().getEmailAddress() + ">";
                Date date = new Date(1000L * (long)commit.getCommitTime());
                GitCommit gitCommit = this.retrieveCommit(ObjectId.toString((ObjectId)commit.getId()));
                gitCommit.setAuthor(author);
                gitCommit.setDate(date);
                gitCommit.setMessage(commit.getFullMessage());
                this.addCommitParents(rw, df, commit, gitCommit);
                result.add(gitCommit);
            }
        }
        catch (GitAPIException e) {
            throw new IllegalStateException("Could not read logs from Git repository '" + this.path + "'", e);
        }
        finally {
            rw.close();
            repository.close();
        }
        logger.debug("Found #{} commits", (Object)result.size());
        return result;
    }

    private GitCommit retrieveCommit(String sha) {
        if (!this.commits.containsKey(sha)) {
            this.commits.put(sha, new GitCommit(sha));
        }
        return this.commits.get(sha);
    }

    private void addCommitParents(RevWalk rw, DiffFormatter df, RevCommit revCommit, GitCommit gitCommit) throws IOException {
        for (int i = 0; i < revCommit.getParentCount(); ++i) {
            ObjectId parentId = revCommit.getParent(i).getId();
            RevCommit parent = rw.parseCommit((AnyObjectId)parentId);
            List diffs = df.scan(parent.getTree(), revCommit.getTree());
            for (DiffEntry diff : diffs) {
                String changeType = diff.getChangeType().toString().substring(0, 1);
                String oldPath = diff.getOldPath();
                String newPath = diff.getNewPath();
                String diffPath = "D".equalsIgnoreCase(changeType) ? oldPath : newPath;
                logger.debug("changeType={}, path={}", (Object)changeType, (Object)diffPath);
                GitChange gitChange = new GitChange(changeType, diffPath);
                gitCommit.getGitChanges().add(gitChange);
            }
            String parentSha = ObjectId.toString((ObjectId)parentId);
            GitCommit parentCommit = this.retrieveCommit(parentSha);
            gitCommit.getParents().add(parentCommit);
        }
    }

    private Repository getRepository() throws IOException {
        logger.debug("Opening repository for git directory '{}'", (Object)this.path);
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(new File(this.path))).readEnvironment()).build();
        logger.debug("Using Git repository in '{}'", (Object)repository.getDirectory());
        return repository;
    }

    GitBranch findHead() throws IOException {
        ObjectId head = this.getRepository().resolve("HEAD");
        return new GitBranch("HEAD", ObjectId.toString((ObjectId)head));
    }

    List<GitBranch> findBranches() throws IOException {
        LinkedList<GitBranch> result = new LinkedList<GitBranch>();
        try (Repository repository = this.getRepository();
             Git git = new Git(repository);){
            List branches = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
            for (Ref branchRef : branches) {
                GitBranch newBranch = new GitBranch(branchRef.getName(), ObjectId.toString((ObjectId)branchRef.getObjectId()));
                result.add(newBranch);
            }
        }
        return result;
    }

    private RevCommit resolveFirstCommitForTag(Git git, Ref tagRef) throws IOException, GitAPIException {
        LogCommand log = git.log();
        Ref peeledRef = git.getRepository().peel(tagRef);
        if (peeledRef.getPeeledObjectId() != null) {
            log.add((AnyObjectId)peeledRef.getPeeledObjectId());
        } else {
            log.add((AnyObjectId)tagRef.getObjectId());
        }
        Iterable logs = log.call();
        return (RevCommit)logs.iterator().next();
    }

    List<GitTag> findTags() throws IOException {
        LinkedList<GitTag> result = new LinkedList<GitTag>();
        try (Repository repository = this.getRepository();
             Git git = new Git(repository);){
            List tags = git.tagList().call();
            for (Ref tagRef : tags) {
                String label = tagRef.getName();
                RevCommit firstCommit = this.resolveFirstCommitForTag(git, tagRef);
                String objectId = ObjectId.toString((ObjectId)firstCommit);
                logger.debug("Found Tag '{}' (name = '{}', sha = '{}')", new Object[]{tagRef, label, objectId});
                GitTag newTag = new GitTag(label, objectId);
                result.add(newTag);
            }
        }
        return result;
    }
}

