/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.git.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import de.kontext_e.jqassistant.plugin.git.scanner.GitBranch;
import de.kontext_e.jqassistant.plugin.git.scanner.GitChange;
import de.kontext_e.jqassistant.plugin.git.scanner.GitCommit;
import de.kontext_e.jqassistant.plugin.git.scanner.GitTag;
import de.kontext_e.jqassistant.plugin.git.scanner.JGitScanner;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitAuthorDescriptor;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitBranchDescriptor;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitChangeDescriptor;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitCommitDescriptor;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitFileDescriptor;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitRepositoryDescriptor;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitTagDescriptor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitScannerPlugin
extends AbstractScannerPlugin<FileResource, GitRepositoryDescriptor> {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss Z");
    private static final DateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private static final Logger LOGGER = LoggerFactory.getLogger(GitScannerPlugin.class);
    public static final String GIT_RANGE = "jqassistant.plugin.git.range";
    private String range = null;

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        boolean isGitDir;
        File gitDirectory = item.getFile();
        LOGGER.debug("Checking path {} / dir {}", (Object)path, (Object)gitDirectory);
        boolean bl = isGitDir = path.endsWith("/HEAD") && ".git".equals(gitDirectory.toPath().toAbsolutePath().getParent().toFile().getName());
        if (!isGitDir) {
            return false;
        }
        String pathToGitProject = item.getFile().toPath().getParent().toFile().getAbsolutePath();
        LOGGER.info("Accepted Git project in '{}'", (Object)pathToGitProject);
        return true;
    }

    protected static void initGitDescriptor(GitRepositoryDescriptor gitRepositoryDescriptor, File file) throws IOException {
        Path headPath = file.toPath().toAbsolutePath().normalize();
        LOGGER.debug("Full path to Git directory HEAD is '{}'", (Object)headPath);
        Path gitPath = headPath.getParent();
        String pathToGitProject = gitPath.toFile().getAbsolutePath();
        LOGGER.debug("Full path to Git directory is '{}'", (Object)pathToGitProject);
        Path projectPath = gitPath.getParent();
        String projectName = projectPath.toFile().getName();
        LOGGER.debug("Git Project name is '{}'", (Object)projectName);
        gitRepositoryDescriptor.setName(projectName);
        gitRepositoryDescriptor.setFileName(pathToGitProject);
    }

    public GitRepositoryDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        LOGGER.debug("Scanning Git directory '{}' (call with path: '{}')", (Object)item.getFile(), (Object)path);
        Store store = scanner.getContext().getStore();
        GitRepositoryDescriptor gitRepositoryDescriptor = (GitRepositoryDescriptor)store.create(GitRepositoryDescriptor.class);
        GitScannerPlugin.initGitDescriptor(gitRepositoryDescriptor, item.getFile());
        this.addCommits(store, gitRepositoryDescriptor);
        return gitRepositoryDescriptor;
    }

    private void addCommits(Store store, GitRepositoryDescriptor gitRepositoryDescriptor) throws IOException {
        GitCommitDescriptor gitCommitDescriptor;
        String sha;
        HashMap<String, GitAuthorDescriptor> authors = new HashMap<String, GitAuthorDescriptor>();
        HashMap<String, GitFileDescriptor> files = new HashMap<String, GitFileDescriptor>();
        HashMap<String, GitCommitDescriptor> commits = new HashMap<String, GitCommitDescriptor>();
        JGitScanner jGitScanner = new JGitScanner(gitRepositoryDescriptor.getFileName(), this.range);
        List<GitCommit> gitCommits = jGitScanner.findCommits();
        List<GitBranch> branches = jGitScanner.findBranches();
        List<GitTag> tags = jGitScanner.findTags();
        GitBranch head = jGitScanner.findHead();
        for (GitCommit gitCommit : gitCommits) {
            GitCommitDescriptor gitCommitDescriptor2 = (GitCommitDescriptor)store.create(GitCommitDescriptor.class);
            String sha2 = gitCommit.getSha();
            LOGGER.debug("Adding new Commit '{}'", (Object)sha2);
            commits.put(sha2, gitCommitDescriptor2);
            gitCommitDescriptor2.setSha(gitCommit.getSha());
            gitCommitDescriptor2.setAuthor(gitCommit.getAuthor());
            gitCommitDescriptor2.setDate(DATE_FORMAT.format(gitCommit.getDate()));
            gitCommitDescriptor2.setMessage(gitCommit.getMessage());
            gitCommitDescriptor2.setEpoch(gitCommit.getDate().getTime());
            gitCommitDescriptor2.setTime(TIME_FORMAT.format(gitCommit.getDate()));
            gitRepositoryDescriptor.getCommits().add(gitCommitDescriptor2);
            this.addCommitForAuthor(authors, gitCommit.getAuthor(), store, gitCommitDescriptor2);
            this.addCommitFiles(store, gitCommit, gitCommitDescriptor2, files);
        }
        for (GitCommit gitCommit : gitCommits) {
            String sha3 = gitCommit.getSha();
            GitCommitDescriptor gitCommitDescriptor3 = (GitCommitDescriptor)commits.get(sha3);
            for (GitCommit parent : gitCommit.getParents()) {
                String parentSha = parent.getSha();
                GitCommitDescriptor parentCommit = (GitCommitDescriptor)commits.get(parentSha);
                if (null == parentCommit) {
                    LOGGER.warn("Cannot add (parent) commit with SHA '{}' (excluded by range?)", (Object)parentSha);
                    continue;
                }
                gitCommitDescriptor3.getParents().add(parentCommit);
            }
        }
        for (GitAuthorDescriptor gitAuthor : authors.values()) {
            gitRepositoryDescriptor.getAuthors().add(gitAuthor);
        }
        for (GitFileDescriptor gitFile : files.values()) {
            gitRepositoryDescriptor.getFiles().add(gitFile);
        }
        for (GitBranch gitBranch : branches) {
            GitBranchDescriptor gitBranchDescriptor = (GitBranchDescriptor)store.create(GitBranchDescriptor.class);
            String name = gitBranch.getName();
            name = name.replaceFirst("refs/", "");
            sha = gitBranch.getCommitSha();
            LOGGER.debug("Adding new Branch '{}' with Head '{}'", (Object)name, (Object)sha);
            gitBranchDescriptor.setName(name);
            gitCommitDescriptor = (GitCommitDescriptor)commits.get(sha);
            if (null == gitCommitDescriptor) {
                LOGGER.warn("Cannot retrieve commit '{}' for branch '{}'", (Object)sha, (Object)name);
            }
            gitBranchDescriptor.setHead(gitCommitDescriptor);
            gitRepositoryDescriptor.getBranches().add(gitBranchDescriptor);
        }
        for (GitTag gitTag : tags) {
            GitTagDescriptor gitTagDescriptor = (GitTagDescriptor)store.create(GitTagDescriptor.class);
            String label = gitTag.getLabel();
            label = label.replaceFirst("refs/tags/", "");
            sha = gitTag.getCommitSha();
            LOGGER.debug("Adding new Tag '{}' with Commit '{}'", (Object)label, (Object)sha);
            gitTagDescriptor.setLabel(label);
            gitCommitDescriptor = (GitCommitDescriptor)commits.get(sha);
            if (null == gitCommitDescriptor) {
                LOGGER.warn("Cannot retrieve commit '{}' for tag '{}'", (Object)sha, (Object)label);
            }
            gitTagDescriptor.setCommit(gitCommitDescriptor);
            gitRepositoryDescriptor.getTags().add(gitTagDescriptor);
        }
        GitCommitDescriptor headDescriptor = (GitCommitDescriptor)commits.get(head.getCommitSha());
        gitRepositoryDescriptor.setHead(headDescriptor);
    }

    private void addCommitForAuthor(Map<String, GitAuthorDescriptor> authors, String author, Store store, GitCommitDescriptor gitCommit) {
        if (null != author) {
            if (!authors.containsKey(author)) {
                LOGGER.debug("Adding new author '{}'", (Object)author);
                GitAuthorDescriptor gitAuthor = (GitAuthorDescriptor)store.find(GitAuthorDescriptor.class, author);
                if (null == gitAuthor) {
                    LOGGER.debug("Author '{}' does not exist, have to create a new entity", (Object)author);
                    gitAuthor = (GitAuthorDescriptor)store.create(GitAuthorDescriptor.class);
                    gitAuthor.setIdentString(author);
                }
                gitAuthor.setName(author.substring(0, author.indexOf("<")).trim());
                gitAuthor.setEmail(author.substring(author.indexOf("<") + 1, author.indexOf(">")).trim());
                authors.put(author, gitAuthor);
            }
            authors.get(author).getCommits().add(gitCommit);
        }
    }

    private void addCommitFiles(Store store, GitCommit gitCommit, GitCommitDescriptor gitCommitDescriptor, Map<String, GitFileDescriptor> files) {
        for (GitChange gitChange : gitCommit.getGitChanges()) {
            GitChangeDescriptor gitCommitFile = (GitChangeDescriptor)store.create(GitChangeDescriptor.class);
            gitCommitFile.setModificationKind(gitChange.getModificationKind());
            gitCommitDescriptor.getFiles().add(gitCommitFile);
            this.addAsGitFile(files, gitChange.getRelativePath(), gitCommitFile, store, gitCommit.getDate());
        }
    }

    private void addAsGitFile(Map<String, GitFileDescriptor> files, String relativePath, GitChangeDescriptor change, Store store, Date date) {
        GitFileDescriptor gitFileDescriptor = files.get(relativePath);
        if (gitFileDescriptor == null) {
            gitFileDescriptor = (GitFileDescriptor)store.create(GitFileDescriptor.class);
            gitFileDescriptor.setRelativePath(relativePath);
            files.put(relativePath, gitFileDescriptor);
        }
        change.setModifies(gitFileDescriptor);
        if ("A".equals(change.getModificationKind().toUpperCase())) {
            gitFileDescriptor.setCreatedAt(DATE_TIME_FORMAT.format(date));
            gitFileDescriptor.setCreatedAtEpoch(date.getTime());
        } else if ("M".equals(change.getModificationKind().toUpperCase())) {
            gitFileDescriptor.setLastModificationAt(DATE_TIME_FORMAT.format(date));
            gitFileDescriptor.setLastModificationAtEpoch(date.getTime());
        } else if ("D".equals(change.getModificationKind().toUpperCase())) {
            gitFileDescriptor.setDeletedAt(DATE_TIME_FORMAT.format(date));
            gitFileDescriptor.setDeletedAtEpoch(date.getTime());
        }
    }

    private void setRange(String range) {
        this.range = range;
        LOGGER.info("Git plugin has configured range '{}'", (Object)range);
    }

    protected void configure() {
        super.configure();
        Map properties = this.getProperties();
        String rangeProperty = (String)properties.get(GIT_RANGE);
        if (rangeProperty != null) {
            this.setRange(rangeProperty);
        } else {
            rangeProperty = System.getProperty(GIT_RANGE);
            if (rangeProperty != null) {
                this.setRange(rangeProperty);
            }
        }
    }
}

