/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.git.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import de.kontext_e.jqassistant.plugin.git.scanner.CommitFile;
import de.kontext_e.jqassistant.plugin.git.scanner.GitCommit;
import de.kontext_e.jqassistant.plugin.git.scanner.Parser;
import de.kontext_e.jqassistant.plugin.git.scanner.RunGitLogCommand;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitAuthorDescriptor;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitCommitDescriptor;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitCommitFileDescriptor;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitDescriptor;
import de.kontext_e.jqassistant.plugin.git.store.descriptor.GitFileDescriptor;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitScannerPlugin
extends AbstractScannerPlugin<FileResource, GitDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitScannerPlugin.class);
    public static final String GIT_PATH = "jqassistant.plugin.git.path";
    public static final String GIT_RANGE = "jqassistant.plugin.git.range";
    private String pathToGitCommand = "git";
    private String pathToGitProject = ".";
    private String range = null;

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        boolean isGitDir = path.endsWith("FETCH_HEAD") && ".git".equals(item.getFile().getParent());
        isGitDir |= path.endsWith("ORIG_HEAD") && ".git".equals(item.getFile().getParent());
        if (isGitDir |= path.endsWith("index") && ".git".equals(item.getFile().getParent())) {
            this.pathToGitProject = item.getFile().toPath().getParent().toFile().getAbsolutePath();
            LOGGER.info("Path to git project is " + this.pathToGitProject);
        }
        return isGitDir;
    }

    public GitDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        LOGGER.debug("Git plugin scans " + path);
        Store store = scanner.getContext().getStore();
        GitDescriptor gitDescriptor = (GitDescriptor)store.create(GitDescriptor.class);
        gitDescriptor.setName(path);
        gitDescriptor.setFileName(path);
        try {
            List<String> log = RunGitLogCommand.runGitLog(this.pathToGitCommand, this.pathToGitProject, this.range);
            List<GitCommit> parse = new Parser().parse(log);
            this.addCommits(store, gitDescriptor, parse);
        }
        catch (Exception e) {
            LOGGER.error("Unable to scan git repository: " + e.toString());
            LOGGER.debug("Exception details:", (Throwable)e);
        }
        return gitDescriptor;
    }

    private void addCommits(Store store, GitDescriptor gitDescriptor, List<GitCommit> parse) {
        HashMap<String, GitAuthorDescriptor> authors = new HashMap<String, GitAuthorDescriptor>();
        HashMap<String, GitFileDescriptor> files = new HashMap<String, GitFileDescriptor>();
        for (GitCommit gitCommit : parse) {
            GitCommitDescriptor gitCommitDescriptor = (GitCommitDescriptor)store.create(GitCommitDescriptor.class);
            gitCommitDescriptor.setSha(gitCommit.getSha());
            gitCommitDescriptor.setAuthor(gitCommit.getAuthor());
            gitCommitDescriptor.setDate(gitCommit.getDate());
            gitCommitDescriptor.setMessage(this.buildMessage(gitCommit.getMessage()));
            gitCommitDescriptor.setEpoch(this.epochFromDate(gitCommit.getDate()));
            gitCommitDescriptor.setTime(gitCommit.getDate().substring(11, 19));
            gitDescriptor.getCommits().add(gitCommitDescriptor);
            this.addCommitForAuthor(authors, gitCommit.getAuthor(), store, gitCommitDescriptor);
            this.addCommitFiles(store, gitCommit, gitCommitDescriptor, files);
        }
        for (GitAuthorDescriptor gitAuthor : authors.values()) {
            gitDescriptor.getAuthors().add(gitAuthor);
        }
        for (GitFileDescriptor gitFile : files.values()) {
            gitDescriptor.getFiles().add(gitFile);
        }
    }

    private void addCommitForAuthor(Map<String, GitAuthorDescriptor> authors, String author, Store store, GitCommitDescriptor gitCommit) {
        if (!authors.containsKey(author)) {
            GitAuthorDescriptor gitAutor = (GitAuthorDescriptor)store.create(GitAuthorDescriptor.class);
            gitAutor.setIdentString(author);
            gitAutor.setName(author.substring(0, author.indexOf("<")).trim());
            gitAutor.setEmail(author.substring(author.indexOf("<") + 1, author.indexOf(">")).trim());
            authors.put(author, gitAutor);
        }
        authors.get(author).getCommits().add(gitCommit);
    }

    private void addCommitFiles(Store store, GitCommit gitCommit, GitCommitDescriptor gitCommitDescriptor, Map<String, GitFileDescriptor> files) {
        for (CommitFile commitFile : gitCommit.getCommitFiles()) {
            GitCommitFileDescriptor gitCommitFile = (GitCommitFileDescriptor)store.create(GitCommitFileDescriptor.class);
            gitCommitFile.setModificationKind(commitFile.getModificationKind());
            gitCommitFile.setRelativePath(commitFile.getRelativePath());
            gitCommitDescriptor.getFiles().add(gitCommitFile);
            this.addAsGitFile(files, gitCommitFile, store, gitCommit.getDate());
        }
    }

    private void addAsGitFile(Map<String, GitFileDescriptor> files, GitCommitFileDescriptor commitFile, Store store, String date) {
        if (!files.containsKey(commitFile.getRelativePath())) {
            GitFileDescriptor gitFile = (GitFileDescriptor)store.create(GitFileDescriptor.class);
            gitFile.setRelativePath(commitFile.getRelativePath());
            files.put(commitFile.getRelativePath(), gitFile);
        }
        GitFileDescriptor gitFileDescriptor = files.get(commitFile.getRelativePath());
        gitFileDescriptor.getCommitFiles().add(commitFile);
        if ("A".equals(commitFile.getModificationKind().toUpperCase())) {
            gitFileDescriptor.setCreatedAt(date);
            gitFileDescriptor.setCreatedAtEpoch(this.epochFromDate(date));
        } else if ("M".equals(commitFile.getModificationKind().toUpperCase())) {
            gitFileDescriptor.setLastModificationAt(date);
            gitFileDescriptor.setLastModificationAtEpoch(this.epochFromDate(date));
        } else if ("D".equals(commitFile.getModificationKind().toUpperCase())) {
            gitFileDescriptor.setDeletedAt(date);
            gitFileDescriptor.setDeletedAtEpoch(this.epochFromDate(date));
        }
    }

    private Long epochFromDate(String date) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").parse(date).getTime();
        }
        catch (ParseException e) {
            LOGGER.warn("Could not parse date '" + date + "'", (Throwable)e);
            return null;
        }
    }

    private String buildMessage(List<String> message) {
        StringBuilder builder = new StringBuilder();
        for (String m : message) {
            builder.append(m).append("\n");
        }
        return builder.toString();
    }

    protected void configure() {
        super.configure();
        Map properties = this.getProperties();
        String pathProperty = (String)properties.get(GIT_PATH);
        if (pathProperty != null) {
            this.pathToGitCommand = pathProperty;
        }
        if (System.getProperty(GIT_PATH) != null) {
            this.pathToGitCommand = System.getProperty(GIT_PATH);
        }
        LOGGER.debug("Git plugin uses this git installation: " + this.pathToGitCommand);
        String rangeProperty = (String)properties.get(GIT_RANGE);
        if (rangeProperty != null) {
            this.range = rangeProperty;
        }
        if (System.getProperty(GIT_RANGE) != null) {
            this.range = System.getProperty(GIT_RANGE);
        }
        LOGGER.debug("Git plugin has configured range " + this.range);
    }
}

