/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.git.scanner;

import de.kontext_e.jqassistant.plugin.git.scanner.CommitFile;
import java.util.LinkedList;
import java.util.List;

public class GitCommit {
    private final String sha;
    private final String author;
    private final String date;
    private final List<String> message = new LinkedList<String>();
    private final List<CommitFile> commitFiles = new LinkedList<CommitFile>();

    public GitCommit(String sha, String author, String date, List<CommitFile> currentCommitFiles, List<String> currentMessage) {
        this.sha = sha;
        this.author = author;
        this.date = date;
        this.commitFiles.addAll(currentCommitFiles);
        this.message.addAll(currentMessage);
    }

    public String getSha() {
        return this.sha;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDate() {
        return this.date;
    }

    public List<String> getMessage() {
        return this.message;
    }

    public List<CommitFile> getCommitFiles() {
        return this.commitFiles;
    }

    public String toString() {
        return "GitLogEntry{sha='" + this.sha + '\'' + ", author='" + this.author + '\'' + ", date='" + this.date + '\'' + ", message=" + this.message + ", commitFiles=" + this.commitFiles + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitCommit that = (GitCommit)o;
        if (this.author != null ? !this.author.equals(that.author) : that.author != null) {
            return false;
        }
        if (this.commitFiles != null ? !this.commitFiles.equals(that.commitFiles) : that.commitFiles != null) {
            return false;
        }
        if (this.date != null ? !this.date.equals(that.date) : that.date != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        return !(this.sha != null ? !this.sha.equals(that.sha) : that.sha != null);
    }

    public int hashCode() {
        int result = this.sha != null ? this.sha.hashCode() : 0;
        result = 31 * result + (this.author != null ? this.author.hashCode() : 0);
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.commitFiles != null ? this.commitFiles.hashCode() : 0);
        return result;
    }
}

