/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.git.scanner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class RunGitLogCommand {
    public static List<String> runGitLog(String pathToGitCommand, String pathToGitProject, String range) throws IOException, InterruptedException {
        LinkedList<String> lines = new LinkedList<String>();
        LinkedList<String> errorLines = new LinkedList<String>();
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(pathToGitCommand, "--git-dir=" + pathToGitProject, "log", "--name-status", "--date=iso"));
        if (range != null) {
            args.add(range);
        }
        Process process = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
        RunGitLogCommand.inputReader(lines, process.getInputStream());
        RunGitLogCommand.inputReader(errorLines, process.getErrorStream());
        process.waitFor();
        if (errorLines.size() > 0) {
            System.err.println("errors: " + errorLines);
            throw new RuntimeException("Error on executing git command");
        }
        return lines;
    }

    private static void inputReader(final List<String> lines, final InputStream inputStream) throws IOException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                    while ((line = reader.readLine()) != null) {
                        lines.add(line);
                    }
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }
}

