/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.git.scanner;

import de.kontext_e.jqassistant.plugin.git.scanner.CommitFile;
import de.kontext_e.jqassistant.plugin.git.scanner.GitCommit;
import java.util.LinkedList;
import java.util.List;

public class Parser {
    public List<GitCommit> parse(List<String> lines) {
        LinkedList<GitCommit> logEntries = new LinkedList<GitCommit>();
        String currentSha = null;
        String currentAuthor = null;
        String currentDate = null;
        LinkedList<CommitFile> currentCommitFiles = new LinkedList<CommitFile>();
        LinkedList<String> currentMessage = new LinkedList<String>();
        for (String line : lines) {
            if (line.startsWith("commit")) {
                if (currentSha != null) {
                    logEntries.add(new GitCommit(currentSha, currentAuthor, currentDate, currentCommitFiles, currentMessage));
                    currentAuthor = null;
                    currentDate = null;
                    currentCommitFiles = new LinkedList();
                    currentMessage = new LinkedList();
                }
                currentSha = line.substring("commit ".length()).trim();
                continue;
            }
            if (line.startsWith("Author:")) {
                currentAuthor = line.substring("Author: ".length()).trim();
                continue;
            }
            if (line.startsWith("Date:")) {
                currentDate = line.substring("Date: ".length()).trim();
                continue;
            }
            if (line.startsWith("A") || line.startsWith("M") || line.startsWith("D")) {
                currentCommitFiles.add(new CommitFile(line));
                continue;
            }
            if (line.trim().length() <= 0) continue;
            currentMessage.add(line.trim());
        }
        if (currentSha != null) {
            logEntries.add(new GitCommit(currentSha, currentAuthor, currentDate, currentCommitFiles, currentMessage));
        }
        return logEntries;
    }
}

