/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.excel.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import de.kontext_e.jqassistant.plugin.excel.scanner.ExcelFileReader;
import de.kontext_e.jqassistant.plugin.excel.store.descriptor.ExcelFileDescriptor;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class ExcelFileScannerPlugin
extends AbstractScannerPlugin<FileResource, ExcelFileDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelFileScannerPlugin.class);
    private static final List<String> suffixes = Arrays.asList("xls", "xlsx");

    public boolean accepts(FileResource item, String path, Scope scope) {
        try {
            int beginIndex = path.lastIndexOf(".");
            if (beginIndex > 0) {
                String suffix = path.substring(beginIndex + 1).toLowerCase();
                boolean accepted = suffixes.contains(suffix);
                if (accepted) {
                    LOGGER.info("ExcelFileScannerPlugin accepted path " + path);
                }
                return accepted;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Error while checking path: " + e, (Throwable)e);
            return false;
        }
    }

    public ExcelFileDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) {
        try {
            Store store = scanner.getContext().getStore();
            FileDescriptor fileDescriptor = (FileDescriptor)scanner.getContext().getCurrentDescriptor();
            ExcelFileDescriptor excelFileDescriptor = (ExcelFileDescriptor)store.addDescriptorType((Descriptor)fileDescriptor, ExcelFileDescriptor.class);
            ExcelFileReader excelFileReader = new ExcelFileReader(store, excelFileDescriptor, item.createStream());
            excelFileReader.read();
            return excelFileDescriptor;
        }
        catch (Exception e) {
            LOGGER.error("Error while scanning " + path + ": " + e);
            LOGGER.debug("Details:", (Throwable)e);
            return null;
        }
    }
}

