/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.excel.scanner;

import com.buschmais.jqassistant.core.store.api.Store;
import de.kontext_e.jqassistant.plugin.excel.scanner.CellKey;
import de.kontext_e.jqassistant.plugin.excel.store.descriptor.ExcelCellDescriptor;
import de.kontext_e.jqassistant.plugin.excel.store.descriptor.ExcelFileDescriptor;
import de.kontext_e.jqassistant.plugin.excel.store.descriptor.ExcelRowDescriptor;
import de.kontext_e.jqassistant.plugin.excel.store.descriptor.ExcelSheetDescriptor;
import de.kontext_e.jqassistant.plugin.excel.store.descriptor.ExcelStyleDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFEvaluationWorkbook;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaType;
import org.apache.poi.ss.formula.ptg.AreaPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.Ref3DPxg;
import org.apache.poi.ss.formula.ptg.RefPtg;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelFileReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelFileReader.class);
    private final Store store;
    private final ExcelFileDescriptor excelFileDescriptor;
    private final InputStream inputStream;
    private final Map<CellKey, ExcelCellDescriptor> nameToCellDescriptors = new HashMap<CellKey, ExcelCellDescriptor>();
    private final Map<CellKey, ExcelCellDescriptor> preCreatedCells = new HashMap<CellKey, ExcelCellDescriptor>();

    public ExcelFileReader(Store store, ExcelFileDescriptor excelFileDescriptor, InputStream inputStream) {
        this.store = store;
        this.excelFileDescriptor = excelFileDescriptor;
        this.inputStream = inputStream;
    }

    void read() throws IOException {
        try (Workbook workbook = WorkbookFactory.create((InputStream)this.inputStream);){
            for (Sheet sheet : workbook) {
                this.readSheet(sheet);
            }
        }
    }

    private void readSheet(Sheet sheet) {
        String sheetName = sheet.getSheetName();
        ExcelSheetDescriptor excelSheetDescriptor = (ExcelSheetDescriptor)this.store.create(ExcelSheetDescriptor.class);
        this.excelFileDescriptor.getSheets().add(excelSheetDescriptor);
        excelSheetDescriptor.setName(sheet.getSheetName());
        for (Row row : sheet) {
            ExcelRowDescriptor excelRowDescriptor = (ExcelRowDescriptor)this.store.create(ExcelRowDescriptor.class);
            excelSheetDescriptor.getRows().add(excelRowDescriptor);
            excelRowDescriptor.setRowNumber(row.getRowNum());
            this.setStyle(row.getRowStyle(), excelRowDescriptor);
            for (Cell cell : row) {
                String cellName = this.createName(cell.getAddress());
                CellKey cellKey = new CellKey(sheetName, cellName);
                ExcelCellDescriptor excelCellDescriptor = this.preCreatedCells.get(cellKey) != null ? this.preCreatedCells.get(cellKey) : (ExcelCellDescriptor)this.store.create(ExcelCellDescriptor.class);
                excelRowDescriptor.getCells().add(excelCellDescriptor);
                excelCellDescriptor.setColumn(cell.getAddress().getColumn());
                excelCellDescriptor.setRow(cell.getAddress().getRow());
                excelCellDescriptor.setName(cellName);
                excelCellDescriptor.setType(cell.getCellType().name());
                if (cell.getCellComment() != null && cell.getCellComment().getString() != null) {
                    excelCellDescriptor.setComment(cell.getCellComment().getString().getString());
                }
                this.setStyle(cell.getCellStyle(), excelCellDescriptor);
                this.setCellValue(cell, excelCellDescriptor);
                String targetCellName = excelCellDescriptor.getName();
                this.nameToCellDescriptors.put(new CellKey(sheetName, targetCellName), excelCellDescriptor);
            }
        }
    }

    private String createName(CellAddress address) {
        return address.formatAsString();
    }

    private void setStyle(CellStyle cellStyle, ExcelStyleDescriptor excelStyleDescriptor) {
        if (cellStyle == null) {
            return;
        }
        excelStyleDescriptor.setDataFormat(cellStyle.getDataFormat());
        excelStyleDescriptor.setDataFormatString(cellStyle.getDataFormatString());
        excelStyleDescriptor.setBottomBorderColor(cellStyle.getBottomBorderColor());
        excelStyleDescriptor.setLeftBorderColor(cellStyle.getLeftBorderColor());
        excelStyleDescriptor.setRightBorderColor(cellStyle.getRightBorderColor());
        excelStyleDescriptor.setTopBorderColor(cellStyle.getTopBorderColor());
        excelStyleDescriptor.setBackgroundColor(cellStyle.getFillBackgroundColor());
        excelStyleDescriptor.setForegroundColor(cellStyle.getFillForegroundColor());
        excelStyleDescriptor.setFillPattern(cellStyle.getFillPattern().getCode());
        excelStyleDescriptor.setHidden(cellStyle.getHidden());
        excelStyleDescriptor.setLocked(cellStyle.getLocked());
        excelStyleDescriptor.setQuotePrefix(cellStyle.getQuotePrefixed());
    }

    private void setCellValue(Cell cell, ExcelCellDescriptor excelCellDescriptor) {
        switch (cell.getCellType()) {
            case BOOLEAN: {
                excelCellDescriptor.setBoolValue(cell.getBooleanCellValue());
                break;
            }
            case STRING: {
                excelCellDescriptor.setStringValue(cell.getRichStringCellValue().getString());
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String formattedDate = simpleDateFormat.format(cell.getDateCellValue());
                    excelCellDescriptor.setStringValue(formattedDate);
                    break;
                }
                excelCellDescriptor.setNumericValue(cell.getNumericCellValue());
                break;
            }
            case FORMULA: {
                if (cell.isPartOfArrayFormulaGroup() && cell.getArrayFormulaRange() != null) {
                    LOGGER.info("getArrayFormulaRange(): " + cell.getArrayFormulaRange());
                }
                excelCellDescriptor.setStringValue(cell.getCellFormula());
                this.setDependencies(excelCellDescriptor, cell);
                break;
            }
            case BLANK: {
                excelCellDescriptor.setStringValue("");
                excelCellDescriptor.setBlank(true);
                break;
            }
            default: {
                LOGGER.error("Unknown cell type: " + cell.getCellType());
                excelCellDescriptor.setStringValue("");
            }
        }
    }

    private void setDependencies(ExcelCellDescriptor excelCellDescriptor, Cell cell) {
        Ptg[] ptgs;
        for (Ptg ptg : ptgs = FormulaParser.parse((String)cell.getCellFormula(), (FormulaParsingWorkbook)this.createFpb(cell), (FormulaType)FormulaType.CELL, (int)-1)) {
            this.caseLocalRef(excelCellDescriptor, cell, ptg);
            this.caseRefToOtherSheet(excelCellDescriptor, ptg);
            this.caseArea(excelCellDescriptor, cell, ptg);
        }
    }

    private void caseArea(ExcelCellDescriptor excelCellDescriptor, Cell cell, Ptg ptg) {
        if (ptg instanceof AreaPtg) {
            AreaPtg areaPtg = (AreaPtg)ptg;
            int firstColumn = areaPtg.getFirstColumn();
            int firstRow = areaPtg.getFirstRow();
            int lastColumn = areaPtg.getLastColumn();
            int lastRow = areaPtg.getLastRow();
            Sheet sheet = cell.getSheet();
            for (int row = firstRow; row <= lastRow; ++row) {
                Row sheetRow = sheet.getRow(row);
                for (int col = firstColumn; col <= lastColumn; ++col) {
                    Cell cell1 = sheetRow.getCell(col);
                    String targetCellName = this.createName(cell1.getAddress());
                    String targetSheetName = cell1.getSheet().getSheetName();
                    ExcelCellDescriptor excelCellDescriptor1 = this.nameToCellDescriptors.get(new CellKey(targetSheetName, targetCellName));
                    this.setCellDependency(excelCellDescriptor, targetSheetName, targetCellName, excelCellDescriptor1);
                }
            }
        }
    }

    private void caseRefToOtherSheet(ExcelCellDescriptor excelCellDescriptor, Ptg ptg) {
        if (ptg instanceof Ref3DPxg) {
            Ref3DPxg ref3DPxg = (Ref3DPxg)ptg;
            String sheetName = ref3DPxg.getSheetName();
            String cellName = ref3DPxg.format2DRefAsString();
            CellKey cellKey = new CellKey(sheetName, cellName);
            ExcelCellDescriptor excelCellDescriptor1 = this.nameToCellDescriptors.get(cellKey);
            this.setCellDependency(excelCellDescriptor, sheetName, ptg.toFormulaString(), excelCellDescriptor1);
        }
    }

    private void caseLocalRef(ExcelCellDescriptor excelCellDescriptor, Cell cell, Ptg ptg) {
        if (ptg instanceof RefPtg) {
            String sheetName = cell.getSheet().getSheetName();
            ExcelCellDescriptor excelCellDescriptor1 = this.nameToCellDescriptors.get(new CellKey(sheetName, ptg.toFormulaString()));
            this.setCellDependency(excelCellDescriptor, sheetName, ptg.toFormulaString(), excelCellDescriptor1);
        }
    }

    private void setCellDependency(ExcelCellDescriptor sourceCell, String targetSheetName, String targetCellName, ExcelCellDescriptor targetCell) {
        if (targetCell != null) {
            sourceCell.getDependencies().add(targetCell);
        } else {
            ExcelCellDescriptor excelCellDescriptor2 = (ExcelCellDescriptor)this.store.create(ExcelCellDescriptor.class);
            excelCellDescriptor2.setName(targetCellName);
            CellKey cellKey = new CellKey(targetSheetName, targetCellName);
            this.preCreatedCells.put(cellKey, excelCellDescriptor2);
            sourceCell.getDependencies().add(excelCellDescriptor2);
        }
    }

    private FormulaParsingWorkbook createFpb(Cell cell) {
        XSSFEvaluationWorkbook fpb;
        if (cell instanceof XSSFCell) {
            XSSFWorkbook wb = (XSSFWorkbook)cell.getSheet().getWorkbook();
            fpb = XSSFEvaluationWorkbook.create((XSSFWorkbook)wb);
        } else {
            HSSFWorkbook workbook = (HSSFWorkbook)cell.getSheet().getWorkbook();
            fpb = HSSFEvaluationWorkbook.create((HSSFWorkbook)workbook);
        }
        return fpb;
    }
}

