/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.checkstyle.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import de.kontext_e.jqassistant.plugin.checkstyle.jaxb.CheckstyleType;
import de.kontext_e.jqassistant.plugin.checkstyle.jaxb.ErrorType;
import de.kontext_e.jqassistant.plugin.checkstyle.jaxb.FileType;
import de.kontext_e.jqassistant.plugin.checkstyle.jaxb.ObjectFactory;
import de.kontext_e.jqassistant.plugin.checkstyle.store.descriptor.CheckstyleErrorDescriptor;
import de.kontext_e.jqassistant.plugin.checkstyle.store.descriptor.CheckstyleFileDescriptor;
import de.kontext_e.jqassistant.plugin.checkstyle.store.descriptor.CheckstyleReportDescriptor;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class CheckstyleScannerPlugin
extends AbstractScannerPlugin<FileResource, CheckstyleReportDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckstyleScannerPlugin.class);
    private static final String JQASSISTANT_PLUGIN_CHECKSTYLE_FILENAME = "jqassistant.plugin.checkstyle.filename";
    private static final String JQASSISTANT_PLUGIN_CHECKSTYLE_DIRNAME = "jqassistant.plugin.checkstyle.dirname";
    private JAXBContext jaxbContext;
    private String checkstyleFileName = "checkstyle.xml";
    private String checkstyleDirName = "checkstyle";

    public CheckstyleScannerPlugin() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Cannot create JAXB context.", e);
        }
    }

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        boolean accepted;
        boolean bl = accepted = path.endsWith(this.checkstyleFileName) || this.checkstyleDirName.equals(item.getFile().toPath().getParent().toFile().getName()) && path.endsWith(".xml");
        if (accepted) {
            LOGGER.debug("Checkstyle accepted path " + path);
        }
        return accepted;
    }

    public CheckstyleReportDescriptor scan(FileResource file, String path, Scope scope, Scanner scanner) throws IOException {
        LOGGER.debug("Checkstyle scans path " + path);
        CheckstyleType checkstyleType = this.unmarshalCheckstyleXml(file.createStream());
        FileDescriptor fileDescriptor = (FileDescriptor)scanner.getContext().getCurrentDescriptor();
        CheckstyleReportDescriptor checkstyleReportDescriptor = (CheckstyleReportDescriptor)scanner.getContext().getStore().addDescriptorType((Descriptor)fileDescriptor, CheckstyleReportDescriptor.class);
        this.readFiles(scanner.getContext().getStore(), checkstyleType, checkstyleReportDescriptor);
        return checkstyleReportDescriptor;
    }

    private void readFiles(Store store, CheckstyleType checkstyleType, CheckstyleReportDescriptor checkstyleReportDescriptor) {
        for (FileType fileType : checkstyleType.getFile()) {
            CheckstyleFileDescriptor checkstyleFileDescriptor = (CheckstyleFileDescriptor)store.create(CheckstyleFileDescriptor.class);
            checkstyleFileDescriptor.setName(this.truncateName(fileType.getName()));
            checkstyleFileDescriptor.setPath(fileType.getName());
            checkstyleReportDescriptor.getFiles().add(checkstyleFileDescriptor);
            this.readErrors(store, fileType, checkstyleFileDescriptor);
        }
    }

    private void readErrors(Store store, FileType fileType, CheckstyleFileDescriptor checkstyleFileDescriptor) {
        for (ErrorType errorType : fileType.getError()) {
            CheckstyleErrorDescriptor checkstyleErrorDescriptor = (CheckstyleErrorDescriptor)store.create(CheckstyleErrorDescriptor.class);
            checkstyleErrorDescriptor.setLine(errorType.getLine());
            checkstyleErrorDescriptor.setColumn(errorType.getColumn());
            checkstyleErrorDescriptor.setSeverity(errorType.getSeverity());
            checkstyleErrorDescriptor.setMessage(errorType.getMessage());
            checkstyleErrorDescriptor.setSource(errorType.getSource());
            checkstyleFileDescriptor.getErrors().add(checkstyleErrorDescriptor);
        }
    }

    private String truncateName(String name) {
        if (name.lastIndexOf(System.getProperty("file.separator")) <= 0) {
            return name;
        }
        return name.substring(name.lastIndexOf(System.getProperty("file.separator")) + 1);
    }

    private CheckstyleType unmarshalCheckstyleXml(InputStream streamSource) throws IOException {
        CheckstyleType checkstyleType;
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            checkstyleType = (CheckstyleType)unmarshaller.unmarshal((Source)new StreamSource(streamSource), CheckstyleType.class).getValue();
        }
        catch (JAXBException e) {
            throw new IOException("Cannot read model descriptor.", e);
        }
        return checkstyleType;
    }

    protected void configure() {
        String checkstyleDirNameProperty;
        super.configure();
        String checkstyleFileNameProperty = (String)this.getProperties().get(JQASSISTANT_PLUGIN_CHECKSTYLE_FILENAME);
        if (checkstyleFileNameProperty != null) {
            this.checkstyleFileName = checkstyleFileNameProperty;
        }
        if (System.getProperty(JQASSISTANT_PLUGIN_CHECKSTYLE_FILENAME) != null) {
            this.checkstyleFileName = System.getProperty(JQASSISTANT_PLUGIN_CHECKSTYLE_FILENAME);
        }
        if ((checkstyleDirNameProperty = (String)this.getProperties().get(JQASSISTANT_PLUGIN_CHECKSTYLE_DIRNAME)) != null) {
            this.checkstyleDirName = checkstyleDirNameProperty;
        }
        if (System.getProperty(JQASSISTANT_PLUGIN_CHECKSTYLE_DIRNAME) != null) {
            this.checkstyleDirName = System.getProperty(JQASSISTANT_PLUGIN_CHECKSTYLE_DIRNAME);
        }
        LOGGER.info(String.format("Checkstyle plugin looks for files named %s or for all XML files in directories named '%s'", this.checkstyleFileName, this.checkstyleDirName));
    }
}

