/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.checkstyle.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import de.kontext_e.jqassistant.plugin.checkstyle.jaxb.CheckstyleType;
import de.kontext_e.jqassistant.plugin.checkstyle.jaxb.ErrorType;
import de.kontext_e.jqassistant.plugin.checkstyle.jaxb.FileType;
import de.kontext_e.jqassistant.plugin.checkstyle.jaxb.ObjectFactory;
import de.kontext_e.jqassistant.plugin.checkstyle.store.descriptor.CheckstyleDescriptor;
import de.kontext_e.jqassistant.plugin.checkstyle.store.descriptor.ErrorDescriptor;
import de.kontext_e.jqassistant.plugin.checkstyle.store.descriptor.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class CheckstyleScannerPlugin
extends AbstractScannerPlugin<FileResource, CheckstyleDescriptor> {
    private JAXBContext jaxbContext;
    private static String basePackage = "de.kontext_e.jqassistant.plugin";

    public CheckstyleScannerPlugin() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Cannot create JAXB context.", e);
        }
    }

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        return path.endsWith("checkstyle.xml") || "checkstyle".equals(item.getFile().toPath().getParent().toFile().getName()) && path.endsWith(".xml");
    }

    public CheckstyleDescriptor scan(FileResource file, String path, Scope scope, Scanner scanner) throws IOException {
        CheckstyleType checkstyleType = this.unmarshalCheckstyleXml(file.createStream());
        CheckstyleDescriptor checkstyleDescriptor = (CheckstyleDescriptor)scanner.getContext().getStore().create(CheckstyleDescriptor.class);
        checkstyleDescriptor.setFileName(path);
        this.readFiles(scanner.getContext().getStore(), checkstyleType, checkstyleDescriptor);
        return checkstyleDescriptor;
    }

    private void readFiles(Store store, CheckstyleType checkstyleType, CheckstyleDescriptor checkstyleDescriptor) {
        for (FileType fileType : checkstyleType.getFile()) {
            FileDescriptor fileDescriptor = (FileDescriptor)store.create(FileDescriptor.class);
            fileDescriptor.setName(this.truncateName(fileType.getName()));
            fileDescriptor.setFullQualifiedName(this.convertToFullQualifiedName(fileType.getName()));
            checkstyleDescriptor.getFiles().add(fileDescriptor);
            this.readErrors(store, fileType, fileDescriptor);
        }
    }

    private void readErrors(Store store, FileType fileType, FileDescriptor fileDescriptor) {
        for (ErrorType errorType : fileType.getError()) {
            ErrorDescriptor errorDescriptor = (ErrorDescriptor)store.create(ErrorDescriptor.class);
            errorDescriptor.setLine(errorType.getLine());
            errorDescriptor.setColumn(errorType.getColumn());
            errorDescriptor.setSeverity(errorType.getSeverity());
            errorDescriptor.setMessage(errorType.getMessage());
            errorDescriptor.setSource(errorType.getSource());
            fileDescriptor.getErrors().add(errorDescriptor);
        }
    }

    protected String convertToFullQualifiedName(String name) {
        String separator = "/".equals(System.getProperty("file.separator")) ? "/" : "\\\\";
        String normalizedName = name.replaceAll(separator, ".");
        if (!normalizedName.contains(basePackage)) {
            System.err.println(String.format("Normalized name %s does not contain base package %s", normalizedName, basePackage));
            return "FQN.ERROR";
        }
        if (normalizedName.length() < 5) {
            System.err.println(String.format("Normalized name %s is shorter as expected", normalizedName));
            return "FQN.ERROR";
        }
        return normalizedName.substring(normalizedName.indexOf(basePackage), normalizedName.length() - 5);
    }

    protected String truncateName(String name) {
        if (name.lastIndexOf(System.getProperty("file.separator")) <= 0) {
            return name;
        }
        return name.substring(name.lastIndexOf(System.getProperty("file.separator")) + 1);
    }

    protected CheckstyleType unmarshalCheckstyleXml(InputStream streamSource) throws IOException {
        CheckstyleType checkstyleType;
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            checkstyleType = (CheckstyleType)unmarshaller.unmarshal((Source)new StreamSource(streamSource), CheckstyleType.class).getValue();
        }
        catch (JAXBException e) {
            throw new IOException("Cannot read model descriptor.", e);
        }
        return checkstyleType;
    }

    protected void initialize() {
        String property = (String)this.getProperties().get("jqassistant.plugin.checkstyle.basepackage");
        if (property != null) {
            basePackage = property;
        }
    }
}

