/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.asciidoc.scanner;

import com.buschmais.jqassistant.core.store.api.Store;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocAttribute;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocBlockDescriptor;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocCommonProperties;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocListDescriptor;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocListItemDescriptor;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocSectionDescriptor;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocTableCellDescriptor;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocTableColumnDescriptor;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocTableDescriptor;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocTableRowDescriptor;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.BlockContainer;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Options;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.Column;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.ListItem;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.Section;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.ast.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsciidocImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsciidocImporter.class);
    private static final Asciidoctor asciidoctor = Asciidoctor.Factory.create();
    private final File file;
    private final Store store;
    private final Options parameters = Options.builder().build();

    AsciidocImporter(File file, Store store) {
        this.file = file;
        this.store = store;
    }

    void importDocument(BlockContainer asciidocFile) {
        Document document = asciidoctor.loadFile(this.file, this.parameters);
        this.scanBlocks(document.getBlocks(), asciidocFile);
    }

    void scanBlocks(List<StructuralNode> blocks, BlockContainer blockContainer) {
        for (StructuralNode block : blocks) {
            if (block instanceof ListItem) continue;
            try {
                AsciidocBlockDescriptor blockDescriptor = this.scanOneBlock(block);
                blockContainer.getAsciidocBlocks().add(blockDescriptor);
                this.scanBlocks(block.getBlocks(), blockDescriptor);
            }
            catch (Exception e) {
                LOGGER.warn("Error while scanning Asciidoc block " + block.getNodeName() + "; reason is: " + e, (Throwable)e);
            }
        }
    }

    private AsciidocBlockDescriptor scanOneBlock(StructuralNode block) {
        AsciidocBlockDescriptor blockDescriptor = block instanceof Table ? this.scanTableBlock((Table)block) : (block instanceof org.asciidoctor.ast.List ? this.scanListBlock((org.asciidoctor.ast.List)block) : (block instanceof ListItem ? this.scanListItemBlock((ListItem)block) : (block instanceof Section ? this.scanSectionBlock((Section)block) : (block instanceof Block ? (AsciidocBlockDescriptor)this.store.create(AsciidocBlockDescriptor.class) : (AsciidocBlockDescriptor)this.store.create(AsciidocBlockDescriptor.class)))));
        this.setCommonBlockProperties(block, blockDescriptor);
        return blockDescriptor;
    }

    private AsciidocBlockDescriptor scanListItemBlock(ListItem listItem) {
        AsciidocListItemDescriptor listItemDescriptor = (AsciidocListItemDescriptor)this.store.create(AsciidocListItemDescriptor.class);
        listItemDescriptor.setMarker(listItem.getMarker());
        listItemDescriptor.setText(listItem.getText());
        listItemDescriptor.setHasText(listItem.hasText());
        return listItemDescriptor;
    }

    private AsciidocBlockDescriptor scanListBlock(org.asciidoctor.ast.List list) {
        AsciidocListDescriptor listDescriptor = (AsciidocListDescriptor)this.store.create(AsciidocListDescriptor.class);
        for (StructuralNode structuralNode : list.getItems()) {
            listDescriptor.getListItems().add(this.scanOneBlock(structuralNode));
        }
        this.addAttributes(listDescriptor, list.getAttributes());
        return listDescriptor;
    }

    private AsciidocBlockDescriptor scanSectionBlock(Section section) {
        AsciidocSectionDescriptor sectionDescriptor = (AsciidocSectionDescriptor)this.store.create(AsciidocSectionDescriptor.class);
        sectionDescriptor.setIndex(section.getIndex());
        sectionDescriptor.setNumber(section.getIndex());
        sectionDescriptor.setNumbered(section.isNumbered());
        sectionDescriptor.setSectname(section.getSectionName());
        sectionDescriptor.setSpecial(section.isSpecial());
        this.addAttributes(sectionDescriptor, section.getAttributes());
        return sectionDescriptor;
    }

    private AsciidocTableDescriptor scanTableBlock(Table table) {
        AsciidocTableDescriptor tableDescriptor = (AsciidocTableDescriptor)this.store.create(AsciidocTableDescriptor.class);
        tableDescriptor.setFrame(table.getFrame());
        tableDescriptor.setGrid(table.getGrid());
        this.addAttributes(tableDescriptor, table.getAttributes());
        int colnumber = 0;
        for (Column column : table.getColumns()) {
            tableDescriptor.getAsciidocTableColumns().add(this.scanTableColumn(column, colnumber++));
        }
        int rownumber = 0;
        for (Row row : table.getHeader()) {
            tableDescriptor.getAsciidocTableHeaderRows().add(this.scanTableRow(row, rownumber, tableDescriptor.getAsciidocTableColumns()));
            ++rownumber;
        }
        rownumber = 0;
        for (Row row : table.getBody()) {
            tableDescriptor.getAsciidocTableBodyRows().add(this.scanTableRow(row, rownumber, tableDescriptor.getAsciidocTableColumns()));
            ++rownumber;
        }
        rownumber = 0;
        for (Row row : table.getFooter()) {
            tableDescriptor.getAsciidocTableFooterRows().add(this.scanTableRow(row, rownumber, tableDescriptor.getAsciidocTableColumns()));
            ++rownumber;
        }
        return tableDescriptor;
    }

    private void addAttributes(AsciidocCommonProperties descriptor, Map<String, Object> attributes) {
        for (Map.Entry<String, Object> stringObjectEntry : attributes.entrySet()) {
            AsciidocAttribute asciidocAttribute = (AsciidocAttribute)this.store.create(AsciidocAttribute.class);
            asciidocAttribute.setName(stringObjectEntry.getKey());
            asciidocAttribute.setValue("" + stringObjectEntry.getValue());
            descriptor.getAttributes().add(asciidocAttribute);
        }
    }

    private AsciidocTableColumnDescriptor scanTableColumn(Column column, int colnumber) {
        AsciidocTableColumnDescriptor columnDescriptor = (AsciidocTableColumnDescriptor)this.store.create(AsciidocTableColumnDescriptor.class);
        columnDescriptor.setColnumber(colnumber);
        this.addCommonProperties((ContentNode)column, columnDescriptor);
        return columnDescriptor;
    }

    private void setCommonBlockProperties(StructuralNode block, AsciidocBlockDescriptor blockDescriptor) {
        blockDescriptor.setContext(block.getContext());
        blockDescriptor.setLevel(block.getLevel());
        blockDescriptor.setRole(block.getRole());
        blockDescriptor.setStyle(block.getStyle());
        blockDescriptor.setTitle(block.getTitle());
        blockDescriptor.setReftext(block.getReftext());
        this.addCommonProperties((ContentNode)block, blockDescriptor);
    }

    private AsciidocTableRowDescriptor scanTableRow(Row row, int rownumber, List<AsciidocTableColumnDescriptor> columns) {
        int colNumber = 0;
        AsciidocTableRowDescriptor rowDescriptor = (AsciidocTableRowDescriptor)this.store.create(AsciidocTableRowDescriptor.class);
        rowDescriptor.setRownumber(rownumber);
        for (Cell cell : row.getCells()) {
            AsciidocTableCellDescriptor cellDescriptor = (AsciidocTableCellDescriptor)this.store.create(AsciidocTableCellDescriptor.class);
            rowDescriptor.getAsciidocTableCells().add(cellDescriptor);
            cellDescriptor.setText(cell.getText());
            cellDescriptor.setColumn(columns.get(colNumber));
            cellDescriptor.setColnumber(colNumber++);
            this.addCommonProperties((ContentNode)cell, cellDescriptor);
        }
        return rowDescriptor;
    }

    private void addCommonProperties(ContentNode abstractNode, AsciidocCommonProperties descriptor) {
        descriptor.setContext(abstractNode.getContext());
        descriptor.setReftext(abstractNode.getReftext());
        descriptor.setRole(abstractNode.getRole());
        if (abstractNode instanceof StructuralNode) {
            StructuralNode structuralNode = (StructuralNode)abstractNode;
            descriptor.setStyle(structuralNode.getStyle());
        }
    }

    public static void main(String[] args) {
        new AsciidocImporter(new File("asciidoc/src/test/asciidoc/testfile.adoc"), null).importDocument(null);
    }
}

