/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.asciidoc.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import de.kontext_e.jqassistant.plugin.asciidoc.scanner.AsciidocImporter;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocFileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class AsciidocFileScannerPlugin
extends AbstractScannerPlugin<FileResource, AsciidocFileDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsciidocFileScannerPlugin.class);
    private static final String JQASSISTANT_PLUGIN_ASCIIDOC_SUFFIXES = "jqassistant.plugin.asciidoc.suffixes";
    private static List<String> suffixes = Arrays.asList("asciidoc", "adoc");

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        try {
            int beginIndex = path.lastIndexOf(".");
            if (beginIndex > 0) {
                String suffix = path.substring(beginIndex + 1).toLowerCase();
                boolean accepted = suffixes.contains(suffix);
                if (accepted) {
                    LOGGER.info("Asciidoc accepted path " + path);
                }
                return accepted;
            }
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Error while checking path: " + e, (Throwable)e);
            return false;
        }
    }

    public AsciidocFileDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        try {
            Store store = scanner.getContext().getStore();
            FileDescriptor fileDescriptor = (FileDescriptor)scanner.getContext().getCurrentDescriptor();
            AsciidocFileDescriptor asciidocFileDescriptor = (AsciidocFileDescriptor)store.addDescriptorType((Descriptor)fileDescriptor, AsciidocFileDescriptor.class);
            asciidocFileDescriptor.setFileName(path);
            new AsciidocImporter(item.getFile(), store).importDocument(asciidocFileDescriptor);
            return asciidocFileDescriptor;
        }
        catch (IOException e) {
            LOGGER.error("Error while checking scanning path " + path + ": " + e, (Throwable)e);
            return null;
        }
    }

    protected void configure() {
        super.configure();
        if (this.getProperties().containsKey(JQASSISTANT_PLUGIN_ASCIIDOC_SUFFIXES)) {
            suffixes = new ArrayList<String>();
            String serializedSuffixes = (String)this.getProperties().get(JQASSISTANT_PLUGIN_ASCIIDOC_SUFFIXES);
            for (String suffix : serializedSuffixes.split(",")) {
                suffixes.add(suffix.toLowerCase().trim());
            }
            LOGGER.info("Asciidoc accepts suffixes " + suffixes);
        }
    }
}

