/*
 * Decompiled with CFR 0.152.
 */
package de.kontext_e.jqassistant.plugin.asciidoc.scanner;

import com.buschmais.jqassistant.core.store.api.Store;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocBlockDescriptor;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocCommonProperties;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocListDescriptor;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocListItemDescriptor;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocSectionDescriptor;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocTableCellDescriptor;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocTableColumnDescriptor;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocTableDescriptor;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.AsciidocTableRowDescriptor;
import de.kontext_e.jqassistant.plugin.asciidoc.store.descriptor.BlockContainer;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.ast.AbstractBlock;
import org.asciidoctor.ast.AbstractNode;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.Column;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.ListItem;
import org.asciidoctor.ast.ListNode;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.Section;
import org.asciidoctor.ast.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsciidocImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsciidocImporter.class);
    private static final Asciidoctor asciidoctor = Asciidoctor.Factory.create();
    private final File file;
    private final Store store;
    private final Map<String, Object> parameters = new HashMap<String, Object>();

    AsciidocImporter(File file, Store store, int structureMaxLevel) {
        this.file = file;
        this.store = store;
        this.parameters.put("STRUCTURE_MAX_LEVEL", structureMaxLevel);
    }

    void importDocument(BlockContainer asciidocFile) {
        Document document = asciidoctor.loadFile(this.file, this.parameters);
        this.scanBlocks(document.getBlocks(), asciidocFile);
    }

    private void scanBlocks(List<AbstractBlock> blocks, BlockContainer blockContainer) {
        for (AbstractBlock o : blocks) {
            AbstractBlock block;
            if (!(o instanceof AbstractBlock) || (block = o) instanceof ListItem) continue;
            try {
                AsciidocBlockDescriptor blockDescriptor = this.scanOneBlock(block);
                blockContainer.getAsciidocBlocks().add(blockDescriptor);
                this.scanBlocks(block.getBlocks(), blockDescriptor);
            }
            catch (Exception e) {
                LOGGER.warn("Error while scanning Asciidoc block " + block.getNodeName() + "; reason is: " + e);
            }
        }
    }

    private AsciidocBlockDescriptor scanOneBlock(AbstractBlock block) {
        AsciidocBlockDescriptor blockDescriptor = block instanceof Table ? this.scanTableBlock((Table)block) : (block instanceof ListNode ? this.scanListBlock((ListNode)block) : (block instanceof ListItem ? this.scanListItemBlock((ListItem)block) : (block instanceof Section ? this.scanSectionBlock((Section)block) : (block instanceof Block ? (AsciidocBlockDescriptor)this.store.create(AsciidocBlockDescriptor.class) : (AsciidocBlockDescriptor)this.store.create(AsciidocBlockDescriptor.class)))));
        this.setCommonBlockProperties(block, blockDescriptor);
        return blockDescriptor;
    }

    private AsciidocBlockDescriptor scanListItemBlock(ListItem listItem) {
        AsciidocListItemDescriptor listItemDescriptor = (AsciidocListItemDescriptor)this.store.create(AsciidocListItemDescriptor.class);
        listItemDescriptor.setMarker(listItem.getMarker());
        listItemDescriptor.setText(listItem.getText());
        return listItemDescriptor;
    }

    private AsciidocBlockDescriptor scanListBlock(ListNode list) {
        AsciidocListDescriptor listDescriptor = (AsciidocListDescriptor)this.store.create(AsciidocListDescriptor.class);
        listDescriptor.setIsItem(list.isItem());
        for (Object o : list.getItems()) {
            if (!(o instanceof AbstractBlock)) continue;
            AbstractBlock abstractBlock = (AbstractBlock)o;
            listDescriptor.getListItems().add(this.scanOneBlock(abstractBlock));
        }
        return listDescriptor;
    }

    private AsciidocBlockDescriptor scanSectionBlock(Section section) {
        AsciidocSectionDescriptor sectionDescriptor = (AsciidocSectionDescriptor)this.store.create(AsciidocSectionDescriptor.class);
        sectionDescriptor.setIndex(section.index());
        sectionDescriptor.setNumber(section.number());
        sectionDescriptor.setNumbered(section.numbered());
        sectionDescriptor.setSectname(section.sectname());
        sectionDescriptor.setSpecial(section.special());
        return sectionDescriptor;
    }

    private AsciidocTableDescriptor scanTableBlock(Table table) {
        AsciidocTableDescriptor tableDescriptor = (AsciidocTableDescriptor)this.store.create(AsciidocTableDescriptor.class);
        tableDescriptor.setFrame(table.getFrame());
        tableDescriptor.setGrid(table.getGrid());
        int colnumber = 0;
        for (Column column : table.getColumns()) {
            tableDescriptor.getAsciidocTableColumns().add(this.scanTableColumn(column, colnumber++));
        }
        for (Row row : table.getHeader()) {
            tableDescriptor.getAsciidocTableHeaderRows().add(this.scanTableRow(row));
        }
        for (Row row : table.getBody()) {
            tableDescriptor.getAsciidocTableBodyRows().add(this.scanTableRow(row));
        }
        for (Row row : table.getFooter()) {
            tableDescriptor.getAsciidocTableFooterRows().add(this.scanTableRow(row));
        }
        return tableDescriptor;
    }

    private AsciidocTableColumnDescriptor scanTableColumn(Column column, int colnumber) {
        AsciidocTableColumnDescriptor columnDescriptor = (AsciidocTableColumnDescriptor)this.store.create(AsciidocTableColumnDescriptor.class);
        columnDescriptor.setColnumber(colnumber);
        this.addCommonProperties((AbstractNode)column, columnDescriptor);
        return columnDescriptor;
    }

    private void setCommonBlockProperties(AbstractBlock block, AsciidocBlockDescriptor blockDescriptor) {
        blockDescriptor.setContext(block.getContext());
        blockDescriptor.setLevel(block.getLevel());
        blockDescriptor.setRole(block.getRole());
        blockDescriptor.setStyle(block.getStyle());
        blockDescriptor.setTitle(block.getTitle());
        blockDescriptor.setReftext(block.getReftext());
        this.addCommonProperties((AbstractNode)block, blockDescriptor);
    }

    private AsciidocTableRowDescriptor scanTableRow(Row row) {
        int colNumber = 0;
        AsciidocTableRowDescriptor rowDescriptor = (AsciidocTableRowDescriptor)this.store.create(AsciidocTableRowDescriptor.class);
        for (Cell cell : row.getCells()) {
            AsciidocTableCellDescriptor cellDescriptor = (AsciidocTableCellDescriptor)this.store.create(AsciidocTableCellDescriptor.class);
            rowDescriptor.getAsciidocTableCells().add(cellDescriptor);
            cellDescriptor.setText(cell.getText());
            cellDescriptor.setColnumber(colNumber++);
            this.addCommonProperties((AbstractNode)cell, cellDescriptor);
        }
        return rowDescriptor;
    }

    private void addCommonProperties(AbstractNode abstractNode, AsciidocCommonProperties descriptor) {
        descriptor.setContext(abstractNode.getContext());
        descriptor.setReftext(abstractNode.getReftext());
        descriptor.setRole(abstractNode.getRole());
        descriptor.setStyle(abstractNode.getStyle());
    }

    public static void main(String[] args) {
        new AsciidocImporter(new File("asciidoc/src/test/asciidoc/testfile.adoc"), null, 20).importDocument(null);
    }
}

