/*
 * Decompiled with CFR 0.152.
 */
package de.kodestruktor.grief.core.util;

import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestUtil.class);

    public static String getImplementationBuild(HttpServletRequest request) {
        return ManifestUtil.getManifestAttribute(request, "Implementation-Build");
    }

    public static String getImplementationVersion(HttpServletRequest request) {
        return ManifestUtil.getManifestAttribute(request, "Implementation-Version");
    }

    private static String getManifestAttribute(HttpServletRequest request, String attributeName) {
        String attributeValue = "";
        ServletContext servletContext = request.getSession().getServletContext();
        try (InputStream manifestStream = servletContext.getResourceAsStream("META-INF/MANIFEST.MF");){
            Manifest manifest;
            Attributes mainAttributes;
            if (manifestStream != null && StringUtils.isBlank((CharSequence)(attributeValue = (mainAttributes = (manifest = new Manifest(manifestStream)).getMainAttributes()).getValue(attributeName)))) {
                LOG.warn("Could not find attribute [{}] in manifest", (Object)attributeName);
                attributeValue = "";
            }
        }
        catch (Exception e) {
            LOG.error("Could not read source revision.", (Throwable)e);
        }
        return attributeValue;
    }
}

