/*
 * Decompiled with CFR 0.152.
 */
package de.kodestruktor.grief.core.tag;

import de.kodestruktor.grief.core.util.ConfigurationUtil;
import de.kodestruktor.grief.core.util.GriefConstants;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.tags.RequestContextAwareTag;

public class Favicon
extends RequestContextAwareTag {
    private static final Logger LOG = LoggerFactory.getLogger(Favicon.class);
    private static final long serialVersionUID = 3805265733096516623L;
    private String uri;
    private String staticResource = "false";

    private void init() {
        this.id = StringUtils.isBlank((CharSequence)this.id) ? "" : this.id;
    }

    public int doEndTag() throws JspException {
        this.init();
        String result = "";
        String mimeType = "application/octet-stream";
        String path = ConfigurationUtil.buildImagePath(this.getRequestContext(), this.pageContext, this.uri, StringUtils.equalsIgnoreCase((CharSequence)this.staticResource, (CharSequence)"true"));
        for (Map.Entry<Pattern, String> mimeEntry : GriefConstants.FAVICON_MIME_TYPES.entrySet()) {
            if (!mimeEntry.getKey().matcher(this.uri).matches()) continue;
            mimeType = mimeEntry.getValue();
            break;
        }
        result = String.format("<link href=\"%s\" rel=\"icon\" type=\"%s\" />", path, mimeType);
        JspWriter out = this.pageContext.getOut();
        try {
            out.println(result);
        }
        catch (IOException e) {
            LOG.error("Could not write buffer to out", (Throwable)e);
        }
        return super.doEndTag();
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getStaticResource() {
        return this.staticResource;
    }

    public void setStaticResource(String staticResource) {
        this.staticResource = staticResource;
    }

    protected int doStartTagInternal() throws Exception {
        return 0;
    }
}

