/*
 * Decompiled with CFR 0.152.
 */
package de.kodestruktor.grief.core.util;

import de.kodestruktor.grief.core.util.ManifestUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.springframework.core.env.Environment;
import org.springframework.web.servlet.support.RequestContext;

public class ConfigurationUtil {
    public static String buildImagePath(RequestContext requestContext, PageContext pageContext, String uri, boolean staticResource) {
        return ConfigurationUtil.buildResourcePath(requestContext, pageContext, "grief.resource.dir.image", uri, staticResource);
    }

    public static String buildScriptPath(RequestContext requestContext, PageContext pageContext, String uri, boolean staticResource) {
        return ConfigurationUtil.buildResourcePath(requestContext, pageContext, "grief.resource.dir.script", uri, staticResource);
    }

    public static String buildStylePath(RequestContext requestContext, PageContext pageContext, String uri, boolean staticResource) {
        return ConfigurationUtil.buildResourcePath(requestContext, pageContext, "grief.resource.dir.style", uri, staticResource);
    }

    private static String buildResourcePath(RequestContext requestContext, PageContext pageContext, String relativeLocationProp, String uri, boolean staticResource) {
        Environment env = requestContext.getWebApplicationContext().getEnvironment();
        String rootPath = env.getProperty("grief.parent.application.root");
        String resourceLocation = env.getProperty("grief.resource.dir.base.resource");
        String staticLocation = env.getProperty("grief.resource.dir.base.static");
        String revisionLocationPrefix = env.getProperty("grief.resource.dir.version.prefix");
        String relativeResourceLocation = env.getProperty(relativeLocationProp);
        String revision = ManifestUtil.getImplementationBuild((HttpServletRequest)pageContext.getRequest());
        StringBuffer path = new StringBuffer();
        path.append(rootPath).append(resourceLocation);
        if (staticResource) {
            path.append(staticLocation);
        } else {
            path.append(revisionLocationPrefix).append(revision);
        }
        path.append(relativeResourceLocation).append(uri.startsWith("/") ? "" : "/").append(uri);
        return path.toString();
    }
}

