/*
 * Decompiled with CFR 0.152.
 */
package de.kodestruktor.grief.core.tag;

import de.kodestruktor.grief.core.util.ManifestUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.web.servlet.tags.RequestContextAwareTag;

public class Version
extends RequestContextAwareTag {
    private static final long serialVersionUID = 3805265733096516623L;
    private static final Logger LOG = LoggerFactory.getLogger(Version.class);
    private String style;
    private String type;
    private String version = "-1";
    private String revision = "-1";
    private boolean tagEnabled;
    private boolean metaEnabled;
    private boolean contentEnabled;
    private boolean commentEnabled;

    private void init() {
        Environment env = this.getRequestContext().getWebApplicationContext().getEnvironment();
        this.version = env.getProperty("grief.parent.application.version");
        if (StringUtils.isBlank((CharSequence)this.version)) {
            this.version = ManifestUtil.getImplementationVersion((HttpServletRequest)this.pageContext.getRequest());
        }
        this.revision = ManifestUtil.getImplementationBuild((HttpServletRequest)this.pageContext.getRequest());
        this.tagEnabled = (Boolean)env.getProperty("grief.version.enabled", Boolean.class, (Object)Boolean.FALSE);
        this.metaEnabled = (Boolean)env.getProperty("grief.version.meta.enabled", Boolean.class, (Object)Boolean.FALSE);
        this.contentEnabled = (Boolean)env.getProperty("grief.version.content.enabled", Boolean.class, (Object)Boolean.FALSE);
        this.commentEnabled = (Boolean)env.getProperty("grief.version.comment.enabled", Boolean.class, (Object)Boolean.FALSE);
    }

    public int doEndTag() throws JspException {
        String result = "";
        this.init();
        if (this.isRenderingEnabled()) {
            switch (this.type + "_" + this.style) {
                case "version_meta": {
                    result = String.format("<meta name=\"%s\" content=\"%s\" />", "Version", this.version);
                    break;
                }
                case "revision_meta": {
                    result = String.format("<meta name=\"%s\" content=\"%s\" />", "Revision", this.revision);
                    break;
                }
                case "both_meta": {
                    result = String.format("<meta name=\"%s\" content=\"%sr%s\" />", "Version", this.version, this.revision);
                    break;
                }
                case "version_content": {
                    result = String.format("<span id=\"%s\">%s: %s</span>", "version", "Version", this.version);
                    break;
                }
                case "revision_content": {
                    result = String.format("<span id=\"%s\">%s: %s</span>", "revision", "Revision", this.revision);
                    break;
                }
                case "both_content": {
                    result = String.format("<span id=\"%s\">%s: %sr%s</span>", "version", "Version", this.version, this.revision);
                    break;
                }
                case "version_comment": {
                    result = String.format("<!-- %s: %s -->", "version", this.version);
                    break;
                }
                case "revision_comment": {
                    result = String.format("<!-- %s: %s -->", "revision", this.revision);
                    break;
                }
                case "both_comment": {
                    result = String.format("<!-- %s: %sr%s -->", "Version", this.version, this.revision);
                    break;
                }
            }
        }
        JspWriter out = this.pageContext.getOut();
        try {
            out.println(result);
        }
        catch (IOException e) {
            LOG.error("Could not write buffer to out", (Throwable)e);
        }
        return super.doEndTag();
    }

    protected boolean isRenderingEnabled() {
        if (!this.tagEnabled || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.style, this.type})) {
            return false;
        }
        if ("meta".equals(this.style) && !this.metaEnabled) {
            return false;
        }
        if ("comment".equals(this.style) && !this.commentEnabled) {
            return false;
        }
        return !"content".equals(this.style) || this.contentEnabled;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    protected int doStartTagInternal() throws Exception {
        return 0;
    }
}

