/*
 * Decompiled with CFR 0.152.
 */
package de.kodestruktor.grief.core.tag;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.tags.RequestContextAwareTag;

public class Pagination<T>
extends RequestContextAwareTag {
    private static final Logger LOG = LoggerFactory.getLogger(Pagination.class);
    private static final long serialVersionUID = -6808629135782081070L;
    private Page<T> page;
    private String prevCode = "grief.pagiantion.prev";
    private String nextCode = "grief.pagiantion.next";
    private String uri;
    private String cssClass;
    private String pageSizeParam = "size";
    private String pageNumberParam = "page";

    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        StringBuffer buffer = new StringBuffer();
        Page<T> currentPage = this.getPage();
        String finalUri = this.uri.contains("?") ? (this.uri.endsWith("&") ? this.uri : this.uri + "&") : this.uri + "?" + this.pageSizeParam + "=" + currentPage.getSize() + "&";
        String prev = this.getRequestContext().getWebApplicationContext().getMessage(this.getPrevCode(), null, RequestContextUtils.getLocale((HttpServletRequest)((HttpServletRequest)this.pageContext.getRequest())));
        String next = this.getRequestContext().getWebApplicationContext().getMessage(this.getNextCode(), null, RequestContextUtils.getLocale((HttpServletRequest)((HttpServletRequest)this.pageContext.getRequest())));
        buffer.append("<ul class='");
        if (StringUtils.isNotBlank((CharSequence)this.getCssClass())) {
            buffer.append(this.getCssClass());
        }
        buffer.append("'");
        if (StringUtils.isNotBlank((CharSequence)this.getId())) {
            buffer.append(" id='").append(this.getId()).append("'");
        }
        buffer.append(">");
        if (currentPage.hasPreviousPage()) {
            buffer.append("<li class='prev'><a href='").append(finalUri).append(this.pageNumberParam).append("=").append(currentPage.getNumber() - 1).append("'>").append(prev).append("</a></li>");
        }
        if (currentPage.getTotalPages() > 0) {
            for (int i = 0; i < currentPage.getTotalPages(); ++i) {
                buffer.append("<li");
                if (currentPage.getNumber() == i) {
                    buffer.append(" class='active'");
                }
                buffer.append("><a href='").append(finalUri).append(this.pageNumberParam).append("=").append(i).append("'>").append(i + 1).append("</a></li>");
            }
        }
        if (currentPage.hasNextPage()) {
            buffer.append("<li class='next'><a href='").append(finalUri).append(this.pageNumberParam).append("=").append(currentPage.getNumber() + 1).append("'>").append(next).append("</a></li>");
        }
        buffer.append("</ul>");
        try {
            out.println(buffer.toString());
        }
        catch (IOException e) {
            LOG.error("Could not write buffer to out", (Throwable)e);
        }
        return super.doEndTag();
    }

    public void setPage(Page<T> page) {
        this.page = page;
    }

    public Page<T> getPage() {
        return this.page;
    }

    public String getPrevCode() {
        return this.prevCode;
    }

    public void setPrevCode(String prevCode) {
        this.prevCode = prevCode;
    }

    public String getNextCode() {
        return this.nextCode;
    }

    public void setNextCode(String nextCode) {
        this.nextCode = nextCode;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public String getPageSizeParam() {
        return this.pageSizeParam;
    }

    public void setPageSizeParam(String pageSizeParam) {
        this.pageSizeParam = pageSizeParam;
    }

    public String getPageNumberParam() {
        return this.pageNumberParam;
    }

    public void setPageNumberParam(String pageNumberParam) {
        this.pageNumberParam = pageNumberParam;
    }

    protected int doStartTagInternal() throws Exception {
        return 0;
    }
}

