/*
 * Decompiled with CFR 0.152.
 */
package de.kodestruktor.grief.core.tag;

import de.kodestruktor.grief.core.util.ConfigurationUtil;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.tags.RequestContextAwareTag;

public class Image
extends RequestContextAwareTag {
    private static final Logger LOG = LoggerFactory.getLogger(Image.class);
    private static final long serialVersionUID = 3805265733096516623L;
    private String uri;
    private String cssClass;
    private String alt;
    private String title;
    private String staticResource = "false";

    private void init() {
        this.id = StringUtils.isBlank((CharSequence)this.id) ? "" : this.id;
        this.alt = StringUtils.isBlank((CharSequence)this.alt) ? "" : this.alt;
        this.title = StringUtils.isBlank((CharSequence)this.title) ? "" : this.title;
        this.cssClass = StringUtils.isBlank((CharSequence)this.cssClass) ? "" : this.cssClass;
    }

    public int doEndTag() throws JspException {
        this.init();
        String result = "";
        String path = ConfigurationUtil.buildImagePath(this.getRequestContext(), this.pageContext, this.uri, StringUtils.equalsIgnoreCase((CharSequence)this.staticResource, (CharSequence)"true"));
        result = String.format("<img src=\"%s\" alt=\"%s\" title=\"%s\" class=\"%s\" id=\"%s\" />", path, this.alt, this.title, this.cssClass, this.id);
        JspWriter out = this.pageContext.getOut();
        try {
            out.println(result);
        }
        catch (IOException e) {
            LOG.error("Could not write buffer to out", (Throwable)e);
        }
        return super.doEndTag();
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public String getAlt() {
        return this.alt;
    }

    public void setAlt(String alt) {
        this.alt = alt;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getStaticResource() {
        return this.staticResource;
    }

    public void setStaticResource(String staticResource) {
        this.staticResource = staticResource;
    }

    protected int doStartTagInternal() throws Exception {
        return 0;
    }
}

