/*
 * Decompiled with CFR 0.152.
 */
package scalax.transducers;

import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.PartialFunction;
import scala.Serializable;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scalax.transducers.AsSource;
import scalax.transducers.AsTarget;
import scalax.transducers.Transducer;
import scalax.transducers.TransducerOps;
import scalax.transducers.internal.CollectTransducer;
import scalax.transducers.internal.DistinctTransducer;
import scalax.transducers.internal.DropNthTransducer;
import scalax.transducers.internal.DropRightTransducer;
import scalax.transducers.internal.DropTransducer;
import scalax.transducers.internal.DropWhileTransducer;
import scalax.transducers.internal.EmptyTransducer;
import scalax.transducers.internal.FilterTransducer;
import scalax.transducers.internal.FlatMapTransducer;
import scalax.transducers.internal.ForeachTransducer;
import scalax.transducers.internal.GroupByTransducer;
import scalax.transducers.internal.GroupedTransducer;
import scalax.transducers.internal.MapTransducer;
import scalax.transducers.internal.NoOpTransducer;
import scalax.transducers.internal.OrElseTransducer;
import scalax.transducers.internal.ScanTransducer;
import scalax.transducers.internal.TakeNthTransducer;
import scalax.transducers.internal.TakeRightTransducer;
import scalax.transducers.internal.TakeTransducer;
import scalax.transducers.internal.TakeWhileTransducer;
import scalax.transducers.internal.ZipWithIndexTransducer;

public abstract class TransducerOps$class {
    public static final Transducer empty(TransducerOps $this) {
        return new EmptyTransducer();
    }

    public static final Transducer noop(TransducerOps $this) {
        return new NoOpTransducer();
    }

    public static final Transducer orElse(TransducerOps $this, Function0 cont) {
        return new OrElseTransducer(cont);
    }

    public static final Transducer foreach(TransducerOps $this, Function1 f) {
        return new ForeachTransducer(f);
    }

    public static final Transducer map(TransducerOps $this, Function1 f) {
        return new MapTransducer(f);
    }

    public static final Transducer flatMap(TransducerOps $this, Function1 f, AsSource evidence$1) {
        return new FlatMapTransducer(f, evidence$1);
    }

    public static final Transducer filter(TransducerOps $this, Function1 f) {
        return new FilterTransducer(f);
    }

    public static final Transducer filterNot(TransducerOps $this, Function1 f) {
        return $this.filter(new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$1;

            public final boolean apply(A x) {
                return !BoxesRunTime.unboxToBoolean((Object)this.f$1.apply(x));
            }
            {
                this.f$1 = f$1;
            }
        });
    }

    public static final Transducer collect(TransducerOps $this, PartialFunction pf) {
        return new CollectTransducer(pf);
    }

    public static final Transducer collectFirst(TransducerOps $this, PartialFunction pf) {
        return $this.collect(pf).head();
    }

    public static final Transducer find(TransducerOps $this, Function1 f) {
        return $this.filter(f).head();
    }

    public static final Transducer forall(TransducerOps $this, Function1 f) {
        return $this.collectFirst(new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$2;

            public final <A1 extends A, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object = BoxesRunTime.unboxToBoolean((Object)this.f$2.apply(x1)) ? function1.apply(x1) : BoxesRunTime.boxToBoolean((boolean)false);
                return (B1)object;
            }

            public final boolean isDefinedAt(A x1) {
                boolean bl = !BoxesRunTime.unboxToBoolean((Object)this.f$2.apply(x1));
                return bl;
            }
            {
                this.f$2 = f$2;
            }
        }).orElse(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        });
    }

    public static final Transducer exists(TransducerOps $this, Function1 f) {
        return $this.collectFirst(new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final Function1 f$3;

            public final <A1 extends A, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object = BoxesRunTime.unboxToBoolean((Object)this.f$3.apply(x2)) ? BoxesRunTime.boxToBoolean((boolean)true) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(A x2) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)this.f$3.apply(x2));
                return bl;
            }
            {
                this.f$3 = f$3;
            }
        }).orElse(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        });
    }

    public static final Transducer fold(TransducerOps $this, Object z, Function2 f) {
        return $this.scan(z, f).last();
    }

    public static final Transducer scan(TransducerOps $this, Object z, Function2 f) {
        return new ScanTransducer(z, f);
    }

    public static final Transducer head(TransducerOps $this) {
        return $this.take(1L);
    }

    public static final Transducer last(TransducerOps $this) {
        return $this.takeRight(1);
    }

    public static final Transducer init(TransducerOps $this) {
        return $this.dropRight(1);
    }

    public static final Transducer tail(TransducerOps $this) {
        return $this.drop(1L);
    }

    public static final Transducer take(TransducerOps $this, long n) {
        return n <= 0L ? $this.empty() : new TakeTransducer(n);
    }

    public static final Transducer takeWhile(TransducerOps $this, Function1 f) {
        return new TakeWhileTransducer(f);
    }

    public static final Transducer takeRight(TransducerOps $this, int n) {
        return n <= 0 ? $this.empty() : new TakeRightTransducer(n);
    }

    public static final Transducer takeNth(TransducerOps $this, long n) {
        return n <= 0L ? $this.empty() : (n == 1L ? $this.noop() : new TakeNthTransducer(n));
    }

    public static final Transducer drop(TransducerOps $this, long n) {
        return n <= 0L ? $this.noop() : new DropTransducer(n);
    }

    public static final Transducer dropWhile(TransducerOps $this, Function1 f) {
        return new DropWhileTransducer(f);
    }

    public static final Transducer dropRight(TransducerOps $this, int n) {
        return n <= 0 ? $this.noop() : new DropRightTransducer(n);
    }

    public static final Transducer dropNth(TransducerOps $this, long n) {
        return n <= 1L ? $this.empty() : new DropNthTransducer(n);
    }

    public static final Transducer slice(TransducerOps $this, long from, long until) {
        long lower = package$.MODULE$.max(from, 0L);
        return until <= lower ? $this.empty() : $this.drop(lower).take(until - lower);
    }

    public static final Transducer distinct(TransducerOps $this) {
        return new DistinctTransducer();
    }

    public static final Transducer zipWithIndex(TransducerOps $this) {
        return new ZipWithIndexTransducer();
    }

    public static final Transducer grouped(TransducerOps $this, int n, AsTarget evidence$2) {
        return n <= 0 ? $this.empty() : new GroupedTransducer(n, evidence$2);
    }

    public static final Transducer groupBy(TransducerOps $this, Function1 f, AsTarget evidence$3) {
        return new GroupByTransducer(f, evidence$3);
    }

    public static void $init$(TransducerOps $this) {
    }
}

